/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gridgain.internal.cdc.api.Violation;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;

public class SinkStatus {
    private final SinkDefinition definition;
    private final List<Violation> violations;

    private SinkStatus(SinkDefinition definition, List<Violation> violations) {
        this.definition = definition;
        this.violations = violations;
    }

    public SinkDefinition definition() {
        return this.definition;
    }

    public List<Violation> violations() {
        return this.violations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean success() {
        return this.violations.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SinkStatus that = (SinkStatus)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.violations, that.violations);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.violations);
    }

    public String toString() {
        return "SinkStatus{definition=" + this.definition + ", violations=" + this.violations + "}";
    }

    public static class Builder {
        private SinkDefinition definition;
        private List<Violation> violations;

        public Builder definition(SinkDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder violation(List<Violation> violations) {
            this.violations = violations;
            return this;
        }

        public Builder violation(Violation violation) {
            if (this.violations == null) {
                this.violations = new ArrayList<Violation>();
            }
            this.violations.add(violation);
            return this;
        }

        public SinkStatus build() {
            Objects.requireNonNull(this.definition, "Sink definition must be provided.");
            Objects.requireNonNull(this.violations, "Violations must be provided.");
            return new SinkStatus(this.definition, this.violations);
        }
    }
}

