/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.ReadIndexRequestImpl;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class ReadIndexRequestSerializer
implements MessageSerializer<RpcRequests.ReadIndexRequest> {
    public static final ReadIndexRequestSerializer INSTANCE = new ReadIndexRequestSerializer();

    private ReadIndexRequestSerializer() {
    }

    @Override
    public boolean writeMessage(RpcRequests.ReadIndexRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadIndexRequestImpl message = (ReadIndexRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.readIndexRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeList("entriesList", message.entriesList(), MessageCollectionItemType.BYTE_BUFFER);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("peerId", message.peerId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("serverId", message.serverId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

