/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.PingRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class PingRequestDeserializer
implements MessageDeserializer<RpcRequests.PingRequest> {
    private final PingRequestBuilder msg;

    PingRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.pingRequest();
    }

    @Override
    public Class<RpcRequests.PingRequest> klass() {
        return RpcRequests.PingRequest.class;
    }

    @Override
    public RpcRequests.PingRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.pingRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("sendTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.sendTimestamp(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.PingRequest.class);
    }
}

