/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import java.util.Collection;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;
import org.apache.ignite3.raft.jraft.entity.SnapshotMetaBuilder;

class SnapshotMetaDeserializer
implements MessageDeserializer<RaftOutter.SnapshotMeta> {
    private final SnapshotMetaBuilder msg;

    SnapshotMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMeta();
    }

    @Override
    public Class<RaftOutter.SnapshotMeta> klass() {
        return RaftOutter.SnapshotMeta.class;
    }

    @Override
    public RaftOutter.SnapshotMeta getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.snapshotMeta());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("cfgIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cfgIndex(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("cfgTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cfgTerm(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("lastIncludedIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedIndex(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("lastIncludedTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedTerm(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readCollection("learnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.learnersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldLearnersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldPeersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readCollection("peersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.peersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 8: {
                long tmp = reader.readLong("oldSequenceToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldSequenceToken(tmp);
                reader.incrementState();
            }
            case 9: {
                long tmp = reader.readLong("sequenceToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.sequenceToken(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.SnapshotMeta.class);
    }
}

