/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.internal.util.IgniteSpinReadWriteLock;

public class IgniteSpinBusyLock
implements IgniteBusyLock {
    private final IgniteSpinReadWriteLock lock = new IgniteSpinReadWriteLock();

    @Override
    public boolean enterBusy() {
        return !this.lock.writeLockedByCurrentThread() && this.lock.tryReadLock();
    }

    public boolean blockedByCurrentThread() {
        return this.lock.writeLockedByCurrentThread();
    }

    @Override
    public void leaveBusy() {
        this.lock.readUnlock();
    }

    public void block() {
        this.lock.writeLock();
    }

    public boolean tryBlock(long millis) throws InterruptedException {
        return this.lock.tryWriteLock(millis, TimeUnit.MILLISECONDS);
    }

    public void unblock() {
        this.lock.writeUnlock();
    }
}

