/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.storage.state.rocksdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageException;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbPartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class TxStateRocksDbStorage
implements TxStateStorage {
    static final int TABLE_OR_ZONE_ID_SIZE_BYTES = 4;
    static final int TABLE_OR_ZONE_PREFIX_SIZE_BYTES = 4;
    private final AtomicReferenceArray<TxStateRocksDbPartitionStorage> storages;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    final int id;
    final TxStateRocksDbSharedStorage sharedStorage;

    public TxStateRocksDbStorage(int id, int partitions, TxStateRocksDbSharedStorage sharedStorage) {
        this.id = id;
        this.storages = new AtomicReferenceArray(partitions);
        this.sharedStorage = sharedStorage;
    }

    private void checkPartitionId(int partitionId) {
        if (partitionId < 0 || partitionId >= this.storages.length()) {
            throw new IllegalArgumentException(S.toString("Unable to access partition with id outside of configured range", "tableId/zoneId", (Object)this.id, false, "partitionId", (Object)partitionId, false, "partitions", (Object)this.storages.length(), false));
        }
    }

    @Override
    public TxStateRocksDbPartitionStorage getOrCreatePartitionStorage(int partitionId) {
        this.checkPartitionId(partitionId);
        TxStateRocksDbPartitionStorage storage = this.storages.get(partitionId);
        if (storage == null) {
            storage = this.createPartitionStorage(partitionId);
            storage.start();
        }
        this.storages.set(partitionId, storage);
        return storage;
    }

    protected TxStateRocksDbPartitionStorage createPartitionStorage(int partitionId) {
        return new TxStateRocksDbPartitionStorage(partitionId, this);
    }

    @Override
    @Nullable
    public TxStatePartitionStorage getPartitionStorage(int partitionId) {
        return this.storages.get(partitionId);
    }

    @Override
    public void destroyPartitionStorage(int partitionId) {
        this.checkPartitionId(partitionId);
        TxStatePartitionStorage storage = this.storages.getAndSet(partitionId, null);
        if (storage != null) {
            storage.destroy();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        try {
            ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
            for (int i = 0; i < this.storages.length(); ++i) {
                TxStatePartitionStorage storage = this.storages.get(i);
                if (storage == null) continue;
                resources.add(storage::close);
            }
            Collections.reverse(resources);
            IgniteUtils.closeAll(resources);
        }
        catch (Exception e) {
            throw new TxStateStorageException("Failed to stop transaction state storage [tableOrZoneId={}]", (Throwable)e, this.id);
        }
    }

    @Override
    public void destroy() {
        this.close();
        this.sharedStorage.destroyStorage(this.id);
    }
}

