/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxStateMetaMessage;
import org.apache.ignite3.internal.tx.message.TxStateMetaMessageImpl;

class TxStateMetaMessageSerializer
implements MessageSerializer<TxStateMetaMessage> {
    public static final TxStateMetaMessageSerializer INSTANCE = new TxStateMetaMessageSerializer();

    private TxStateMetaMessageSerializer() {
    }

    @Override
    public boolean writeMessage(TxStateMetaMessage msg, MessageWriter writer) throws MessageMappingException {
        TxStateMetaMessageImpl message = (TxStateMetaMessageImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txStateMetaMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoxedLong("cleanupCompletionTimestamp", message.cleanupCompletionTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("commitPartitionId", message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoxedLong("initialVacuumObservationTimestamp", message.initialVacuumObservationTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoxedBoolean("isFinishedDueToTimeout", message.isFinishedDueToTimeout());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeUuid("txCoordinatorId", message.txCoordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                int idShifted = message.txState() == null ? 0 : message.txState().id() + 1;
                boolean written = writer.writeInt("txState", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

