/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.thread;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.jetbrains.annotations.Nullable;

public class ThreadUtils {
    public static final String THREAD_DUMP_MSG = "Thread dump at ";
    private static final DateTimeFormatter THREAD_DUMP_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter SHORT_DATE_FMT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final String NL = System.lineSeparator();

    public static void dumpThreads(IgniteLogger log, @Nullable String message, boolean isErrorLevel) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        Set<Long> deadlockedThreadsIds = ThreadUtils.getDeadlockedThreadIds(mxBean);
        if (deadlockedThreadsIds.isEmpty()) {
            ThreadUtils.logMessage(log, "No deadlocked threads detected.", isErrorLevel);
        } else {
            ThreadUtils.logMessage(log, "Deadlocked threads detected (see thread dump below) [deadlockedThreadsCount=" + deadlockedThreadsIds.size() + "]", isErrorLevel);
        }
        ThreadInfo[] threadInfos = mxBean.dumpAllThreads(mxBean.isObjectMonitorUsageSupported(), mxBean.isSynchronizerUsageSupported());
        StringBuilder sb = new StringBuilder(THREAD_DUMP_MSG).append(message == null ? "" : message).append(THREAD_DUMP_FMT.format(Instant.ofEpochMilli(System.currentTimeMillis()))).append(NL);
        for (ThreadInfo info : threadInfos) {
            if (info == null) continue;
            ThreadUtils.printThreadInfo(info, sb, deadlockedThreadsIds);
            sb.append(NL);
            if (info.getLockedSynchronizers() == null || info.getLockedSynchronizers().length <= 0) continue;
            ThreadUtils.printSynchronizersInfo(info.getLockedSynchronizers(), sb);
            sb.append(NL);
        }
        sb.append(NL);
        ThreadUtils.logMessage(log, sb.toString(), isErrorLevel);
    }

    private static void logMessage(IgniteLogger log, String message, boolean isErrorLevel) {
        if (isErrorLevel) {
            log.error(message, new Object[0]);
        } else {
            log.warn(message, new Object[0]);
        }
    }

    private static Set<Long> getDeadlockedThreadIds(ThreadMXBean mxBean) {
        Set<Long> deadlockedThreadsIds;
        long[] deadlockedIds;
        long[] lArray = deadlockedIds = mxBean.isSynchronizerUsageSupported() ? mxBean.findDeadlockedThreads() : null;
        if (deadlockedIds != null && deadlockedIds.length != 0) {
            HashSet<Long> set = new HashSet<Long>();
            for (long id : deadlockedIds) {
                set.add(id);
            }
            deadlockedThreadsIds = Collections.unmodifiableSet(set);
        } else {
            deadlockedThreadsIds = Collections.emptySet();
        }
        return deadlockedThreadsIds;
    }

    private static void printThreadInfo(ThreadInfo threadInfo, StringBuilder stringBuilder, Set<Long> deadlockedIdSet) {
        long id = threadInfo.getThreadId();
        if (deadlockedIdSet.contains(id)) {
            stringBuilder.append("##### DEADLOCKED ");
        }
        stringBuilder.append("Thread [name=\"").append(threadInfo.getThreadName()).append("\", id=").append(threadInfo.getThreadId()).append(", state=").append((Object)threadInfo.getThreadState()).append(", blockCnt=").append(threadInfo.getBlockedCount()).append(", waitCnt=").append(threadInfo.getWaitedCount()).append(']').append(NL);
        LockInfo lockInfo = threadInfo.getLockInfo();
        if (lockInfo != null) {
            stringBuilder.append("    Lock [object=").append(lockInfo).append(", ownerName=").append(threadInfo.getLockOwnerName()).append(", ownerId=").append(threadInfo.getLockOwnerId()).append(']').append(NL);
        }
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        StackTraceElement[] elements = threadInfo.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement e = elements[i];
            stringBuilder.append("        at ").append(e.toString());
            for (MonitorInfo monitor : monitors) {
                if (monitor.getLockedStackDepth() != i) continue;
                stringBuilder.append(NL).append("        - locked ").append(monitor);
            }
            stringBuilder.append(NL);
        }
    }

    private static void printSynchronizersInfo(LockInfo[] syncs, StringBuilder stringBuilder) {
        stringBuilder.append("    Locked synchronizers:");
        for (LockInfo info : syncs) {
            stringBuilder.append(NL).append("        ").append(info);
        }
    }

    @Deprecated
    public static void dumpStack(IgniteLogger log, String message, Object ... params) {
        String reason = "Dumping stack";
        Exception err = new Exception(IgniteStringFormatter.format(message, params));
        if (log != null) {
            log.warn(reason, (Throwable)err);
        } else {
            System.err.println("[" + LocalDateTime.now().format(SHORT_DATE_FMT) + "] (err) " + reason);
            err.printStackTrace(System.err);
        }
    }
}

