/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.tombstones.Tombstone;
import org.apache.ignite3.internal.storage.tombstones.TombstonesCursor;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class PageMemoryTombstonesCursor
extends TombstonesCursor {
    private final AbstractPageMemoryMvPartitionStorage storage;
    private final Cursor<Tombstone> cursor;

    public PageMemoryTombstonesCursor(AbstractPageMemoryMvPartitionStorage storage, Cursor<Tombstone> cursor, @Nullable HybridTimestamp fromExcluding, @Nullable HybridTimestamp toIncluding) {
        super(fromExcluding, toIncluding);
        this.storage = storage;
        this.cursor = cursor;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public boolean hasNext() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            return super.hasNext();
        });
    }

    @Override
    public Tombstone next() {
        return this.storage.busy(() -> {
            this.storage.throwExceptionIfStorageNotInRunnableState();
            return super.next();
        });
    }

    @Override
    protected void advanceIfNeeded() {
        if (this.next != null) {
            return;
        }
        while (this.shouldAdvance() && this.cursor.hasNext()) {
            this.next = (Tombstone)this.cursor.next();
        }
        if (this.shouldAdvance()) {
            this.next = null;
        }
    }
}

