/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.statistic;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CreateTableEventParameters;
import org.apache.ignite3.internal.catalog.events.DropTableEventParameters;
import org.apache.ignite3.internal.event.AbstractEventProducer;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.lowwatermark.event.ChangeLowWatermarkEventParameters;
import org.apache.ignite3.internal.lowwatermark.event.LowWatermarkEvent;
import org.apache.ignite3.internal.sql.engine.statistic.PartitionModificationInfo;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticUpdateManager;
import org.apache.ignite3.internal.sql.engine.statistic.StatisticAggregator;
import org.apache.ignite3.internal.sql.engine.statistic.event.StatisticChangedEvent;
import org.apache.ignite3.internal.sql.engine.statistic.event.StatisticEventParameters;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.LongPriorityQueue;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class SqlStatisticManagerImpl
extends AbstractEventProducer<StatisticChangedEvent, StatisticEventParameters>
implements SqlStatisticUpdateManager {
    private static final IgniteLogger LOG = Loggers.forClass(SqlStatisticManagerImpl.class);
    static final long DEFAULT_TABLE_SIZE = 1L;
    private static final ActualSize DEFAULT_VALUE = new ActualSize(1L, Long.MIN_VALUE);
    private final EventListener<ChangeLowWatermarkEventParameters> lwmListener = EventListener.fromConsumer(this::onLwmChanged);
    private final EventListener<DropTableEventParameters> dropTableEventListener = EventListener.fromConsumer(this::onTableDrop);
    private final EventListener<CreateTableEventParameters> createTableEventListener = EventListener.fromConsumer(this::onTableCreate);
    private final AtomicReference<CompletableFuture<Void>> latestUpdateFut = new AtomicReference(CompletableFutures.nullCompletedFuture());
    private final LongPriorityQueue<DestroyTableEvent> destructionEventsQueue = new LongPriorityQueue<DestroyTableEvent>(DestroyTableEvent::catalogVersion);
    private final TableManager tableManager;
    private final CatalogService catalogService;
    private final LowWatermark lowWatermark;
    final ConcurrentMap<Integer, ActualSize> tableSizeMap = new ConcurrentHashMap<Integer, ActualSize>();
    Set<Integer> droppedTables = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Supplier<Boolean> safeToCallStatUpdate;
    private final ScheduledExecutorService scheduler;
    private final StatisticAggregator<Collection<InternalTable>, CompletableFuture<Int2ObjectMap<PartitionModificationInfo>>> statSupplier;
    static final long INITIAL_DELAY = 15000L;
    static final long REFRESH_PERIOD = 15000L;

    public SqlStatisticManagerImpl(TableManager tableManager, CatalogService catalogService, LowWatermark lowWatermark, ScheduledExecutorService scheduler, StatisticAggregator<Collection<InternalTable>, CompletableFuture<Int2ObjectMap<PartitionModificationInfo>>> statSupplier, Supplier<Boolean> safeToCallStatUpdate) {
        this.tableManager = tableManager;
        this.catalogService = catalogService;
        this.lowWatermark = lowWatermark;
        this.scheduler = scheduler;
        this.statSupplier = statSupplier;
        this.safeToCallStatUpdate = safeToCallStatUpdate;
    }

    @Override
    public long tableSize(int tableId) {
        return this.tableSizeMap.getOrDefault(tableId, DEFAULT_VALUE).getSize();
    }

    @Override
    public void start() {
        this.catalogService.listen(CatalogEvent.TABLE_CREATE, this.createTableEventListener);
        this.catalogService.listen(CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.lowWatermark.listen(LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
        int earliestVersion = this.catalogService.earliestCatalogVersion();
        int latestVersion = this.catalogService.latestCatalogVersion();
        for (int version = earliestVersion; version <= latestVersion; ++version) {
            Collection<CatalogTableDescriptor> tables = this.catalogService.catalog(version).tables();
            for (CatalogTableDescriptor table : tables) {
                this.tableSizeMap.putIfAbsent(table.id(), DEFAULT_VALUE);
            }
        }
        this.scheduler.scheduleAtFixedRate(this::update, 15000L, 15000L, TimeUnit.MILLISECONDS);
    }

    private void update() {
        if (!this.safeToCallStatUpdate.get().booleanValue() || !this.latestUpdateFut.get().isDone()) {
            return;
        }
        ArrayList<InternalTable> tables = new ArrayList<InternalTable>(this.tableSizeMap.size());
        for (Map.Entry ent : this.tableSizeMap.entrySet()) {
            Integer tableId = (Integer)ent.getKey();
            if (this.droppedTables.contains(tableId)) continue;
            TableViewInternal tableView = this.tableManager.cachedTable(tableId);
            if (tableView == null) {
                LOG.debug("No table found to update statistics [id={}].", ent.getKey());
                continue;
            }
            tables.add(tableView.internalTable());
        }
        CompletionStage updateResult = this.statSupplier.estimatedSizeWithLastUpdate(tables).handle((infos, err) -> {
            for (Int2ObjectMap.Entry ent : infos.int2ObjectEntrySet()) {
                int tableId = ent.getIntKey();
                PartitionModificationInfo info = (PartitionModificationInfo)ent.getValue();
                if (err != null) {
                    LOG.debug("Failed to update table statistics for [tableId={}].", (Throwable)err, (Object)tableId);
                    continue;
                }
                ActualSize updatedSize = new ActualSize(Math.max(info.getEstimatedSize(), 1L), info.lastModificationCounter());
                ActualSize currentSize = (ActualSize)this.tableSizeMap.get(tableId);
                this.tableSizeMap.compute(tableId, (k, v) -> v != null && v.modificationCounter() > info.lastModificationCounter() ? v : updatedSize);
                if (updatedSize.modificationCounter() < currentSize.modificationCounter()) continue;
                this.fireEvent(StatisticChangedEvent.STATISTIC_CHANGED, new StatisticEventParameters(tableId));
            }
            return null;
        });
        this.latestUpdateFut.updateAndGet(arg_0 -> SqlStatisticManagerImpl.lambda$update$3((CompletableFuture)updateResult, arg_0));
    }

    @Override
    public void stop() {
        this.lowWatermark.removeListener(LowWatermarkEvent.LOW_WATERMARK_CHANGED, this.lwmListener);
        this.catalogService.removeListener(CatalogEvent.TABLE_DROP, this.dropTableEventListener);
        this.catalogService.removeListener(CatalogEvent.TABLE_CREATE, this.createTableEventListener);
    }

    private void onTableDrop(DropTableEventParameters parameters) {
        int tableId = parameters.tableId();
        int catalogVersion = parameters.catalogVersion();
        this.destructionEventsQueue.enqueue(new DestroyTableEvent(catalogVersion, tableId));
        this.droppedTables.add(tableId);
    }

    private void onTableCreate(CreateTableEventParameters parameters) {
        this.tableSizeMap.put(parameters.tableId(), DEFAULT_VALUE);
    }

    private void onLwmChanged(ChangeLowWatermarkEventParameters parameters) {
        int earliestVersion = this.catalogService.activeCatalogVersion(parameters.newLowWatermark().longValue());
        List<DestroyTableEvent> events = this.destructionEventsQueue.drainUpTo(earliestVersion);
        events.forEach(event -> this.tableSizeMap.remove(event.tableId()));
        events.forEach(event -> this.droppedTables.remove(event.tableId()));
    }

    @TestOnly
    public CompletableFuture<Void> lastUpdateStatisticFuture() {
        return this.latestUpdateFut.get();
    }

    @TestOnly
    public void forceUpdateAll() {
        this.update();
    }

    private static /* synthetic */ CompletableFuture lambda$update$3(CompletableFuture updateResult, CompletableFuture prev) {
        return prev == null ? updateResult : prev.thenCompose(none -> updateResult);
    }

    static class ActualSize {
        long modificationCounter;
        long size;

        ActualSize(long size, long modificationCounter) {
            this.modificationCounter = modificationCounter;
            this.size = size;
        }

        public long modificationCounter() {
            return this.modificationCounter;
        }

        long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualSize that = (ActualSize)o;
            return this.modificationCounter == that.modificationCounter && this.size == that.size;
        }

        public int hashCode() {
            return Objects.hash(this.modificationCounter, this.size);
        }
    }

    private static class DestroyTableEvent {
        final int catalogVersion;
        final int tableId;

        DestroyTableEvent(int catalogVersion, int tableId) {
            this.catalogVersion = catalogVersion;
            this.tableId = tableId;
        }

        public int catalogVersion() {
            return this.catalogVersion;
        }

        public int tableId() {
            return this.tableId;
        }
    }
}

