/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Litmus;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.ZoneOptionEnum;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlZoneOption
extends SqlCall {
    private static final SqlOperator OPERATOR = new Operator();
    private final SqlIdentifier key;
    private final SqlNode value;

    public IgniteSqlZoneOption(SqlIdentifier key, SqlNode value, SqlParserPos pos) {
        super(pos);
        assert (key.isSimple()) : key;
        this.key = key;
        this.value = value;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return List.of(this.key, this.value);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new IgniteSqlZoneOption(this.key, this.value, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        try {
            writer.keyword(ZoneOptionEnum.valueOf((String)((String)this.key.names.get((int)0))).sqlName);
        }
        catch (IllegalArgumentException ignored) {
            this.key.unparse(writer, leftPrec, rightPrec);
        }
        this.value.unparse(writer, leftPrec, rightPrec);
    }

    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof IgniteSqlZoneOption)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        IgniteSqlZoneOption that = (IgniteSqlZoneOption)node;
        if (this.key != that.key) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        return this.value.equalsDeep(that.value, litmus);
    }

    public SqlIdentifier key() {
        return this.key;
    }

    public SqlNode value() {
        return this.value;
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        protected Operator() {
            super("ZoneOption", SqlKind.OTHER);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlZoneOption((SqlIdentifier)operands[0], operands[1], pos);
        }
    }
}

