/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.metadata.IgniteMdRowCount;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.util.CollectionUtils;

public abstract class AbstractIgniteJoin
extends Join
implements TraitsAwareIgniteRel {
    protected final JoinInfo joinInfo;

    protected AbstractIgniteJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, List.of(), left, right, condition, variablesSet, joinType);
        JoinInfo baseJoinInfo = super.analyzeCondition();
        this.joinInfo = baseJoinInfo.isEqui() ? baseJoinInfo : JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
    }

    public JoinInfo analyzeCondition() {
        return this.joinInfo;
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RelCollation collation = TraitUtils.collation(left);
        if (this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL) {
            for (RelFieldCollation field : collation.getFieldCollations()) {
                if (RelFieldCollation.NullDirection.LAST.nullComparison == field.nullDirection.nullComparison) continue;
                collation = RelCollations.EMPTY;
                break;
            }
        }
        RelTraitSet outTraits = nodeTraits.replace((RelTrait)collation);
        RelTraitSet leftTraits = left.replace((RelTrait)collation);
        RelTraitSet rightTraits = right.replace((RelTrait)RelCollations.EMPTY);
        return List.of(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet rightTraits;
        RelTraitSet leftTraits;
        RelTraitSet outTraits;
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        ArrayList<Pair<RelTraitSet, List<RelTraitSet>>> res = new ArrayList<Pair<RelTraitSet, List<RelTraitSet>>>();
        IgniteDistribution leftDistr = TraitUtils.distribution(left);
        IgniteDistribution rightDistr = TraitUtils.distribution(right);
        IgniteDistribution left2rightProjectedDistr = leftDistr.apply(this.buildTransposeMapping(true));
        IgniteDistribution right2leftProjectedDistr = rightDistr.apply(this.buildTransposeMapping(false));
        if (leftDistr == IgniteDistributions.broadcast() && rightDistr == IgniteDistributions.broadcast()) {
            outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.broadcast());
            leftTraits = left.replace((RelTrait)IgniteDistributions.broadcast());
            rightTraits = right.replace((RelTrait)IgniteDistributions.broadcast());
        } else {
            outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.single());
            leftTraits = left.replace((RelTrait)IgniteDistributions.single());
            rightTraits = right.replace((RelTrait)IgniteDistributions.single());
        }
        res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        if (CollectionUtils.nullOrEmpty(this.joinInfo.pairs())) {
            return List.copyOf(res);
        }
        Mappings.TargetMapping offsetByLeftSize = Commons.targetOffsetMapping(this.right.getRowType().getFieldCount(), this.left.getRowType().getFieldCount());
        if (leftDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED && left2rightProjectedDistr != IgniteDistributions.random()) {
            this.computeHashOutputOptions(nodeTraits, left, leftDistr, right, left2rightProjectedDistr, res, offsetByLeftSize);
        }
        if (rightDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED && right2leftProjectedDistr != IgniteDistributions.random()) {
            this.computeHashOutputOptions(nodeTraits, left, right2leftProjectedDistr, right, rightDistr, res, offsetByLeftSize);
        }
        this.computeHashOutputOptions(nodeTraits, left, IgniteDistributions.hash((List<Integer>)this.joinInfo.leftKeys), right, IgniteDistributions.hash((List<Integer>)this.joinInfo.rightKeys), res, offsetByLeftSize);
        return List.copyOf(res);
    }

    private void computeHashOutputOptions(RelTraitSet nodeCurrent, RelTraitSet leftCurrent, IgniteDistribution newLeftDistribution, RelTraitSet rightCurrent, IgniteDistribution newRightDistribution, List<Pair<RelTraitSet, List<RelTraitSet>>> res, Mappings.TargetMapping offsetByLeftSize) {
        RelTraitSet outTraits;
        if (newLeftDistribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED || newRightDistribution.getType() != RelDistribution.Type.HASH_DISTRIBUTED) {
            throw new AssertionError((Object)"Only hash-based distribution is allowed");
        }
        RelTraitSet leftTraits = leftCurrent.replace((RelTrait)newLeftDistribution);
        RelTraitSet rightTraits = rightCurrent.replace((RelTrait)newRightDistribution);
        if (AbstractIgniteJoin.shouldEmitLeftSideDistribution(this.joinType)) {
            outTraits = nodeCurrent.replace((RelTrait)newLeftDistribution);
            res.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        }
        if (AbstractIgniteJoin.shouldEmitRightSideDistribution(this.joinType)) {
            outTraits = nodeCurrent.replace((RelTrait)newRightDistribution.apply(offsetByLeftSize));
            res.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        }
        if (!AbstractIgniteJoin.shouldEmitLeftSideDistribution(this.joinType) && !AbstractIgniteJoin.shouldEmitRightSideDistribution(this.joinType)) {
            outTraits = nodeCurrent.replace((RelTrait)IgniteDistributions.random());
            res.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        }
    }

    private static boolean shouldEmitLeftSideDistribution(JoinRelType joinType) {
        return !joinType.generatesNullsOnLeft();
    }

    private static boolean shouldEmitRightSideDistribution(JoinRelType joinType) {
        return joinType.projectsRight() && !joinType.generatesNullsOnRight();
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation collation = TraitUtils.collation(nodeTraits);
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        if (collation.equals(RelCollations.EMPTY)) {
            return Pair.of((Object)nodeTraits, List.of(left.replace((RelTrait)RelCollations.EMPTY), right.replace((RelTrait)RelCollations.EMPTY)));
        }
        if (!this.projectsLeft(collation)) {
            collation = RelCollations.EMPTY;
        } else if (this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL) {
            for (RelFieldCollation field : collation.getFieldCollations()) {
                if (RelFieldCollation.NullDirection.LAST.nullComparison == field.nullDirection.nullComparison) continue;
                collation = RelCollations.EMPTY;
                break;
            }
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)collation), List.of(left.replace((RelTrait)collation), right.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        RelDistribution.Type distrType = distribution.getType();
        switch (distrType) {
            case BROADCAST_DISTRIBUTED: 
            case SINGLETON: {
                return Pair.of((Object)nodeTraits, Commons.transform(inputTraits, t -> t.replace((RelTrait)distribution)));
            }
            case HASH_DISTRIBUTED: 
            case RANDOM_DISTRIBUTED: {
                IgniteDistribution outDistr;
                if (CollectionUtils.nullOrEmpty(this.joinInfo.pairs())) break;
                IgniteDistribution igniteDistribution = outDistr = distrType == RelDistribution.Type.HASH_DISTRIBUTED ? IgniteDistributions.clone(distribution, (List<Integer>)this.joinInfo.leftKeys) : IgniteDistributions.hash((List<Integer>)this.joinInfo.leftKeys);
                if (distrType == RelDistribution.Type.HASH_DISTRIBUTED && !outDistr.satisfies((RelTrait)distribution)) break;
                IgniteDistribution rightDistribution = distrType == RelDistribution.Type.HASH_DISTRIBUTED ? IgniteDistributions.clone(distribution, (List<Integer>)this.joinInfo.rightKeys) : IgniteDistributions.hash((List<Integer>)this.joinInfo.rightKeys);
                return Pair.of((Object)nodeTraits.replace((RelTrait)outDistr), List.of(left.replace((RelTrait)outDistr), right.replace((RelTrait)rightDistribution)));
            }
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), Commons.transform(inputTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first((Double)IgniteMdRowCount.joinRowCount(mq, this), (double)1.0);
    }

    protected boolean projectsLeft(RelCollation collation) {
        int leftFieldCount = this.getLeft().getRowType().getFieldCount();
        Iterator iterator = RelCollations.ordinals((RelCollation)collation).iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            if (field < leftFieldCount) continue;
            return false;
        }
        return true;
    }

    protected Mappings.TargetMapping buildTransposeMapping(boolean left2Right) {
        ImmutableIntList sourceKeys = left2Right ? this.joinInfo.leftKeys : this.joinInfo.rightKeys;
        ImmutableIntList targetKeys = left2Right ? this.joinInfo.rightKeys : this.joinInfo.leftKeys;
        return Mappings.target((Iterable)IntPair.zip((List)sourceKeys, (List)targetKeys, (boolean)true), (int)(left2Right ? this.left : this.right).getRowType().getFieldCount(), (int)(left2Right ? this.right : this.left).getRowType().getFieldCount());
    }

    protected RelDataType deriveRowType() {
        return this.deriveRowTypeAsFor(this.joinType);
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addPredicate(this.condition, this.joinType.projectsRight() ? this.getRowType() : this.deriveRowTypeAsFor(JoinRelType.INNER)).addJoinType(this.joinType);
    }

    private RelDataType deriveRowTypeAsFor(JoinRelType joinType) {
        List fieldNames = new ArrayList(this.left.getRowType().getFieldNames());
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        if (joinType.projectsRight()) {
            fieldNames.addAll(this.right.getRowType().getFieldNames());
            fieldNames = SqlValidatorUtil.uniquify(fieldNames, (original, attempt, size) -> original + "$" + attempt, (boolean)typeFactory.getTypeSystem().isSchemaCaseSensitive());
        }
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.left.getRowType(), (RelDataType)this.right.getRowType(), (JoinRelType)joinType, (RelDataTypeFactory)this.getCluster().getTypeFactory(), fieldNames, List.of());
    }
}

