/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.ddl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite3.cache.CacheWriteMode;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.AlterCacheDropExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterCacheDropExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterCacheSetExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterCacheSetExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddColumnCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddSecondaryZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAddSecondaryZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableAlterColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAlterColumnCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropColumnCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropColumnCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropSecondaryZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableDropSecondaryZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetExpireCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetExpireCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetPropertyCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableSetPropertyCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterZoneCommand;
import org.apache.ignite3.internal.catalog.commands.AlterZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.AlterZoneSetDefaultCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.ColumnParams;
import org.apache.ignite3.internal.catalog.commands.CreateCacheCommand;
import org.apache.ignite3.internal.catalog.commands.CreateCacheCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CreateHashIndexCommand;
import org.apache.ignite3.internal.catalog.commands.CreateHashIndexCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CreateSchemaCommand;
import org.apache.ignite3.internal.catalog.commands.CreateSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.CreateSortedIndexCommand;
import org.apache.ignite3.internal.catalog.commands.CreateSortedIndexCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite3.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite3.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.DefaultPartitionCountProvider;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.commands.DeferredDefaultValue;
import org.apache.ignite3.internal.catalog.commands.DropCacheCommand;
import org.apache.ignite3.internal.catalog.commands.DropCacheCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite3.internal.catalog.commands.DropIndexCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.DropSchemaCommand;
import org.apache.ignite3.internal.catalog.commands.DropSequenceCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommand;
import org.apache.ignite3.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.DropZoneCommand;
import org.apache.ignite3.internal.catalog.commands.DropZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.RenameZoneCommand;
import org.apache.ignite3.internal.catalog.commands.RenameZoneCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite3.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite3.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite3.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.DefaultValueGenerator;
import org.apache.ignite3.internal.schema.DefaultValueProvider;
import org.apache.ignite3.internal.schema.ValueOutOfBoundsException;
import org.apache.ignite3.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.apache.ignite3.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite3.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.DdlOptionInfo;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.NodeFilterValidator;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.StorageProfileValidator;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.ZoneOptionEnum;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterCacheDropExpire;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterCacheSetExpire;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterColumn;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableAddColumn;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableAddSecondaryZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableDropColumn;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableDropExpire;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableDropSecondaryZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableSetExpire;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterTableSetProperties;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterZoneRenameTo;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterZoneSet;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlAlterZoneSetDefault;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlCreateCache;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlCreateIndex;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlCreateSchema;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlCreateTable;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlCreateZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropCache;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropIndex;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropSchema;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropSchemaBehavior;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropTable;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlDropZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlIndexType;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlPrimaryKeyConstraint;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlPrimaryKeyIndexType;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlTableProperty;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlTablePropertyKey;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlZoneOption;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlZoneOptionMode;
import org.apache.ignite3.internal.sql.engine.sql.fun.GridgainSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite3.internal.sql.engine.sql.sequence.SqlAlterSequence;
import org.apache.ignite3.internal.sql.engine.sql.sequence.SqlCreateSequence;
import org.apache.ignite3.internal.sql.engine.sql.sequence.SqlDropSequence;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMath;
import org.apache.ignite3.internal.sql.engine.util.IgniteSqlDateTimeUtils;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.storage.DataStorageManager;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

public class DdlSqlToCommandConverter {
    private static final String TABLE_NAME_OBJECT_DESCRIPTION = "table name";
    private static final String INDEX_NAME_OBJECT_DESCRIPTION = "index name";
    private static final String SEQUENCE_NAME_OBJECT_DESCRIPTION = "sequence name";
    private final Map<ZoneOptionEnum, DdlOptionInfo<CreateZoneCommandBuilder, ?>> zoneOptionInfos;
    private final Map<ZoneOptionEnum, DdlOptionInfo<AlterZoneCommandBuilder, ?>> alterZoneOptionInfos;
    private final Map<IgniteSqlTablePropertyKey, DdlOptionInfo<CreateTableCommandBuilder, ?>> createTablePropertiesInfos;
    private final Map<IgniteSqlTablePropertyKey, DdlOptionInfo<AlterTableSetPropertyCommandBuilder, ?>> alterTablePropertiesInfos;
    private final DdlOptionInfo<CreateZoneCommandBuilder, Integer> createReplicasOptionInfo;
    private final DdlOptionInfo<AlterZoneCommandBuilder, Integer> alterReplicasOptionInfo;
    private final Set<String> knownZoneOptionNames = EnumSet.allOf(ZoneOptionEnum.class).stream().map(Enum::name).collect(Collectors.toSet());
    private final StorageProfileValidator storageProfileValidator;
    private final NodeFilterValidator nodeFilterValidator;
    private final Supplier<TableStatsStalenessConfiguration> stalenessProperties;
    private final ClockService clockService;
    private final DataStorageManager dataStorageManager;
    private final DefaultPartitionCountProvider defaultPartitionNumberFunction;
    private final LicenseFeatureChecker licenseFeatureChecker;

    public DdlSqlToCommandConverter(StorageProfileValidator storageProfileValidator, NodeFilterValidator nodeFilterValidator, Supplier<TableStatsStalenessConfiguration> stalenessProperties, ClockService clockService, DataStorageManager dataStorageManager, DefaultPartitionCountProvider defaultPartitionNumberFunction, LicenseFeatureChecker licenseFeatureChecker) {
        this.zoneOptionInfos = new EnumMap<ZoneOptionEnum, DdlOptionInfo<CreateZoneCommandBuilder, String>>(Map.of(ZoneOptionEnum.PARTITIONS, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::partitions), ZoneOptionEnum.QUORUM_SIZE, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::quorumSize), ZoneOptionEnum.DISTRIBUTION_ALGORITHM, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, null, (builder, params) -> {}), ZoneOptionEnum.DATA_NODES_FILTER, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, null, CreateZoneCommandBuilder::filter), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_UP, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::dataNodesAutoAdjustScaleUp), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_DOWN, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::dataNodesAutoAdjustScaleDown), ZoneOptionEnum.CONSISTENCY_MODE, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, this::checkEmptyString, (builder, params) -> builder.consistencyModeParams(DdlSqlToCommandConverter.parseConsistencyMode(params)))));
        this.createReplicasOptionInfo = new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::replicas);
        this.alterZoneOptionInfos = new EnumMap<ZoneOptionEnum, DdlOptionInfo<AlterZoneCommandBuilder, Integer>>(Map.of(ZoneOptionEnum.PARTITIONS, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::partitions), ZoneOptionEnum.QUORUM_SIZE, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::quorumSize), ZoneOptionEnum.DATA_NODES_FILTER, new DdlOptionInfo<AlterZoneCommandBuilder, String>(String.class, null, AlterZoneCommandBuilder::filter), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_UP, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::dataNodesAutoAdjustScaleUp), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_DOWN, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::dataNodesAutoAdjustScaleDown)));
        this.alterReplicasOptionInfo = new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::replicas);
        this.createTablePropertiesInfos = new EnumMap<IgniteSqlTablePropertyKey, DdlOptionInfo<CreateTableCommandBuilder, Double>>(Map.of(IgniteSqlTablePropertyKey.MIN_STALE_ROWS_COUNT, new DdlOptionInfo<CreateTableCommandBuilder, Long>(Long.class, null, CreateTableCommandBuilder::minStaleRowsCount), IgniteSqlTablePropertyKey.STALE_ROWS_FRACTION, new DdlOptionInfo<CreateTableCommandBuilder, Double>(Double.class, null, CreateTableCommandBuilder::staleRowsFraction)));
        this.alterTablePropertiesInfos = new EnumMap<IgniteSqlTablePropertyKey, DdlOptionInfo<AlterTableSetPropertyCommandBuilder, Double>>(Map.of(IgniteSqlTablePropertyKey.MIN_STALE_ROWS_COUNT, new DdlOptionInfo<AlterTableSetPropertyCommandBuilder, Long>(Long.class, null, AlterTableSetPropertyCommandBuilder::minStaleRowsCount), IgniteSqlTablePropertyKey.STALE_ROWS_FRACTION, new DdlOptionInfo<AlterTableSetPropertyCommandBuilder, Double>(Double.class, null, AlterTableSetPropertyCommandBuilder::staleRowsFraction)));
        this.storageProfileValidator = storageProfileValidator;
        this.nodeFilterValidator = nodeFilterValidator;
        this.clockService = clockService;
        this.dataStorageManager = dataStorageManager;
        this.defaultPartitionNumberFunction = defaultPartitionNumberFunction;
        this.licenseFeatureChecker = licenseFeatureChecker;
        this.stalenessProperties = stalenessProperties;
    }

    private static ConsistencyMode parseConsistencyMode(String consistencyMode) {
        try {
            return ConsistencyMode.valueOf(consistencyMode);
        }
        catch (IllegalArgumentException ignored) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to parse consistency mode: " + consistencyMode + ". Valid values are: " + Arrays.toString((Object[])ConsistencyMode.values()));
        }
    }

    public CompletableFuture<CatalogCommand> convert(SqlDdl ddlNode, PlanningContext ctx) {
        if (ddlNode instanceof IgniteSqlCreateTable) {
            return this.convertCreateTable((IgniteSqlCreateTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropTable) {
            return this.convertDropTable((IgniteSqlDropTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddColumn) {
            return this.convertAlterTableAddColumn((IgniteSqlAlterTableAddColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropColumn) {
            return this.convertAlterTableDropColumn((IgniteSqlAlterTableDropColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddSecondaryZone) {
            return this.convertAlterTableAddSecondaryZone((IgniteSqlAlterTableAddSecondaryZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropSecondaryZone) {
            return this.convertAlterTableDropSecondaryZone((IgniteSqlAlterTableDropSecondaryZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableSetExpire) {
            return this.convertAlterTableSetExpire((IgniteSqlAlterTableSetExpire)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropExpire) {
            return this.convertAlterTableDropExpire((IgniteSqlAlterTableDropExpire)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterColumn) {
            return this.convertAlterColumn((IgniteSqlAlterColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableSetProperties) {
            return this.convertAlterTableSet((IgniteSqlAlterTableSetProperties)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateIndex) {
            return this.convertAddIndex((IgniteSqlCreateIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropIndex) {
            return this.convertDropIndex((IgniteSqlDropIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateZone) {
            return this.convertCreateZone((IgniteSqlCreateZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneRenameTo) {
            return this.convertAlterZoneRename((IgniteSqlAlterZoneRenameTo)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneSet) {
            return this.convertAlterZoneSet((IgniteSqlAlterZoneSet)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneSetDefault) {
            return this.convertAlterZoneSetDefault((IgniteSqlAlterZoneSetDefault)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropZone) {
            return this.convertDropZone((IgniteSqlDropZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateSchema) {
            return this.convertCreateSchema((IgniteSqlCreateSchema)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropSchema) {
            return this.convertDropSchema((IgniteSqlDropSchema)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlCreateSequence) {
            return this.convertCreateSequence((SqlCreateSequence)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlAlterSequence) {
            return this.convertAlterSequence((SqlAlterSequence)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlDropSequence) {
            return this.convertDropSequence((SqlDropSequence)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateCache) {
            return this.convertCreateCache((IgniteSqlCreateCache)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropCache) {
            return this.convertDropCache((IgniteSqlDropCache)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterCacheSetExpire) {
            return this.convertAlterCache((IgniteSqlAlterCacheSetExpire)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterCacheDropExpire) {
            return this.convertAlterCache((IgniteSqlAlterCacheDropExpire)ddlNode, ctx);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported operation [sqlNodeKind=" + ddlNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
    }

    private CompletableFuture<CatalogCommand> convertAlterTableSet(IgniteSqlAlterTableSetProperties alterTableSet, PlanningContext ctx) {
        AlterTableSetPropertyCommandBuilder builder = AlterTableSetPropertyCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterTableSet.name(), ctx));
        builder.tableName(this.deriveObjectName(alterTableSet.name(), ctx, "tableName"));
        builder.ifTableExists(alterTableSet.ifExists());
        DdlSqlToCommandConverter.handleTablePropertyList(alterTableSet.propertyList(), this.alterTablePropertiesInfos, ctx, builder);
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletableFuture<CatalogCommand> convertCreateSchema(IgniteSqlCreateSchema ddlNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(CreateSchemaCommand.builder().name(this.deriveObjectName(ddlNode.name(), ctx, "schemaName")).ifNotExists(ddlNode.ifNotExists()).build());
    }

    private CompletableFuture<CatalogCommand> convertDropSchema(IgniteSqlDropSchema ddlNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(DropSchemaCommand.builder().name(this.deriveObjectName(ddlNode.name(), ctx, "schemaName")).ifExists(ddlNode.ifExists()).cascade(ddlNode.behavior() == IgniteSqlDropSchemaBehavior.CASCADE).build());
    }

    private CompletableFuture<CatalogCommand> convertCreateTable(IgniteSqlCreateTable createTblNode, PlanningContext ctx) {
        CreateTableCommandBuilder tblBuilder = CreateTableCommand.builder();
        DdlSqlToCommandConverter.validateTableColumns(createTblNode.columnList());
        TablePrimaryKey primaryKey = this.processPrimaryKey(ctx, createTblNode.columnList(), Commons.implicitPkEnabled());
        if (primaryKey == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Table without PRIMARY KEY is not supported");
        }
        if (createTblNode.colocationColumns() != null) {
            List<String> colocationColumns = createTblNode.colocationColumns().getList().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).collect(Collectors.toList());
            tblBuilder.colocationColumns(colocationColumns);
        }
        List<ColumnParams> columns = this.processColumns(ctx, createTblNode.columnList(), primaryKey.columns()::contains);
        if (createTblNode.storageProfile() != null) {
            assert (createTblNode.storageProfile().getKind() == SqlKind.LITERAL);
            String storageProfile = (String)((SqlLiteral)createTblNode.storageProfile()).getValueAs(String.class);
            this.checkEmptyString(storageProfile);
            tblBuilder.storageProfile(storageProfile);
        }
        if (createTblNode.secondaryStorageProfile() != null) {
            this.licenseFeatureChecker.checkFeature(LicenseFeature.SECONDARY_STORAGE);
            assert (createTblNode.secondaryStorageProfile().getKind() == SqlKind.LITERAL);
            String secondaryStorageProfile = (String)((SqlLiteral)createTblNode.secondaryStorageProfile()).getValueAs(String.class);
            this.checkEmptyString(secondaryStorageProfile);
            tblBuilder.secondaryStorageProfile(secondaryStorageProfile);
        }
        if (createTblNode.zone() != null) {
            tblBuilder.zone(createTblNode.zone().getSimple());
        }
        if (createTblNode.secondaryZone() != null) {
            tblBuilder.secondaryZone(createTblNode.secondaryZone().getSimple());
        }
        if (createTblNode.expireColumn() != null) {
            tblBuilder.expireColumn(createTblNode.expireColumn().getSimple());
        }
        if (createTblNode.archiveColumn() != null) {
            tblBuilder.archiveColumn(createTblNode.archiveColumn().getSimple());
        }
        TableStatsStalenessConfiguration properties = this.stalenessProperties.get();
        tblBuilder.staleRowsFraction(properties.staleRowsFraction()).minStaleRowsCount(properties.minStaleRowsCount());
        SqlNodeList propertyList = createTblNode.tableProperties();
        if (propertyList != null) {
            DdlSqlToCommandConverter.handleTablePropertyList(propertyList, this.createTablePropertiesInfos, ctx, tblBuilder);
        }
        CatalogCommand command = ((CreateTableCommandBuilder)((CreateTableCommandBuilder)((CreateTableCommandBuilder)tblBuilder.schemaName(this.deriveSchemaName(createTblNode.name(), ctx))).tableName(this.deriveObjectName(createTblNode.name(), ctx, "tableName"))).columns(columns).primaryKey(primaryKey).ifTableExists(createTblNode.ifNotExists())).secondaryEngineResolver(secondaryProfile -> this.dataStorageManager.secondaryEngineByStorageProfile((String)secondaryProfile) != null).build();
        return CompletableFuture.completedFuture(command);
    }

    private List<ColumnParams> processColumns(PlanningContext ctx, SqlNodeList createCacheNode, Predicate<String> isPkColumn) {
        List colDeclarations = createCacheNode.getList().stream().filter(SqlColumnDeclaration.class::isInstance).map(SqlColumnDeclaration.class::cast).collect(Collectors.toList());
        ArrayList<ColumnParams> columns = new ArrayList<ColumnParams>(colDeclarations.size());
        for (SqlColumnDeclaration col : colDeclarations) {
            if (!col.name.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of columnName [expected a simple identifier, but was " + col.name + "; querySql=\"" + ctx.query() + "\"]");
            }
            columns.add(this.convertColumnDeclaration(col, ctx, ctx.planner(), !isPkColumn.test(col.name.getSimple())));
        }
        return columns;
    }

    @Nullable
    private TablePrimaryKey processPrimaryKey(PlanningContext ctx, SqlNodeList columnsListNode, boolean addImpliticPk) {
        List pkConstraints = columnsListNode.getList().stream().filter(IgniteSqlPrimaryKeyConstraint.class::isInstance).map(IgniteSqlPrimaryKeyConstraint.class::cast).collect(Collectors.toList());
        if (pkConstraints.isEmpty() && addImpliticPk) {
            SqlIdentifier colName = new SqlIdentifier("__p_key", SqlParserPos.ZERO);
            pkConstraints.add(new IgniteSqlPrimaryKeyConstraint(SqlParserPos.ZERO, null, SqlNodeList.of((SqlNode)colName), IgniteSqlPrimaryKeyIndexType.IMPLICIT_HASH));
            SqlDataTypeSpec type = new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.UUID, SqlParserPos.ZERO), SqlParserPos.ZERO);
            SqlNode col = SqlDdlNodes.column((SqlParserPos)SqlParserPos.ZERO, (SqlIdentifier)colName, (SqlDataTypeSpec)type, null, (ColumnStrategy)ColumnStrategy.DEFAULT);
            columnsListNode.add(0, col);
        }
        if (pkConstraints.isEmpty()) {
            return null;
        }
        if (pkConstraints.size() > 1) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected number of primary key constraints [expected at most one, but was " + pkConstraints.size() + "; querySql=\"" + ctx.query() + "\"]");
        }
        IgniteSqlPrimaryKeyConstraint pkConstraint = (IgniteSqlPrimaryKeyConstraint)((Object)pkConstraints.get(0));
        String pkName = null;
        SqlIdentifier pkIdentifier = pkConstraint.getName();
        if (pkIdentifier != null) {
            pkName = this.deriveObjectName(pkIdentifier, ctx, "name of pk constraint");
        }
        SqlNodeList columnNodes = pkConstraint.getColumnList();
        ArrayList<String> pkColumns = new ArrayList<String>(columnNodes.size());
        ArrayList<CatalogColumnCollation> pkCollations = new ArrayList<CatalogColumnCollation>(columnNodes.size());
        IgniteSqlPrimaryKeyIndexType pkIndexType = pkConstraint.getIndexType();
        boolean supportCollation = pkIndexType == IgniteSqlPrimaryKeyIndexType.SORTED;
        DdlSqlToCommandConverter.parseColumnList(pkConstraint.getColumnList(), pkColumns, pkCollations, supportCollation);
        switch (pkIndexType) {
            case SORTED: {
                return ((TableSortedPrimaryKey.Builder)TableSortedPrimaryKey.builder().name(pkName).columns(pkColumns)).collations(pkCollations).build();
            }
            case HASH: 
            case IMPLICIT_HASH: {
                return ((TableHashPrimaryKey.Builder)TableHashPrimaryKey.builder().name(pkName).columns(pkColumns)).build();
            }
        }
        throw new IllegalArgumentException("Unexpected primary key index type: " + pkIndexType);
    }

    private static void validateTableColumns(SqlNodeList createCacheNode) {
        for (SqlNode sqlNode : createCacheNode.getList()) {
            String colName;
            if (!(sqlNode instanceof SqlColumnDeclaration) || !IgniteSqlValidator.isSystemColumnName(colName = ((SqlColumnDeclaration)sqlNode).name.getSimple())) continue;
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. Column '" + colName + "' is reserved name.");
        }
    }

    private boolean cacheEngineResolver(String profile) {
        StorageEngine storageEngine = this.dataStorageManager.engineByStorageProfile(profile);
        return storageEngine != null && storageEngine.isVolatile();
    }

    private ColumnParams convertColumnDeclaration(SqlColumnDeclaration col, PlanningContext ctx, IgnitePlanner planner, boolean nullable) {
        RelDataType relType;
        assert (col.name.isSimple());
        String name = col.name.getSimple();
        try {
            relType = planner.convert(col.dataType, nullable);
        }
        catch (CalciteContextException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null) {
                errorMessage = "Unable to resolve data type";
            }
            String message = IgniteStringFormatter.format("{} [column={}]", errorMessage, name);
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, message, (Throwable)e);
        }
        if (SqlTypeUtil.isInterval((RelDataType)relType)) {
            String error = IgniteStringFormatter.format("Type {} cannot be used in a column definition [column={}].", relType.getSqlTypeName().getSpaceName(), name);
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, error);
        }
        ColumnTypeParams typeParams = new ColumnTypeParams(relType);
        return ColumnParams.builder().name(name).type(typeParams.colType).nullable(relType.isNullable()).precision(typeParams.precision).scale(typeParams.scale).length(typeParams.length).deferredDefaultValue(this.convertDefault(col.expression, relType, name, ctx, planner)).build();
    }

    private DeferredDefaultValue convertDefault(@Nullable SqlNode expression, RelDataType relType, String name, PlanningContext ctx, IgnitePlanner planner) {
        if (expression == null) {
            return DeferredDefaultValue.constantValue(null);
        }
        DeferredDefaultValue deferredDefaultValue = this.convertDefaultExpression(expression, name, relType, ctx, planner);
        ColumnType columnType = TypeUtils.columnType(relType);
        if (deferredDefaultValue.type() == DefaultValue.Type.CONSTANT) {
            deferredDefaultValue.derive(null, columnType);
        }
        return deferredDefaultValue;
    }

    private CompletableFuture<CatalogCommand> convertAlterTableAddColumn(IgniteSqlAlterTableAddColumn alterTblNode, PlanningContext ctx) {
        AlterTableAddColumnCommandBuilder builder = AlterTableAddColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION));
        builder.ifTableExists(alterTblNode.ifExists());
        ArrayList<ColumnParams> columns = new ArrayList<ColumnParams>(alterTblNode.columns().size());
        for (SqlNode colNode : alterTblNode.columns()) {
            assert (colNode instanceof SqlColumnDeclaration) : colNode.getClass();
            SqlColumnDeclaration col = (SqlColumnDeclaration)colNode;
            Boolean nullable = col.dataType.getNullable();
            String colName = col.name.getSimple();
            if (IgniteSqlValidator.isSystemColumnName(colName)) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. Column '" + colName + "' is reserved name.");
            }
            columns.add(this.convertColumnDeclaration(col, ctx, ctx.planner(), nullable != null ? nullable : true));
        }
        builder.columns(columns);
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletableFuture<CatalogCommand> convertAlterTableSetExpire(IgniteSqlAlterTableSetExpire alterTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((AlterTableSetExpireCommandBuilder)((AlterTableSetExpireCommandBuilder)((AlterTableSetExpireCommandBuilder)AlterTableSetExpireCommand.builder().schemaName(this.deriveSchemaName(alterTblNode.name(), ctx))).tableName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifTableExists(alterTblNode.ifExists())).expireColumn(alterTblNode.getExpireColumn().getSimple()).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterTableDropExpire(IgniteSqlAlterTableDropExpire alterTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((AlterTableDropExpireCommandBuilder)((AlterTableDropExpireCommandBuilder)((AlterTableDropExpireCommandBuilder)AlterTableDropExpireCommand.builder().schemaName(this.deriveSchemaName(alterTblNode.name(), ctx))).tableName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifTableExists(alterTblNode.ifExists())).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterColumn(IgniteSqlAlterColumn alterColumnNode, PlanningContext ctx) {
        Boolean notNull;
        AlterTableAlterColumnCommandBuilder builder = AlterTableAlterColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterColumnNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterColumnNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION));
        builder.ifTableExists(alterColumnNode.ifExists());
        builder.columnName(alterColumnNode.columnName().getSimple());
        RelDataType relType = null;
        SqlDataTypeSpec colTypeSpec = alterColumnNode.dataType();
        if (colTypeSpec != null) {
            relType = ctx.planner().convert(colTypeSpec, true);
            ColumnTypeParams typeParams = new ColumnTypeParams(relType);
            builder.type(typeParams.colType);
            if (typeParams.length != null) {
                builder.length(typeParams.length);
            } else {
                if (typeParams.precision != null) {
                    builder.precision(typeParams.precision);
                }
                if (typeParams.scale != null) {
                    builder.scale(typeParams.scale);
                }
            }
        }
        if ((notNull = alterColumnNode.notNull()) != null) {
            builder.nullable(notNull == false);
        }
        if (alterColumnNode.expression() != null) {
            SqlNode expr = alterColumnNode.expression();
            String name = alterColumnNode.columnName().getSimple();
            DeferredDefaultValue resolveDfltFunc = this.convertDefaultExpression(expr, name, relType, ctx, ctx.planner());
            builder.deferredDefaultValue(resolveDfltFunc);
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private DeferredDefaultValue convertDefaultExpression(SqlNode expr, String name, @Nullable RelDataType relType, PlanningContext ctx, IgnitePlanner planner) {
        SqlCall call;
        DeferredDefaultValue value;
        if (expr instanceof SqlLiteral) {
            int precision = relType == null ? -1 : relType.getPrecision();
            int scale = relType == null ? Integer.MIN_VALUE : relType.getScale();
            return DeferredDefaultValue.constant(type -> DefaultValue.constant(DdlSqlToCommandConverter.fromLiteral(type, name, (SqlLiteral)expr, precision, scale)));
        }
        if (expr instanceof SqlIdentifier && ((SqlIdentifier)expr).isSimple()) {
            String functionName = ((SqlIdentifier)expr).getSimple();
            DeferredDefaultValue value2 = this.tryConvertCall(functionName, List.of(), expr, ctx);
            if (value2 != null) {
                return value2;
            }
        } else if (expr instanceof SqlCall && (value = this.tryConvertCall((call = (SqlCall)expr).getOperator().getName(), call.getOperandList(), (SqlNode)call, ctx)) != null) {
            return value;
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported default expression: " + expr);
    }

    @Nullable
    private DeferredDefaultValue tryConvertCall(String functionName, List<SqlNode> operands, SqlNode callNode, PlanningContext ctx) {
        if (operands.isEmpty() && IgniteSqlOperatorTable.RAND_UUID.getName().equalsIgnoreCase(functionName)) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.clockService.now().getPhysical());
            DefaultValueProvider defaultValueProvider = DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(functionName), params);
            Object computedDefaultValue = defaultValueProvider.get();
            return DeferredDefaultValue.functionCall(functionName, params, computedDefaultValue, null);
        }
        if (GridgainSqlOperatorTable.NEXTVAL.getName().equalsIgnoreCase(functionName)) {
            String schemaName;
            if (operands.size() != 1 || !(operands.get(0) instanceof SqlCharStringLiteral)) {
                String msg = IgniteStringFormatter.format("Functional default illegal arguments. Expected `{}`(<character>), got {}", functionName, callNode);
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg);
            }
            String fullSequenceName = (String)((SqlCharStringLiteral)operands.get(0)).getValueAs(String.class);
            SqlIdentifier id = new SqlIdentifier(IgniteNameUtils.parseName(fullSequenceName), callNode.getParserPosition());
            String objectNamePart = this.deriveObjectName(id, ctx, SEQUENCE_NAME_OBJECT_DESCRIPTION);
            if (id.isSimple()) {
                schemaName = ctx.schemaName();
                assert (schemaName != null) : "Default schema should have been set";
            } else {
                schemaName = (String)id.names.get(1);
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.clockService.now().getPhysical());
            params.add(fullSequenceName);
            params.add(null);
            return DeferredDefaultValue.functionCall(functionName, params, null, (catalog, type, args) -> {
                CatalogSequenceDescriptor sequence = catalog.sequence(schemaName, objectNamePart);
                if (sequence == null) {
                    throw new CatalogValidationException(IgniteStringFormatter.format("Sequence is not found {}.{}", schemaName, objectNamePart));
                }
                ArrayList<Integer> resolvedParams = new ArrayList<Integer>(3);
                resolvedParams.addAll(params);
                resolvedParams.set(2, sequence.id());
                return resolvedParams;
            });
        }
        if (operands.size() == 2) {
            SqlNode op1 = operands.get(0);
            SqlNode op2 = operands.get(1);
            if (!(SqlStdOperatorTable.PLUS.getName().equalsIgnoreCase(functionName) && op1 instanceof SqlIdentifier && SqlStdOperatorTable.CURRENT_TIMESTAMP.getName().equalsIgnoreCase(((SqlIdentifier)op1).getSimple()) && op2 instanceof SqlIntervalLiteral)) {
                return null;
            }
            SqlIntervalLiteral interval = (SqlIntervalLiteral)op2;
            long intervalArgument = DdlSqlToCommandConverter.defaultIntervalToLong(interval);
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.clockService.now().getPhysical());
            params.add(intervalArgument);
            DefaultValueGenerator defaultValueGenerator = DefaultValueGenerator.CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL;
            DefaultValueProvider defaultValueProvider = DefaultValueProvider.forValueGenerator(defaultValueGenerator, params);
            Instant computedDefaultValue = (Instant)DdlSqlToCommandConverter.computeInitialDefaultForTimestampPlusInterval(defaultValueProvider);
            return DeferredDefaultValue.functionCall(defaultValueGenerator.toString(), params, computedDefaultValue, null);
        }
        return null;
    }

    private static Object computeInitialDefaultForTimestampPlusInterval(DefaultValueProvider defaultValueProvider) {
        try {
            return defaultValueProvider.get();
        }
        catch (ValueOutOfBoundsException e) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, e.getMessage());
        }
    }

    private static long defaultIntervalToLong(SqlIntervalLiteral interval) {
        SqlIntervalLiteral.IntervalValue intervalValue = (SqlIntervalLiteral.IntervalValue)interval.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        if (intervalValue.getIntervalQualifier().isYearMonth()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported default expression: interval must be day time.");
        }
        return SqlParserUtil.intervalToMillis((SqlIntervalLiteral.IntervalValue)intervalValue);
    }

    private CompletableFuture<CatalogCommand> convertAlterTableDropColumn(IgniteSqlAlterTableDropColumn alterTblNode, PlanningContext ctx) {
        AlterTableDropColumnCommandBuilder builder = AlterTableDropColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION));
        builder.ifTableExists(alterTblNode.ifExists());
        HashSet<String> cols = new HashSet<String>(alterTblNode.columns().size());
        alterTblNode.columns().forEach(c -> cols.add(((SqlIdentifier)c).getSimple()));
        builder.columns(cols);
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletableFuture<CatalogCommand> convertAlterTableAddSecondaryZone(IgniteSqlAlterTableAddSecondaryZone alterTblNode, PlanningContext ctx) {
        String secondaryStorageProfile;
        this.licenseFeatureChecker.checkFeature(LicenseFeature.SECONDARY_STORAGE);
        String schemaName = this.deriveSchemaName(alterTblNode.name(), ctx);
        String tableName = this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION);
        SqlNode secondaryStorageProfileNode = alterTblNode.secondaryProfileName();
        if (secondaryStorageProfileNode != null) {
            assert (secondaryStorageProfileNode.getKind() == SqlKind.LITERAL);
            SqlLiteral secondaryStorageProfileLiteral = (SqlLiteral)secondaryStorageProfileNode;
            secondaryStorageProfile = (String)secondaryStorageProfileLiteral.getValueAs(String.class);
        } else {
            secondaryStorageProfile = null;
        }
        CatalogCommand command = ((AlterTableAddSecondaryZoneCommandBuilder)((AlterTableAddSecondaryZoneCommandBuilder)((AlterTableAddSecondaryZoneCommandBuilder)AlterTableAddSecondaryZoneCommand.builder().schemaName(schemaName)).tableName(tableName)).ifTableExists(alterTblNode.ifExists())).secondaryZoneName(alterTblNode.secondaryZoneName().getSimple()).secondaryStorageProfile(secondaryStorageProfile).build();
        return CompletableFuture.completedFuture(command);
    }

    private CompletableFuture<CatalogCommand> convertAlterTableDropSecondaryZone(IgniteSqlAlterTableDropSecondaryZone alterTblNode, PlanningContext ctx) {
        String schemaName = this.deriveSchemaName(alterTblNode.name(), ctx);
        String tableName = this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION);
        CatalogCommand command = ((AlterTableDropSecondaryZoneCommandBuilder)((AlterTableDropSecondaryZoneCommandBuilder)((AlterTableDropSecondaryZoneCommandBuilder)AlterTableDropSecondaryZoneCommand.builder().schemaName(schemaName)).tableName(tableName)).ifTableExists(alterTblNode.ifExists())).build();
        return CompletableFuture.completedFuture(command);
    }

    private CompletableFuture<CatalogCommand> convertDropTable(IgniteSqlDropTable dropTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((DropTableCommandBuilder)((DropTableCommandBuilder)((DropTableCommandBuilder)DropTableCommand.builder().schemaName(this.deriveSchemaName(dropTblNode.name(), ctx))).tableName(this.deriveObjectName(dropTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifTableExists(dropTblNode.ifExists)).build());
    }

    private CompletableFuture<CatalogCommand> convertAddIndex(IgniteSqlCreateIndex sqlCmd, PlanningContext ctx) {
        boolean sortedIndex = sqlCmd.type() == IgniteSqlIndexType.SORTED || sqlCmd.type() == IgniteSqlIndexType.IMPLICIT_SORTED;
        SqlNodeList columnList = sqlCmd.columnList();
        ArrayList<String> columns = new ArrayList<String>(columnList.size());
        ArrayList<CatalogColumnCollation> collations = new ArrayList<CatalogColumnCollation>(columnList.size());
        DdlSqlToCommandConverter.parseColumnList(columnList, columns, collations, sortedIndex);
        CatalogCommand command = sortedIndex ? ((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)CreateSortedIndexCommand.builder().schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx))).tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifNotExists(sqlCmd.ifNotExists())).indexName(sqlCmd.indexName().getSimple())).columns(columns)).collations(collations).build() : ((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)CreateHashIndexCommand.builder().schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx))).tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifNotExists(sqlCmd.ifNotExists())).indexName(sqlCmd.indexName().getSimple())).columns(columns)).build();
        return CompletableFuture.completedFuture(command);
    }

    private static void parseColumnList(SqlNodeList columnList, List<String> columns, List<CatalogColumnCollation> collations, boolean supportCollation) {
        for (SqlNode col : columnList.getList()) {
            boolean asc = true;
            Boolean nullsFirst = null;
            if (col.getKind() == SqlKind.NULLS_FIRST) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                nullsFirst = true;
            } else if (col.getKind() == SqlKind.NULLS_LAST) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                nullsFirst = false;
            }
            if (col.getKind() == SqlKind.DESCENDING) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                asc = false;
            }
            if (nullsFirst == null) {
                nullsFirst = !asc;
            }
            String columnName = ((SqlIdentifier)col).getSimple();
            columns.add(columnName);
            if (!supportCollation) continue;
            collations.add(CatalogColumnCollation.get(asc, nullsFirst));
        }
    }

    private CompletableFuture<CatalogCommand> convertDropIndex(IgniteSqlDropIndex sqlCmd, PlanningContext ctx) {
        String schemaName = this.deriveSchemaName(sqlCmd.indexName(), ctx);
        String indexName = this.deriveObjectName(sqlCmd.indexName(), ctx, INDEX_NAME_OBJECT_DESCRIPTION);
        CatalogCommand command = ((DropIndexCommandBuilder)((DropIndexCommandBuilder)DropIndexCommand.builder().schemaName(schemaName)).indexName(indexName)).ifExists(sqlCmd.ifExists()).build();
        return CompletableFuture.completedFuture(command);
    }

    private CompletableFuture<CatalogCommand> convertCreateZone(IgniteSqlCreateZone createZoneNode, PlanningContext ctx) {
        if (createZoneNode.storageProfiles().isEmpty()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "STORAGE PROFILES can not be empty");
        }
        CreateZoneCommandBuilder builder = CreateZoneCommand.builder(this.defaultPartitionNumberFunction);
        builder.zoneName(this.deriveObjectName(createZoneNode.name(), ctx, "zoneName"));
        builder.ifNotExists(createZoneNode.ifNotExists());
        HashSet<String> remainingKnownOptions = new HashSet<String>(this.knownZoneOptionNames);
        for (SqlNode optionNode : createZoneNode.createOptionList()) {
            IgniteSqlZoneOption option = (IgniteSqlZoneOption)optionNode;
            this.updateZoneOption(option, remainingKnownOptions, this.zoneOptionInfos, this.createReplicasOptionInfo, ctx, builder);
        }
        List<StorageProfileParams> profiles = DdlSqlToCommandConverter.extractProfiles(createZoneNode.storageProfiles());
        HashSet<String> storageProfileNames = new HashSet<String>(profiles.size());
        for (StorageProfileParams profile : profiles) {
            storageProfileNames.add(profile.storageProfile());
        }
        List<IgniteSqlZoneOption> options = createZoneNode.createOptionList().stream().map(IgniteSqlZoneOption.class::cast).collect(Collectors.toList());
        String nodesFilter = this.extractLiteralOptionValueFromZoneOptionList(options, ZoneOptionEnum.DATA_NODES_FILTER.name());
        return ((CompletableFuture)this.storageProfileValidator.validate(storageProfileNames).thenCompose(unused -> this.nodeFilterValidator.validate(nodesFilter))).thenApply(unused -> {
            builder.storageProfilesParams(profiles);
            return builder.build();
        });
    }

    @Nullable
    private String extractLiteralOptionValueFromZoneOptionList(List<IgniteSqlZoneOption> options, String optionName) {
        return options.stream().filter(opt -> opt.key().isSimple() && opt.key().getSimple().equalsIgnoreCase(optionName)).map(opt -> {
            DdlOptionInfo<CreateZoneCommandBuilder, ?> optInfo = this.zoneOptionInfos.get((Object)ZoneOptionEnum.valueOf(optionName));
            return (String)((SqlLiteral)opt.value()).getValueAs(optInfo.type);
        }).findFirst().orElse(null);
    }

    private CompletableFuture<CatalogCommand> convertAlterZoneSet(IgniteSqlAlterZoneSet alterZoneSet, PlanningContext ctx) {
        AlterZoneCommandBuilder builder = AlterZoneCommand.builder();
        builder.zoneName(this.deriveObjectName(alterZoneSet.name(), ctx, "zoneName"));
        builder.ifExists(alterZoneSet.ifExists());
        HashSet<String> remainingKnownOptions = new HashSet<String>(this.knownZoneOptionNames);
        for (SqlNode optionNode : alterZoneSet.alterOptionsList().getList()) {
            IgniteSqlZoneOption option = (IgniteSqlZoneOption)optionNode;
            this.updateZoneOption(option, remainingKnownOptions, this.alterZoneOptionInfos, this.alterReplicasOptionInfo, ctx, builder);
        }
        List<IgniteSqlZoneOption> options = alterZoneSet.alterOptionsList().stream().map(IgniteSqlZoneOption.class::cast).collect(Collectors.toList());
        String nodeFilter = this.extractLiteralOptionValueFromZoneOptionList(options, ZoneOptionEnum.DATA_NODES_FILTER.name());
        return this.nodeFilterValidator.validate(nodeFilter).thenApply(unused -> builder.build());
    }

    private CompletableFuture<CatalogCommand> convertAlterZoneSetDefault(IgniteSqlAlterZoneSetDefault alterZoneSetDefault, PlanningContext ctx) {
        return CompletableFuture.completedFuture(AlterZoneSetDefaultCommand.builder().zoneName(this.deriveObjectName(alterZoneSetDefault.name(), ctx, "zoneName")).ifExists(alterZoneSetDefault.ifExists()).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterZoneRename(IgniteSqlAlterZoneRenameTo alterZoneRename, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((RenameZoneCommandBuilder)RenameZoneCommand.builder().zoneName(this.deriveObjectName(alterZoneRename.name(), ctx, "zoneName"))).newZoneName(alterZoneRename.newName().getSimple()).ifExists(alterZoneRename.ifExists()).build());
    }

    private CompletableFuture<CatalogCommand> convertDropZone(IgniteSqlDropZone dropZoneNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((DropZoneCommandBuilder)DropZoneCommand.builder().zoneName(this.deriveObjectName(dropZoneNode.name(), ctx, "zoneName"))).ifExists(dropZoneNode.ifExists()).build());
    }

    private CompletableFuture<CatalogCommand> convertCreateCache(IgniteSqlCreateCache createCacheNode, PlanningContext ctx) {
        CreateCacheCommandBuilder tblBuilder = CreateCacheCommand.builder();
        DdlSqlToCommandConverter.validateTableColumns(createCacheNode.columnList());
        TablePrimaryKey primaryKey = this.processPrimaryKey(ctx, createCacheNode.columnList(), Commons.implicitPkEnabled());
        if (primaryKey == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Cache without PRIMARY KEY is not supported");
        }
        if (createCacheNode.colocationColumns() != null) {
            List<String> colocationColumns = createCacheNode.colocationColumns().getList().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).collect(Collectors.toList());
            tblBuilder.colocationColumns(colocationColumns);
        }
        List<ColumnParams> columns = this.processColumns(ctx, createCacheNode.columnList(), primaryKey.columns()::contains);
        if (createCacheNode.storageProfile() != null) {
            assert (createCacheNode.storageProfile().getKind() == SqlKind.LITERAL);
            String storageProfile = (String)((SqlLiteral)createCacheNode.storageProfile()).getValueAs(String.class);
            this.checkEmptyString(storageProfile);
            tblBuilder.storageProfile(storageProfile);
        }
        if (createCacheNode.writeMode() != null) {
            String writeMode = createCacheNode.writeMode().getSimple();
            CacheWriteMode cacheWriteMode = CacheWriteMode.fromString(writeMode);
            tblBuilder.cacheWriteMode(cacheWriteMode);
        }
        if (createCacheNode.zone() != null) {
            tblBuilder.zone(createCacheNode.zone().getSimple());
        }
        if (createCacheNode.expireColumn() != null) {
            tblBuilder.expireColumn(createCacheNode.expireColumn().getSimple());
        }
        CatalogCommand command = ((CreateCacheCommandBuilder)((CreateCacheCommandBuilder)((CreateCacheCommandBuilder)tblBuilder.schemaName(this.deriveSchemaName(createCacheNode.name(), ctx))).cacheName(this.deriveObjectName(createCacheNode.name(), ctx, "cacheName"))).columns(columns).primaryKey(primaryKey).ifCacheExists(createCacheNode.ifNotExists())).engineResolver(this::cacheEngineResolver).build();
        return CompletableFuture.completedFuture(command);
    }

    private CompletableFuture<CatalogCommand> convertDropCache(IgniteSqlDropCache dropTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((DropCacheCommandBuilder)((DropCacheCommandBuilder)((DropCacheCommandBuilder)DropCacheCommand.builder().schemaName(this.deriveSchemaName(dropTblNode.name(), ctx))).cacheName(this.deriveObjectName(dropTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifCacheExists(dropTblNode.ifExists)).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterCache(IgniteSqlAlterCacheSetExpire alterTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((AlterCacheSetExpireCommandBuilder)((AlterCacheSetExpireCommandBuilder)((AlterCacheSetExpireCommandBuilder)AlterCacheSetExpireCommand.builder().schemaName(this.deriveSchemaName(alterTblNode.name(), ctx))).cacheName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifCacheExists(alterTblNode.ifExists())).expireColumn(alterTblNode.getExpireColumn().getSimple()).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterCache(IgniteSqlAlterCacheDropExpire alterTblNode, PlanningContext ctx) {
        return CompletableFuture.completedFuture(((AlterCacheDropExpireCommandBuilder)((AlterCacheDropExpireCommandBuilder)((AlterCacheDropExpireCommandBuilder)AlterCacheDropExpireCommand.builder().schemaName(this.deriveSchemaName(alterTblNode.name(), ctx))).cacheName(this.deriveObjectName(alterTblNode.name(), ctx, TABLE_NAME_OBJECT_DESCRIPTION))).ifCacheExists(alterTblNode.ifExists())).build());
    }

    private CompletableFuture<CatalogCommand> convertCreateSequence(SqlCreateSequence node, PlanningContext ctx) {
        return CompletableFuture.completedFuture(CreateSequenceCommand.builder().schemaName(this.deriveSchemaName(node.name(), ctx)).sequenceName(this.deriveObjectName(node.name(), ctx, "sequenceName")).ifNotExists(node.ifNotExists()).increment(node.increment()).minvalue(node.minvalue()).maxvalue(node.maxvalue()).start(node.start()).cache(node.cache()).build());
    }

    private CompletableFuture<CatalogCommand> convertAlterSequence(SqlAlterSequence node, PlanningContext ctx) {
        return CompletableFuture.completedFuture(AlterSequenceCommand.builder().schemaName(this.deriveSchemaName(node.name(), ctx)).sequenceName(this.deriveObjectName(node.name(), ctx, "sequenceName")).ifExists(node.ifExists()).increment(node.increment()).minvalue(node.minvalue()).maxvalue(node.maxvalue()).start(node.start()).cache(node.cache()).build());
    }

    private CompletableFuture<CatalogCommand> convertDropSequence(SqlDropSequence node, PlanningContext ctx) {
        return CompletableFuture.completedFuture(DropSequenceCommand.builder().schemaName(this.deriveSchemaName(node.name(), ctx)).sequenceName(this.deriveObjectName(node.name(), ctx, "sequenceName")).ifExists(node.ifExists()).build());
    }

    private String deriveSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of schemaName [expected a simple identifier, but was " + schemaId + "; querySql=\"" + ctx.query() + "\"]");
            }
            schemaName = schemaId.getSimple();
        }
        return schemaName;
    }

    private String deriveObjectName(SqlIdentifier id, PlanningContext ctx, String objDesc) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of " + objDesc + " [expected a simple identifier, but was " + objId + "; querySql=\"" + ctx.query() + "\"]");
        }
        return objId.getSimple();
    }

    private <S> void updateZoneOption(IgniteSqlZoneOption option, Set<String> remainingKnownOptions, Map<ZoneOptionEnum, DdlOptionInfo<S, ?>> optionInfos, DdlOptionInfo<S, Integer> replicasOptionInfo, PlanningContext ctx, S target) {
        assert (option.key().isSimple()) : option.key();
        String optionName = option.key().getSimple().toUpperCase();
        if (!this.knownZoneOptionNames.contains(optionName)) {
            throw DdlSqlToCommandConverter.unexpectedZoneOption(ctx, optionName);
        }
        if (!remainingKnownOptions.remove(optionName)) {
            throw DdlSqlToCommandConverter.duplicateZoneOption(ctx, ZoneOptionEnum.valueOf((String)optionName).sqlName);
        }
        ZoneOptionEnum zoneOption = ZoneOptionEnum.valueOf(optionName);
        DdlOptionInfo<S, Object> zoneOptionInfo = optionInfos.get((Object)zoneOption);
        assert (zoneOptionInfo != null || zoneOption == ZoneOptionEnum.REPLICAS) : zoneOption.sqlName;
        assert (option.value() instanceof SqlLiteral) : option.value();
        SqlLiteral literal = (SqlLiteral)option.value();
        if ((zoneOption == ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_UP || zoneOption == ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_DOWN) && literal.getTypeName() == SqlTypeName.SYMBOL) {
            IgniteSqlZoneOptionMode zoneOptionMode = (IgniteSqlZoneOptionMode)literal.symbolValue(IgniteSqlZoneOptionMode.class);
            if (zoneOptionMode != IgniteSqlZoneOptionMode.SCALE_OFF) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Unexpected value of zone auto adjust scale [expected OFF, was {}; query=\"{}\"", new Object[]{zoneOptionMode, ctx.query()}));
            }
            zoneOptionInfo.setter.accept(target, Commons.cast(Integer.MAX_VALUE));
            return;
        }
        if (zoneOption == ZoneOptionEnum.REPLICAS) {
            if (literal.getTypeName() == SqlTypeName.SYMBOL) {
                IgniteSqlZoneOptionMode zoneOptionMode = (IgniteSqlZoneOptionMode)literal.symbolValue(IgniteSqlZoneOptionMode.class);
                if (zoneOptionMode != IgniteSqlZoneOptionMode.ALL) {
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Unexpected value of zone replicas [expected ALL, was {}; query=\"{}\"", new Object[]{zoneOptionMode, ctx.query()}));
                }
                replicasOptionInfo.setter.accept(target, Integer.MAX_VALUE);
                return;
            }
            zoneOptionInfo = replicasOptionInfo;
        }
        DdlSqlToCommandConverter.updateCommandOption("Zone", optionName, (SqlNode)literal, zoneOptionInfo, ctx.query(), target);
    }

    private static <S, T> void updateCommandOption(String sqlObjName, Object optId, SqlNode value, DdlOptionInfo<S, T> optInfo, String query, S target) {
        T expectedValue = DdlSqlToCommandConverter.extractValueForUpdateCommandOption(sqlObjName, optId, value, optInfo, query);
        DdlSqlToCommandConverter.validateValue(sqlObjName, optId, optInfo, query, expectedValue);
        optInfo.setter.accept(target, expectedValue);
    }

    private static <BuilderT> void handleTablePropertyList(SqlNodeList propertyList, Map<IgniteSqlTablePropertyKey, DdlOptionInfo<BuilderT, ?>> propertyInfos, PlanningContext ctx, BuilderT target) {
        HashSet<String> remainingKnownOptions = new HashSet<String>(DdlSqlToCommandConverter.knownTablePropertyNames());
        for (SqlNode propertyNode : propertyList.getList()) {
            IgniteSqlTableProperty property = (IgniteSqlTableProperty)propertyNode;
            assert (property != null);
            String propertyName = property.key().name();
            if (!remainingKnownOptions.remove(propertyName)) {
                throw DdlSqlToCommandConverter.duplicateTableProperty(ctx, property.key().sqlName);
            }
            DdlOptionInfo<BuilderT, ?> propertyInfo = propertyInfos.get((Object)property.key());
            assert (property.value() instanceof SqlLiteral) : property.value();
            SqlLiteral literal = (SqlLiteral)property.value();
            DdlSqlToCommandConverter.updateCommandOption("Table", propertyName, (SqlNode)literal, propertyInfo, ctx.query(), target);
        }
    }

    private static <T, S> T extractValueForUpdateCommandOption(String sqlObjName, Object optId, SqlNode value, DdlOptionInfo<S, T> optInfo, String query) {
        SqlKind valueKind = value.getKind();
        switch (valueKind) {
            case IDENTIFIER: {
                return (T)((SqlIdentifier)value).getSimple();
            }
            case LITERAL: {
                return DdlSqlToCommandConverter.valueFromLiteralAccordingToOptionType(sqlObjName, optId, optInfo, query, (SqlLiteral)value);
            }
        }
        String msg = IgniteStringFormatter.format("Invalid {} value kind [kind={}, expectedKind=(IDENTIFIER, LITERAL), query={}]", sqlObjName.toLowerCase(), valueKind, query);
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg);
    }

    private static List<StorageProfileParams> extractProfiles(SqlNodeList values) {
        ArrayList<StorageProfileParams> profiles = new ArrayList<StorageProfileParams>(values.size());
        for (SqlNode node : values) {
            SqlCharStringLiteral literal = (SqlCharStringLiteral)node;
            String profile = ((String)literal.getValueAs(String.class)).trim();
            profiles.add(StorageProfileParams.builder().storageProfile(profile).build());
        }
        return profiles;
    }

    private static <S, T> void validateValue(String sqlObjName, Object optId, DdlOptionInfo<S, T> optInfo, String query, T expectedValue) {
        if (optInfo.validator == null) {
            return;
        }
        try {
            optInfo.validator.accept(expectedValue);
        }
        catch (Throwable e) {
            String msg = IgniteStringFormatter.format("{} option validation failed [option={}, err={}, query={}]", sqlObjName, optId, e.getMessage(), query);
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg, e);
        }
    }

    private static Set<String> knownTablePropertyNames() {
        return EnumSet.allOf(IgniteSqlTablePropertyKey.class).stream().map(Enum::name).collect(Collectors.toCollection(HashSet::new));
    }

    private static <T, S> T valueFromLiteralAccordingToOptionType(String sqlObjName, Object optId, DdlOptionInfo<S, T> optInfo, String query, SqlLiteral literalValue) {
        try {
            return (T)literalValue.getValueAs(optInfo.type);
        }
        catch (Throwable cause) {
            String msg = IgniteStringFormatter.format("Invalid {} option type [option={}, expectedType={}, query={}]", sqlObjName.toLowerCase(), optId, optInfo.type.getSimpleName(), query);
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg, cause);
        }
    }

    private void checkPositiveNumber(int num) {
        if (num < 0) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Must be positive:" + num);
        }
    }

    private void checkEmptyString(String string) {
        if (string.isBlank()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "String cannot be empty");
        }
    }

    @Nullable
    private static Object fromLiteral(ColumnType columnType, String name, SqlLiteral literal, int precision, int scale) {
        if (literal.getValue() == null) {
            return null;
        }
        try {
            switch (columnType) {
                case PERIOD: {
                    if (!(literal instanceof SqlIntervalLiteral)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression is not belongs to interval type");
                    }
                    String strValue = Objects.requireNonNull(literal.toValue());
                    SqlNumericLiteral numLiteral = SqlLiteral.createExactNumeric((String)strValue, (SqlParserPos)literal.getParserPosition());
                    int val = numLiteral.intValue(true);
                    SqlIntervalLiteral literal0 = (SqlIntervalLiteral)literal;
                    SqlIntervalQualifier qualifier = ((SqlIntervalLiteral.IntervalValue)literal0.getValue()).getIntervalQualifier();
                    if (qualifier.typeName() == SqlTypeName.INTERVAL_YEAR) {
                        val *= 12;
                    }
                    return TypeUtils.fromInternal(val, ColumnType.PERIOD);
                }
                case DURATION: {
                    if (!(literal instanceof SqlIntervalLiteral)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression is not belongs to interval type");
                    }
                    String strValue = Objects.requireNonNull(literal.toValue());
                    SqlNumericLiteral numLiteral = SqlLiteral.createExactNumeric((String)strValue, (SqlParserPos)literal.getParserPosition());
                    long val = numLiteral.longValue(true);
                    SqlIntervalLiteral literal0 = (SqlIntervalLiteral)literal;
                    SqlIntervalQualifier qualifier = ((SqlIntervalLiteral.IntervalValue)literal0.getValue()).getIntervalQualifier();
                    if (qualifier.typeName() == SqlTypeName.INTERVAL_DAY) {
                        val = Duration.ofDays(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_HOUR) {
                        val = Duration.ofHours(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_MINUTE) {
                        val = Duration.ofMinutes(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_SECOND) {
                        val = Duration.ofSeconds(val).toMillis();
                    }
                    return TypeUtils.fromInternal(val, ColumnType.DURATION);
                }
                case STRING: {
                    String val = literal.toValue();
                    if (precision != -1 && Objects.requireNonNull(val).length() > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Value too long for type character({})", precision));
                    }
                    return val;
                }
                case UUID: {
                    return UUID.fromString(Objects.requireNonNull(literal.toValue()));
                }
                case DATE: {
                    try {
                        literal = SqlParserUtil.parseDateLiteral((String)((String)literal.getValueAs(String.class)), (SqlParserPos)literal.getParserPosition());
                        int val = ((DateString)literal.getValueAs(DateString.class)).getDaysSinceEpoch();
                        return TypeUtils.fromInternal(val, ColumnType.DATE);
                    }
                    catch (CalciteContextException e) {
                        literal = SqlParserUtil.parseTimestampLiteral((String)((String)literal.getValueAs(String.class)), (SqlParserPos)literal.getParserPosition());
                        TimestampString tsString = (TimestampString)literal.getValueAs(TimestampString.class);
                        int val = IgniteMath.convertToIntExact(TimeUnit.MILLISECONDS.toDays(tsString.getMillisSinceEpoch()));
                        return TypeUtils.fromInternal(val, ColumnType.DATE);
                    }
                }
                case TIME: {
                    String strLiteral = ((String)literal.getValueAs(String.class)).trim();
                    int pos = strLiteral.indexOf(32);
                    if (pos != -1) {
                        strLiteral = strLiteral.substring(pos);
                    }
                    literal = SqlParserUtil.parseTimeLiteral((String)strLiteral, (SqlParserPos)literal.getParserPosition());
                    int val = ((TimeString)literal.getValueAs(TimeString.class)).getMillisOfDay();
                    return TypeUtils.fromInternal(val, ColumnType.TIME);
                }
                case DATETIME: {
                    String sourceValue = (String)literal.getValueAs(String.class);
                    literal = SqlParserUtil.parseTimestampLiteral((String)sourceValue, (SqlParserPos)literal.getParserPosition());
                    TimestampString tsString = (TimestampString)literal.getValueAs(TimestampString.class);
                    long ts = tsString.getMillisSinceEpoch();
                    if (ts < IgniteSqlFunctions.TIMESTAMP_MIN_INTERNAL || ts > IgniteSqlFunctions.TIMESTAMP_MAX_INTERNAL || IgniteSqlDateTimeUtils.isYearOutOfRange(sourceValue)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "TIMESTAMP out of range.");
                    }
                    return TypeUtils.fromInternal(tsString.getMillisSinceEpoch(), ColumnType.DATETIME);
                }
                case TIMESTAMP: {
                    throw new UnsupportedOperationException("Type is not supported: " + columnType);
                }
                case INT32: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToIntExact(val);
                }
                case INT64: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    BigDecimal val = literal.bigDecimalValue();
                    return Objects.requireNonNull(val).longValueExact();
                }
                case INT16: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToShortExact(val);
                }
                case INT8: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToByteExact(val);
                }
                case DECIMAL: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    BigDecimal val = (BigDecimal)literal.getValueAs(BigDecimal.class);
                    val = val.setScale(scale, RoundingMode.HALF_UP);
                    if (val.precision() > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Numeric field overflow for type decimal({}, {})", precision, scale));
                    }
                    return val;
                }
                case DOUBLE: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    return literal.getValueAs(Double.class);
                }
                case FLOAT: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    return literal.getValueAs(Float.class);
                }
                case BYTE_ARRAY: {
                    byte[] arr = (byte[])literal.getValueAs(byte[].class);
                    if (precision != -1 && Objects.requireNonNull(arr).length > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Value too long for type binary({})", precision));
                    }
                    return arr;
                }
                case BOOLEAN: {
                    return literal.getValueAs(Boolean.class);
                }
            }
            throw new IllegalStateException("Unknown type [type=" + columnType + "]");
        }
        catch (Throwable th) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Invalid default value for column '{}'", name), th);
        }
    }

    private static void acceptNumericLiteral(SqlLiteral literal, ColumnType columnType) {
        if (!(literal instanceof SqlNumericLiteral)) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression can`t be applied to type " + columnType);
        }
    }

    private static IgniteException unexpectedZoneOption(PlanningContext ctx, String optionName) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Unexpected zone option [option={}, query={}]", optionName, ctx.query()));
    }

    private static IgniteException duplicateZoneOption(PlanningContext ctx, String optionName) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Duplicate zone option has been specified [option={}, query={}]", optionName, ctx.query()));
    }

    private static IgniteException duplicateTableProperty(PlanningContext ctx, String propertyName) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format("Duplicate table property has been specified [property={}, query={}]", propertyName, ctx.query()));
    }

    static class ColumnTypeParams {
        final ColumnType colType;
        @Nullable
        Integer precision = null;
        @Nullable
        Integer scale = null;
        @Nullable
        Integer length = null;

        ColumnTypeParams(RelDataType relType) {
            this.colType = TypeUtils.columnType(relType);
            if (this.colType.lengthAllowed()) {
                this.length = relType.getPrecision() == -1 ? CatalogUtils.defaultLength(this.colType, 1) : relType.getPrecision();
            } else {
                if (relType.getSqlTypeName().allowsPrec() && relType.getPrecision() != -1) {
                    this.precision = relType.getPrecision();
                }
                if (relType.getSqlTypeName().allowsScale() && relType.getScale() != Integer.MIN_VALUE) {
                    this.scale = relType.getScale();
                }
            }
        }
    }
}

