/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.bounds;

import java.util.Objects;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rex.IgniteRexBuilder;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class RangeBounds
extends SearchBounds {
    private static final RexLiteral ALWAYS_TRUE = IgniteRexBuilder.INSTANCE.makeLiteral(true);
    @Nullable
    private final RexNode shouldComputeLower;
    @Nullable
    private final RexNode lowerBound;
    private final boolean lowerInclude;
    @Nullable
    private final RexNode shouldComputeUpper;
    @Nullable
    private final RexNode upperBound;
    private final boolean upperInclude;

    public RangeBounds(RexNode condition, @Nullable RexNode lowerBound, @Nullable RexNode upperBound, boolean lowerInclude, boolean upperInclude) {
        this(condition, (RexNode)ALWAYS_TRUE, lowerBound, lowerInclude, (RexNode)ALWAYS_TRUE, upperBound, upperInclude);
    }

    public RangeBounds(RexNode condition, @Nullable RexNode shouldComputeLower, @Nullable RexNode lowerBound, boolean lowerInclude, @Nullable RexNode shouldComputeUpper, @Nullable RexNode upperBound, boolean upperInclude) {
        super(condition);
        this.shouldComputeLower = shouldComputeLower;
        this.lowerBound = lowerBound;
        this.lowerInclude = lowerInclude;
        this.shouldComputeUpper = shouldComputeUpper;
        this.upperBound = upperBound;
        this.upperInclude = upperInclude;
    }

    @Nullable
    public RexNode shouldComputeLower() {
        return this.shouldComputeLower;
    }

    @Nullable
    public RexNode lowerBound() {
        return this.lowerBound;
    }

    @Nullable
    public RexNode shouldComputeUpper() {
        return this.shouldComputeUpper;
    }

    @Nullable
    public RexNode upperBound() {
        return this.upperBound;
    }

    public boolean lowerInclude() {
        return this.lowerInclude;
    }

    public boolean upperInclude() {
        return this.upperInclude;
    }

    @Override
    public SearchBounds.Type type() {
        return SearchBounds.Type.RANGE;
    }

    @Override
    public SearchBounds accept(RexShuttle shuttle) {
        RexNode condition = this.condition();
        RexNode newCondition = shuttle.apply(condition);
        RexNode newLowerBound = shuttle.apply(this.lowerBound);
        RexNode newUpperBound = shuttle.apply(this.upperBound);
        RexNode newShouldComputeLower = shuttle.apply(this.shouldComputeLower);
        RexNode newShouldComputeUpper = shuttle.apply(this.shouldComputeUpper);
        if (newLowerBound == this.lowerBound && newUpperBound == this.upperBound && newCondition == condition && newShouldComputeLower == this.shouldComputeLower && newShouldComputeUpper == this.shouldComputeUpper) {
            return this;
        }
        return new RangeBounds(condition, newShouldComputeLower, newLowerBound, this.lowerInclude, newShouldComputeUpper, newUpperBound, this.upperInclude);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.lowerInclude == ((RangeBounds)o).lowerInclude && this.upperInclude == ((RangeBounds)o).upperInclude && Objects.equals(this.shouldComputeLower, ((RangeBounds)o).shouldComputeLower) && Objects.equals(this.shouldComputeUpper, ((RangeBounds)o).shouldComputeUpper) && Objects.equals(this.lowerBound, ((RangeBounds)o).lowerBound) && Objects.equals(this.upperBound, ((RangeBounds)o).upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.shouldComputeLower, this.shouldComputeUpper, this.lowerInclude, this.upperInclude);
    }

    public String toString() {
        return S.toString(RangeBounds.class, this);
    }
}

