/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.ReferenceCounter;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTracker;
import org.apache.ignite3.internal.sql.engine.exec.memory.ObjectSizeCalculator;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;

public class MemoryContextImpl<RowT>
implements MemoryContext<RowT> {
    @IgniteToStringExclude
    private final ReferenceCounter<RowT> refCounter;
    private final MemoryTracker memoryTracker;
    @IgniteToStringExclude
    private final ObjectSizeCalculator calculator;

    public MemoryContextImpl(MemoryTracker memoryTracker, ReferenceCounter<RowT> refCounter) {
        this(memoryTracker, refCounter, List.of());
    }

    public MemoryContextImpl(MemoryTracker memoryTracker, ReferenceCounter<RowT> refCounter, List<Class<?>> objClasses) {
        this.refCounter = refCounter;
        this.memoryTracker = memoryTracker;
        this.calculator = new ObjectSizeCalculator(objClasses);
    }

    @Override
    public void acquire(RowT row) {
        if (this.refCounter.acquire(row) == 1) {
            long size = this.calculator.sizeOf(row);
            this.memoryTracker.acquire(size);
        }
    }

    @Override
    public boolean tryAcquire(RowT row) {
        if (this.refCounter.acquire(row) == 1) {
            long size = this.calculator.sizeOf(row);
            return this.memoryTracker.tryAcquire(size);
        }
        return true;
    }

    @Override
    public void release(RowT row) {
        if (this.refCounter.release(row) == 0) {
            long size = this.calculator.sizeOf(row);
            this.memoryTracker.release(size);
        }
    }

    @Override
    public void acquireObject(Object obj) {
        long size = this.calculator.sizeOf(obj);
        this.memoryTracker.acquire(size);
    }

    @Override
    public boolean tryAcquireObject(Object obj) {
        long size = this.calculator.sizeOf(obj);
        return this.memoryTracker.tryAcquire(size);
    }

    @Override
    public void releaseObject(Object obj) {
        long size = this.calculator.sizeOf(obj);
        this.memoryTracker.release(size);
    }

    @Override
    public void acquireEntry(Object key, Object value) {
        long size1 = this.calculator.sizeOf(key);
        long size2 = this.calculator.sizeOf(value);
        this.memoryTracker.acquire(size1 + size2);
    }

    @Override
    public boolean tryAcquireEntry(Object key, Object value) {
        long size1 = this.calculator.sizeOf(key);
        long size2 = this.calculator.sizeOf(value);
        return this.memoryTracker.tryAcquire(size1 + size2);
    }

    @Override
    public void releaseEntry(Object key, Object value) {
        long size1 = this.calculator.sizeOf(key);
        long size2 = this.calculator.sizeOf(value);
        this.memoryTracker.release(size1 + size2);
    }

    @Override
    public void close() {
        this.refCounter.close();
        this.memoryTracker.close();
    }

    public String toString() {
        return S.toString(MemoryContextImpl.class, this);
    }
}

