/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite3.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite3.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite3.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite3.internal.tostring.S;

public class MailboxRegistryImpl
implements MailboxRegistry,
LogicalTopologyEventListener {
    private static final IgniteLogger LOG = Loggers.forClass(MailboxRegistryImpl.class);
    private final Map<MailboxKey, CompletableFuture<Outbox<?>>> locals = new ConcurrentHashMap();
    private final Map<MailboxKey, Inbox<?>> remotes = new ConcurrentHashMap();

    @Override
    public void start() {
    }

    @Override
    public void register(Inbox<?> inbox) {
        Inbox<?> res = this.remotes.putIfAbsent(new MailboxKey(inbox.executionId(), inbox.exchangeId()), inbox);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inbox registered [executionId={}, fragmentId={}]", inbox.executionId(), inbox.fragmentId());
        }
        assert (res == null) : res;
    }

    @Override
    public void register(Outbox<?> outbox) {
        CompletableFuture res = this.locals.computeIfAbsent(new MailboxKey(outbox.executionId(), outbox.exchangeId()), k -> new CompletableFuture());
        assert (!res.isDone());
        res.complete(outbox);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Outbox registered [executionId={}, fragmentId={}]", outbox.executionId(), outbox.fragmentId());
        }
    }

    @Override
    public void unregister(Inbox<?> inbox) {
        boolean removed = this.remotes.remove(new MailboxKey(inbox.executionId(), inbox.exchangeId()), inbox);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inbox {} unregistered [executionId={}, fragmentId={}]", removed ? "was" : "wasn't", inbox.executionId(), inbox.fragmentId());
        }
    }

    @Override
    public void unregister(Outbox<?> outbox) {
        boolean removed;
        boolean bl = removed = this.locals.remove(new MailboxKey(outbox.executionId(), outbox.exchangeId())) != null;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Outbox {} unregistered [executionId={}, fragmentId={}]", removed ? "was" : "wasn't", outbox.executionId(), outbox.fragmentId());
        }
    }

    @Override
    public CompletableFuture<Outbox<?>> outbox(ExecutionId executionId, long exchangeId) {
        return this.locals.computeIfAbsent(new MailboxKey(executionId, exchangeId), k -> new CompletableFuture());
    }

    @Override
    public Inbox<?> inbox(ExecutionId executionId, long exchangeId) {
        return this.remotes.get(new MailboxKey(executionId, exchangeId));
    }

    public String toString() {
        return S.toString(MailboxRegistryImpl.class, this);
    }

    @Override
    public void stop() {
        this.locals.clear();
        this.remotes.clear();
    }

    @Override
    public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
        this.locals.values().forEach(fut -> fut.thenAccept(n -> n.onNodeLeft(leftNode, newTopology.version())));
        this.remotes.values().forEach(n -> n.onNodeLeft(leftNode, newTopology.version()));
    }

    private static class MailboxKey {
        private final ExecutionId executionId;
        private final long exchangeId;

        private MailboxKey(ExecutionId executionId, long exchangeId) {
            this.executionId = executionId;
            this.exchangeId = exchangeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MailboxKey that = (MailboxKey)o;
            if (this.exchangeId != that.exchangeId) {
                return false;
            }
            return this.executionId.equals(that.executionId);
        }

        public int hashCode() {
            int res = this.executionId.hashCode();
            res = 31 * res + (int)(this.exchangeId ^ this.exchangeId >>> 32);
            return res;
        }

        public String toString() {
            return S.toString(MailboxKey.class, this);
        }
    }
}

