/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.commands.DefaultPartitionCountProvider;
import org.apache.ignite3.internal.catalog.commands.DefaultPartitionCountProviderImpl;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.failure.FailureManager;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.placementdriver.PlacementDriver;
import org.apache.ignite3.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite3.internal.properties.IgniteProductVersion;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.schema.SchemaManager;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.sql.SqlCommon;
import org.apache.ignite3.internal.sql.configuration.distributed.CreateTableDefaultsView;
import org.apache.ignite3.internal.sql.configuration.distributed.SqlDistributedConfiguration;
import org.apache.ignite3.internal.sql.configuration.local.SqlLocalConfiguration;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InflightTransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryCancel;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.QueryPrefetchCallback;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.sql.engine.SqlOperationContext;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.sql.engine.SqlQueriesViewProvider;
import org.apache.ignite3.internal.sql.engine.api.kill.CancellableOperationType;
import org.apache.ignite3.internal.sql.engine.api.kill.OperationKillHandler;
import org.apache.ignite3.internal.sql.engine.exec.ExchangeServiceImpl;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistryImpl;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionDependencyResolverImpl;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionServiceImpl;
import org.apache.ignite3.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite3.internal.sql.engine.exec.MailboxRegistryImpl;
import org.apache.ignite3.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite3.internal.sql.engine.exec.QueryTaskExecutorImpl;
import org.apache.ignite3.internal.sql.engine.exec.SecuredExecutionService;
import org.apache.ignite3.internal.sql.engine.exec.SqlRowHandler;
import org.apache.ignite3.internal.sql.engine.exec.TransactionalOperationTracker;
import org.apache.ignite3.internal.sql.engine.exec.ddl.RbacDdlCommandHandler;
import org.apache.ignite3.internal.sql.engine.exec.ddl.SecuredDdlCommandHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.exp.func.TableFunctionRegistryImpl;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryExecutor;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryIdGenerator;
import org.apache.ignite3.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ValidationHelper;
import org.apache.ignite3.internal.sql.engine.exec.kill.KillCommandHandler;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ExecutionDistributionProviderImpl;
import org.apache.ignite3.internal.sql.engine.exec.mapping.MappingServiceImpl;
import org.apache.ignite3.internal.sql.engine.exec.memory.SqlMemoryManager;
import org.apache.ignite3.internal.sql.engine.exec.query.CopyHandler;
import org.apache.ignite3.internal.sql.engine.exec.query.ShowHandler;
import org.apache.ignite3.internal.sql.engine.message.MessageServiceImpl;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite3.internal.sql.engine.prepare.PrepareServiceImpl;
import org.apache.ignite3.internal.sql.engine.prepare.QueryMetadata;
import org.apache.ignite3.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopySqlToCommandConverter;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.ClusterWideNodeFilterValidator;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.ClusterWideStorageProfileValidator;
import org.apache.ignite3.internal.sql.engine.prepare.ddl.DdlSqlToCommandConverter;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPrunerImpl;
import org.apache.ignite3.internal.sql.engine.prepare.show.QuerySqlToShowCommandConverter;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManagerImpl;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.sql.ParserServiceImpl;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticManager;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticManagerImpl;
import org.apache.ignite3.internal.sql.engine.statistic.SqlStatisticUpdateManager;
import org.apache.ignite3.internal.sql.engine.statistic.StatisticAggregatorImpl;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionContextImpl;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.sql.engine.util.cache.CaffeineCacheFactory;
import org.apache.ignite3.internal.sql.metrics.SqlClientMetricSource;
import org.apache.ignite3.internal.sql.metrics.SqlQueryMetricSource;
import org.apache.ignite3.internal.storage.DataStorageManager;
import org.apache.ignite3.internal.systemview.api.SystemView;
import org.apache.ignite3.internal.systemview.api.SystemViewManager;
import org.apache.ignite3.internal.systemview.api.SystemViewProvider;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.internal.table.distributed.TableStatsStalenessConfiguration;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.impl.TransactionInflights;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.rbac.Rbac;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlQueryProcessor
implements QueryProcessor,
SystemViewProvider {
    private static final int PARSED_RESULT_CACHE_SIZE = 10000;
    private static final int TABLE_CACHE_SIZE = 1024;
    private static final int COMPILED_EXPRESSIONS_CACHE_SIZE = 1024;
    private static final int SCHEMA_CACHE_SIZE = 128;
    private static final CacheFactory CACHE_FACTORY = CaffeineCacheFactory.INSTANCE;
    private static final long EXECUTION_SERVICE_SHUTDOWN_TIMEOUT = 60000L;
    private final SqlQueriesViewProvider queriesViewProvider = new SqlQueriesViewProvider();
    private final List<LifecycleAware> services = new ArrayList<LifecycleAware>();
    private final ClusterService clusterSrvc;
    private final LogicalTopologyService logicalTopologyService;
    private final TableManager tableManager;
    private final SchemaManager schemaManager;
    private final DataStorageManager dataStorageManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ReplicaService replicaService;
    private final SqlSchemaManager sqlSchemaManager;
    private final SqlStatisticUpdateManager sqlStatisticManager;
    private final FailureManager failureManager;
    private final SystemViewManager systemViewManager;
    private final KillCommandHandler killCommandHandler;
    private final Path workDir;
    private volatile QueryExecutor queryExecutor;
    private volatile QueryTaskExecutor taskExecutor;
    private volatile PrepareService prepareSvc;
    private final ClockService clockService;
    private final SchemaSyncService schemaSyncService;
    private final CatalogManager catalogManager;
    private final MetricManager metricManager;
    private final PlacementDriver placementDriver;
    private final SqlDistributedConfiguration clusterCfg;
    private final SqlLocalConfiguration nodeCfg;
    private final TxManager txManager;
    private final NodeProperties nodeProperties;
    private final TransactionalOperationTracker txTracker;
    private final ScheduledExecutorService commonScheduler;
    private final EventLog eventLog;
    private final Rbac rbac;
    private final LicenseFeatureChecker licenseFeatureChecker;
    private SqlMemoryManager<SqlRowHandler.RowWrapper> memoryManager;
    private final DefaultPartitionCountProvider defaultPartitionNumberFunction;

    public SqlQueryProcessor(ClusterService clusterSrvc, LogicalTopologyService logicalTopologyService, TableManager tableManager, SchemaManager schemaManager, DataStorageManager dataStorageManager, ReplicaService replicaService, ClockService clockService, SchemaSyncService schemaSyncService, CatalogManager catalogManager, MetricManager metricManager, SystemViewManager systemViewManager, FailureManager failureManager, PlacementDriver placementDriver, SqlDistributedConfiguration clusterCfg, SqlLocalConfiguration nodeCfg, TransactionInflights transactionInflights, TxManager txManager, NodeProperties nodeProperties, LowWatermark lowWaterMark, ScheduledExecutorService commonScheduler, KillCommandHandler killCommandHandler, EventLog eventLog, Rbac rbac, LicenseFeatureChecker licenseChecker, DistributionZoneManager distributionZoneManager, Path workDir, ClusterManagementGroupManager cmgMgr) {
        this.clusterSrvc = clusterSrvc;
        this.logicalTopologyService = logicalTopologyService;
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.dataStorageManager = dataStorageManager;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.schemaSyncService = schemaSyncService;
        this.catalogManager = catalogManager;
        this.metricManager = metricManager;
        this.systemViewManager = systemViewManager;
        this.failureManager = failureManager;
        this.placementDriver = placementDriver;
        this.clusterCfg = clusterCfg;
        this.nodeCfg = nodeCfg;
        this.txTracker = new InflightTransactionalOperationTracker(transactionInflights);
        this.txManager = txManager;
        this.nodeProperties = nodeProperties;
        this.commonScheduler = commonScheduler;
        this.killCommandHandler = killCommandHandler;
        this.eventLog = eventLog;
        this.rbac = rbac;
        this.licenseFeatureChecker = licenseChecker;
        this.defaultPartitionNumberFunction = new DefaultPartitionCountProviderImpl(distributionZoneManager::estimatedDataNodesCount);
        this.workDir = workDir;
        StatisticAggregatorImpl statAggregator = new StatisticAggregatorImpl(() -> logicalTopologyService.localLogicalTopology().nodes(), clusterSrvc.messagingService());
        IgniteProductVersion versionWithStatGatheringChange = IgniteProductVersion.fromString("9.1.15");
        this.sqlStatisticManager = new SqlStatisticManagerImpl(tableManager, catalogManager, lowWaterMark, commonScheduler, statAggregator, () -> cmgMgr.safeToCallWithProductVersion(versionWithStatGatheringChange));
        this.sqlSchemaManager = new SqlSchemaManagerImpl(catalogManager, this.sqlStatisticManager, nodeProperties, CACHE_FACTORY, 128, dataStorageManager);
    }

    @Override
    public synchronized CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        InternalClusterNode localNode = this.clusterSrvc.topologyService().localMember();
        String nodeName = localNode.name();
        this.taskExecutor = this.registerService(new QueryTaskExecutorImpl(nodeName, (Integer)this.nodeCfg.execution().threadCount().value(), this.failureManager, this.metricManager));
        MailboxRegistryImpl mailboxRegistry = this.registerService(new MailboxRegistryImpl());
        SqlClientMetricSource sqlClientMetricSource = new SqlClientMetricSource(this::openedCursors);
        this.metricManager.registerSource(sqlClientMetricSource);
        this.metricManager.enable(sqlClientMetricSource);
        SqlQueryMetricSource sqlQueryMetricSource = new SqlQueryMetricSource();
        this.metricManager.registerSource(sqlQueryMetricSource);
        this.metricManager.enable(sqlQueryMetricSource);
        ClusterWideStorageProfileValidator storageProfileValidator = new ClusterWideStorageProfileValidator(this.logicalTopologyService);
        ClusterWideNodeFilterValidator nodeFilterValidator = new ClusterWideNodeFilterValidator(this.logicalTopologyService);
        Supplier<TableStatsStalenessConfiguration> stalenessProperties = () -> {
            CreateTableDefaultsView tablePropertiesView = (CreateTableDefaultsView)this.clusterCfg.createTable().value();
            return new TableStatsStalenessConfiguration(tablePropertiesView.staleRowsFraction(), tablePropertiesView.minStaleRowsCount());
        };
        DdlSqlToCommandConverter ddlSqlToCommandConverter = new DdlSqlToCommandConverter(storageProfileValidator, nodeFilterValidator, stalenessProperties, this.clockService, this.dataStorageManager, this.defaultPartitionNumberFunction, this.licenseFeatureChecker);
        QuerySqlToShowCommandConverter showCommandConverter = new QuerySqlToShowCommandConverter();
        CopySqlToCommandConverter copySqlToCommandConverter = new CopySqlToCommandConverter();
        PrepareServiceImpl prepareSvc = this.registerService(PrepareServiceImpl.create(nodeName, CACHE_FACTORY, showCommandConverter, copySqlToCommandConverter, this.metricManager, this.clusterCfg, this.nodeCfg, this.sqlSchemaManager, ddlSqlToCommandConverter, sqlQueryMetricSource, this.clockService::currentLong, this.commonScheduler, this.sqlStatisticManager));
        MessageServiceImpl msgSrvc = this.registerService(new MessageServiceImpl(localNode, this.clusterSrvc.messagingService(), this.taskExecutor, this.busyLock, this.clockService));
        ExchangeServiceImpl exchangeService = this.registerService(new ExchangeServiceImpl(mailboxRegistry, msgSrvc, this.clockService));
        this.prepareSvc = prepareSvc;
        SecuredDdlCommandHandler ddlCommandHandler = this.registerService(new SecuredDdlCommandHandler(this.catalogManager, this.rbac, this.clockService, this.licenseFeatureChecker));
        RbacDdlCommandHandler rbacDdlCommandHandler = new RbacDdlCommandHandler(this.rbac.userManagement(), this.rbac.roleManagement(), this.rbac.privilegeManagement(), this.rbac.roleAssignmentManagement(), this.licenseFeatureChecker);
        ExecutableTableRegistryImpl executableTableRegistry = new ExecutableTableRegistryImpl(this.tableManager, this.schemaManager, this.sqlSchemaManager, this.replicaService, this.clockService, this.nodeProperties, 1024, CACHE_FACTORY);
        TableFunctionRegistryImpl tableFunctionRegistry = new TableFunctionRegistryImpl();
        ExecutionDependencyResolverImpl dependencyResolver = new ExecutionDependencyResolverImpl(executableTableRegistry, view -> () -> this.systemViewManager.scanView(view.name()));
        PartitionPrunerImpl partitionPruner = new PartitionPrunerImpl();
        MappingServiceImpl mappingService = new MappingServiceImpl(nodeName, this.clockService, CACHE_FACTORY, (Integer)this.clusterCfg.planner().estimatedNumberOfQueries().value(), partitionPruner, new ExecutionDistributionProviderImpl(this.placementDriver, this.systemViewManager, this.nodeProperties), this.nodeProperties, this.taskExecutor);
        this.logicalTopologyService.addEventListener(mappingService);
        this.logicalTopologyService.addEventListener(mailboxRegistry);
        this.placementDriver.listen(PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, mappingService::onPrimaryReplicaExpired);
        ShowHandler showHandler = new ShowHandler(this.rbac);
        CopyHandler copyHandler = this.registerService(new CopyHandler(nodeName, this.tableManager, this.licenseFeatureChecker));
        SqlMemoryManager sqlMemoryManager = new SqlMemoryManager(this.nodeCfg.nodeMemoryQuota(), this.clusterCfg.statementMemoryQuota(), this.metricManager, this.clusterCfg.offloadingEnabled(), this.workDir, this.nodeCfg.offloadingDataDir(), this.nodeCfg.offloadingDataLimit());
        this.memoryManager = this.registerService(sqlMemoryManager);
        ExecutionServiceImpl<SqlRowHandler.RowWrapper> executionSrvc = this.registerService(ExecutionServiceImpl.create(this.clusterSrvc.topologyService(), msgSrvc, this.sqlSchemaManager, ddlCommandHandler, rbacDdlCommandHandler, showHandler, copyHandler, this.taskExecutor, SqlRowHandler.INSTANCE, mailboxRegistry, exchangeService, mappingService, executableTableRegistry, dependencyResolver, tableFunctionRegistry, this.clockService, this.nodeProperties, this.killCommandHandler, new ExpressionFactoryImpl(Commons.typeFactory(), 1024, CACHE_FACTORY), 60000L, this.memoryManager::createFragmentMemoryContextFactory));
        this.queryExecutor = this.registerService(new QueryExecutor(this.clusterSrvc.topologyService().localMember().name(), CACHE_FACTORY, 10000, new ParserServiceImpl(), this.taskExecutor, this.commonScheduler, this.clockService, this.schemaSyncService, prepareSvc, this.catalogManager, new SecuredExecutionService(executionSrvc, this.rbac.authorizer()), this.txTracker, new QueryIdGenerator(nodeName.hashCode()), this.eventLog, sqlQueryMetricSource, this.licenseFeatureChecker));
        this.queriesViewProvider.init(this.queryExecutor, prepareSvc);
        this.logicalTopologyService.addEventListener(executionSrvc);
        this.registerService(this.sqlStatisticManager);
        this.services.forEach(LifecycleAware::start);
        this.killCommandHandler.register(new SqlQueryKillHandler());
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.metricManager.unregisterSource("sql.client");
        ArrayList<LifecycleAware> services = new ArrayList<LifecycleAware>(this.services);
        this.services.clear();
        Collections.reverse(services);
        try {
            IgniteUtils.closeAll(services.stream().map(s -> s::stop));
        }
        catch (Exception e) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.metricManager.unregisterSource("sql.queries");
        }
        return CompletableFutures.nullCompletedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<QueryMetadata> prepareSingleAsync(SqlProperties properties, @Nullable InternalTransaction transaction, String qry, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            this.licenseFeatureChecker.checkFeature(LicenseFeature.SQL);
            CompletableFuture<QueryMetadata> completableFuture = this.prepareSingleAsync0(properties, transaction, qry, params);
            return completableFuture;
        }
        catch (MissingRequiredFeaturesException e) {
            CompletableFuture<QueryMetadata> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AsyncSqlCursor<InternalSqlRow>> queryAsync(SqlProperties properties, HybridTimestampTracker observableTimeTracker, @Nullable InternalTransaction transaction, @Nullable CancellationToken cancellationToken, String qry, SecurityContext securityContext, Object ... params) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            this.licenseFeatureChecker.checkFeature(LicenseFeature.SQL);
            QueryTransactionContextImpl txContext = new QueryTransactionContextImpl(this.txManager, observableTimeTracker, transaction, this.txTracker);
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> completableFuture = this.queryExecutor.executeQuery(properties, txContext, qry, cancellationToken, securityContext, params);
            return completableFuture;
        }
        catch (MissingRequiredFeaturesException e) {
            CompletableFuture<AsyncSqlCursor<InternalSqlRow>> completableFuture = CompletableFuture.failedFuture(e);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private <T extends LifecycleAware> T registerService(T service) {
        this.services.add(service);
        return service;
    }

    private CompletableFuture<QueryMetadata> prepareSingleAsync0(SqlProperties properties, @Nullable InternalTransaction explicitTransaction, String sql, Object ... params) {
        ParsedResult parsedResult;
        String schemaName = properties.defaultSchema();
        long queryTimeout = properties.queryTimeout();
        QueryCancel queryCancel = new QueryCancel();
        if (queryTimeout != 0L) {
            queryCancel.setTimeout(this.commonScheduler, queryTimeout);
        }
        CompletableFuture<ParsedResult> start = (parsedResult = this.queryExecutor.lookupParsedResultInCache(sql)) != null ? CompletableFuture.completedFuture(parsedResult) : CompletableFuture.supplyAsync(() -> this.parseAndCache(sql), this.taskExecutor);
        return start.thenCompose(result -> {
            ValidationHelper.validateParsedStatement(properties, result);
            ValidationHelper.validateDynamicParameters(result.dynamicParamsCount(), params, false);
            HybridTimestamp timestamp = explicitTransaction != null ? explicitTransaction.schemaTimestamp() : this.clockService.now();
            CompletionStage f = this.prepareParsedStatement(schemaName, (ParsedResult)result, timestamp, queryCancel, params).thenApply(plan -> new QueryMetadata(plan.metadata(), plan.parameterMetadata()));
            try {
                queryCancel.add(arg_0 -> SqlQueryProcessor.lambda$prepareSingleAsync0$8((CompletableFuture)f, arg_0));
            }
            catch (QueryCancelledException queryCancelledException) {
                // empty catch block
            }
            return f;
        });
    }

    private CompletableFuture<QueryPlan> prepareParsedStatement(String schemaName, ParsedResult parsedResult, HybridTimestamp timestamp, QueryCancel queryCancel, Object[] params) {
        return this.waitForMetadata(timestamp).thenCompose(schema -> {
            SqlOperationContext ctx = SqlOperationContext.builder().queryId(UUID.randomUUID()).timeZoneId(SqlCommon.DEFAULT_TIME_ZONE_ID).defaultSchemaName(schemaName).operationTime(timestamp).cancel(queryCancel).parameters(params).build();
            return this.prepareSvc.prepareAsync(parsedResult, ctx);
        });
    }

    private CompletableFuture<Void> waitForMetadata(HybridTimestamp timestamp) {
        return this.schemaSyncService.waitForMetadataCompleteness(timestamp);
    }

    @TestOnly
    public MetricManager metricManager() {
        return this.metricManager;
    }

    @TestOnly
    public SqlStatisticManager sqlStatisticManager() {
        return this.sqlStatisticManager;
    }

    @TestOnly
    public SqlLocalConfiguration nodeConfig() {
        return this.nodeCfg;
    }

    @TestOnly
    public SqlDistributedConfiguration clusterConfig() {
        return this.clusterCfg;
    }

    private ParsedResult parseAndCache(String sql) {
        ParsedResult result = this.queryExecutor.parse(sql);
        if (result.queryType().supportsParseResultCaching()) {
            this.queryExecutor.updateParsedResultCache(sql, result);
        }
        return result;
    }

    public int openedCursors() {
        QueryExecutor executor = this.queryExecutor;
        if (executor == null) {
            return 0;
        }
        return (int)executor.runningQueries().stream().filter(info -> info.phase() == ExecutionPhase.EXECUTING && !info.script()).count();
    }

    @TestOnly
    public List<QueryInfo> runningQueries() {
        QueryExecutor executor = this.queryExecutor;
        if (executor == null) {
            return List.of();
        }
        return executor.runningQueries();
    }

    @TestOnly
    public SqlMemoryManager<?> memoryManager() {
        return this.memoryManager;
    }

    @Override
    public List<SystemView<?>> systemViews() {
        return this.queriesViewProvider.getViews();
    }

    @Override
    public CompletableFuture<Void> invalidatePlannerCache(Set<String> tableNames) {
        return this.prepareSvc.invalidateCache(tableNames);
    }

    @Override
    @TestOnly
    public void dumpState(IgniteStringBuilder writer, String indent) {
        this.queryExecutor.dumpState(writer, indent);
    }

    private static /* synthetic */ void lambda$prepareSingleAsync0$8(CompletableFuture f, boolean timeout) {
        String message = timeout ? "Query timeout" : "The query was cancelled while executing.";
        f.completeExceptionally(new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, message));
    }

    private class SqlQueryKillHandler
    implements OperationKillHandler {
        private SqlQueryKillHandler() {
        }

        @Override
        public CompletableFuture<Boolean> cancelAsync(String operationId) {
            Objects.requireNonNull(operationId, "operationId");
            UUID queryId = UUID.fromString(operationId);
            return SqlQueryProcessor.this.queryExecutor.cancelQuery(queryId);
        }

        @Override
        public boolean local() {
            return true;
        }

        @Override
        public CancellableOperationType type() {
            return CancellableOperationType.QUERY;
        }
    }

    public static class PrefetchCallback
    implements QueryPrefetchCallback {
        private final CompletableFuture<Void> prefetchFuture = new CompletableFuture();

        @Override
        public void onPrefetchComplete(@Nullable Throwable ex) {
            if (ex == null) {
                this.prefetchFuture.complete(null);
            } else {
                this.prefetchFuture.completeExceptionally(SqlExceptionMapperUtil.mapToPublicSqlException(ExceptionUtils.unwrapCause(ex)));
            }
        }

        public CompletableFuture<Void> prefetchFuture() {
            return this.prefetchFuture;
        }
    }
}

