/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.configuration;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.configuration.ConfigurationManager;
import org.apache.ignite3.internal.configuration.presentation.ConfigurationPresentation;
import org.apache.ignite3.internal.configuration.presentation.HoconPresentation;
import org.apache.ignite3.internal.rest.RestFactory;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rest.rbac.configuration.SecuredHoconPresentation;

@Factory
public class PresentationsFactory
implements RestFactory {
    private ConfigurationPresentation<String> nodeCfgPresentation;
    private ConfigurationPresentation<String> clusterCfgPresentation;

    public PresentationsFactory(ConfigurationManager nodeCfgMgr, ConfigurationManager clusterCfgMgr, Authorizer authorizer) {
        this.nodeCfgPresentation = new SecuredHoconPresentation(new HoconPresentation(nodeCfgMgr.configurationRegistry()), authorizer, Action.READ_NODE_CONFIG, Action.WRITE_NODE_CONFIG);
        this.clusterCfgPresentation = new SecuredHoconPresentation(new HoconPresentation(clusterCfgMgr.configurationRegistry()), authorizer, Action.READ_CLUSTER_CONFIG, Action.WRITE_CLUSTER_CONFIG);
    }

    @Bean
    @Singleton
    @Named(value="clusterCfgPresentation")
    public ConfigurationPresentation<String> clusterCfgPresentation() {
        return this.clusterCfgPresentation;
    }

    @Bean
    @Singleton
    @Named(value="nodeCfgPresentation")
    public ConfigurationPresentation<String> nodeCfgPresentation() {
        return this.nodeCfgPresentation;
    }

    @Override
    public void cleanResources() {
        this.nodeCfgPresentation = null;
        this.clusterCfgPresentation = null;
    }
}

