/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.compute;

import io.micronaut.http.annotation.Controller;
import io.micronaut.security.utils.SecurityService;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.compute.IgniteComputeInternal;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.compute.ComputeApi;
import org.apache.ignite3.internal.rest.api.compute.JobState;
import org.apache.ignite3.internal.rest.api.compute.JobStatus;
import org.apache.ignite3.internal.rest.api.compute.UpdateJobPriorityBody;
import org.apache.ignite3.internal.rest.compute.exception.ComputeJobNotFoundException;
import org.apache.ignite3.internal.rest.compute.exception.ComputeJobStatusException;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.rest.SecurityContextAware;
import org.jetbrains.annotations.Nullable;

@Controller
public class ComputeController
implements ComputeApi,
ResourceHolder,
SecurityContextAware {
    private IgniteComputeInternal compute;
    private final SecurityService securityService;

    public ComputeController(IgniteComputeInternal compute, SecurityService securityService) {
        this.compute = compute;
        this.securityService = securityService;
    }

    @Override
    public CompletableFuture<Collection<JobState>> jobStates() {
        return this.secured(() -> this.compute.statesAsync().thenApply(states -> states.stream().map(ComputeController::toJobState).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<JobState> jobState(UUID jobId) {
        return this.secured(() -> this.jobState0(jobId));
    }

    @Override
    public CompletableFuture<Void> updatePriority(UUID jobId, UpdateJobPriorityBody updateJobPriorityBody) {
        return this.secured(() -> this.compute.changePriorityAsync(jobId, updateJobPriorityBody.priority()).thenCompose(result -> this.handleOperationResult(jobId, (Boolean)result)));
    }

    @Override
    public CompletableFuture<Void> cancelJob(UUID jobId) {
        return this.secured(() -> this.compute.cancelAsync(jobId).thenCompose(result -> this.handleOperationResult(jobId, (Boolean)result)));
    }

    private CompletableFuture<Void> handleOperationResult(UUID jobId, @Nullable Boolean result) {
        if (result == null) {
            return CompletableFuture.failedFuture(new ComputeJobNotFoundException(jobId.toString()));
        }
        if (!result.booleanValue()) {
            return this.jobState0(jobId).thenCompose(state -> CompletableFuture.failedFuture(new ComputeJobStatusException(jobId.toString(), state.status())));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<JobState> jobState0(UUID jobId) {
        return this.compute.stateAsync(jobId).thenApply(state -> {
            if (state == null) {
                throw new ComputeJobNotFoundException(jobId.toString());
            }
            return ComputeController.toJobState(state);
        });
    }

    private static JobState toJobState(org.apache.ignite3.compute.JobState jobState) {
        return new JobState(jobState.id(), JobStatus.valueOf(jobState.status().toString()), jobState.createTime(), jobState.startTime(), jobState.finishTime());
    }

    @Override
    public void cleanResources() {
        this.compute = null;
    }

    @Override
    public SecurityService securityService() {
        return this.securityService;
    }
}

