/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.rest.api.snapshot.PathType;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotOperationType;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotStatus;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot operation info.")
public class SnapshotOperation {
    @Schema(description="ID of the operation.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final UUID operationId;
    @Schema(description="Status of the operation.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final SnapshotStatus status;
    @Schema(description="Type of the operation.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final SnapshotOperationType operation;
    @Schema(description="Time at which operation started in milliseconds since Unix Epoch format.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final long startTimeEpochMilli;
    @Schema(description="Point in time that corresponds to the system state the snapshot reflects, in milliseconds since Unix Epoch", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final Long timestampEpochMilli;
    @Schema(description="Target snapshot ID, for restore operations", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final UUID targetSnapshotId;
    @Schema(description="Parent Snapshot ID, for create operations", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final UUID parentSnapshotId;
    @Schema(description="Target table names. If both this and structureNames are empty, it means that all tables were used.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final Set<String> tableNames;
    @Schema(description="Target structure names. If both this and tablesNames are empty, it means that all structures were used.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonInclude
    private final Set<String> structureNames;
    @Schema(description="Description of the operation.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String description;
    @Schema(description="Name of the node.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String nodeName;
    @Schema(description="Number of rows saved.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Long rowsSaved;
    @Schema(description="The base URI used in the snapshot operation.")
    private final URI uri;
    @Schema(description="The path type used in the snapshot operation (LOCAL or REMOTE).")
    private final PathType pathType;
    @Schema(description="If force flag was used.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final boolean force;

    @JsonCreator
    public SnapshotOperation(@JsonProperty(value="operationId") UUID operationId, @JsonProperty(value="status") String status, @JsonProperty(value="operation") String operation, @JsonProperty(value="startTimeEpochMilli") long startTimeEpochMilli, @JsonProperty(value="timestampEpochMilli") @Nullable Long timestampEpochMilli, @JsonProperty(value="targetSnapshotId") @Nullable UUID targetSnapshotId, @JsonProperty(value="parentSnapshotId") @Nullable UUID parentSnapshotId, @JsonProperty(value="tableNames") Set<String> tableNames, @JsonProperty(value="structureNames") Set<String> structureNames, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="nodeName") @Nullable String nodeName, @JsonProperty(value="rowsSaved") @Nullable Long rowsSaved, @JsonProperty(value="uri") URI uri, @JsonProperty(value="pathType") String pathType, @JsonProperty(value="force") boolean force) {
        this.operationId = operationId;
        this.status = SnapshotStatus.valueOf(status);
        this.operation = SnapshotOperationType.valueOf(operation);
        this.startTimeEpochMilli = startTimeEpochMilli;
        this.timestampEpochMilli = timestampEpochMilli;
        this.targetSnapshotId = targetSnapshotId;
        this.parentSnapshotId = parentSnapshotId;
        this.tableNames = tableNames;
        this.structureNames = structureNames;
        this.description = description;
        this.nodeName = nodeName;
        this.rowsSaved = rowsSaved;
        this.uri = uri;
        this.pathType = PathType.valueOf(pathType);
        this.force = force;
    }

    @JsonGetter(value="operationId")
    public UUID operationId() {
        return this.operationId;
    }

    @JsonGetter(value="status")
    public SnapshotStatus status() {
        return this.status;
    }

    @JsonGetter(value="operation")
    public SnapshotOperationType operation() {
        return this.operation;
    }

    @JsonGetter(value="startTimeEpochMilli")
    public long startTimeEpochMilli() {
        return this.startTimeEpochMilli;
    }

    @JsonGetter(value="timestampEpochMilli")
    @Nullable
    public Long timestampEpochMilli() {
        return this.timestampEpochMilli;
    }

    @JsonGetter(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonGetter(value="rowsSaved")
    @Nullable
    public Long rowsSaved() {
        return this.rowsSaved;
    }

    @JsonGetter(value="nodeName")
    @Nullable
    public String nodeName() {
        return this.nodeName;
    }

    @JsonGetter(value="targetSnapshotId")
    @Nullable
    public UUID targetSnapshotId() {
        return this.targetSnapshotId;
    }

    @JsonGetter(value="parentSnapshotId")
    @Nullable
    public UUID parentSnapshotId() {
        return this.parentSnapshotId;
    }

    @JsonGetter(value="tableNames")
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @JsonGetter(value="structureNames")
    public Set<String> structureNames() {
        return this.structureNames;
    }

    @JsonGetter(value="uri")
    public URI uri() {
        return this.uri;
    }

    @JsonGetter(value="pathType")
    public PathType pathType() {
        return this.pathType;
    }

    @JsonGetter(value="force")
    public boolean force() {
        return this.force;
    }
}

