/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotType;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot creation configuration.")
public class CreateCommand {
    @Schema(description="Type of the snapshot, FULL or INCREMENTAL.")
    private final SnapshotType snapshotType;
    @Schema(description="Set of fully-qualified table names that will be parts of the snapshot. If both this and structureNames are empty, all tables will be snapshotted.")
    private final Set<String> tableNames;
    @Schema(description="Set of fully-qualified structure names that will be parts of the snapshot. If both this and tableNames are empty, all structures will be snapshotted.")
    private final Set<String> structureNames;
    @Schema(description="Time for which the Snapshot should be taken in milliseconds since Unix Epoch format. If null, current time will be used")
    private final Long timestampEpochMilli;
    @Schema(description="The name of the snapshot path to the snapshot; null to use the default path.")
    private final String destination;
    @Schema(description="The encryption provider name.")
    private final String encryptionProvider;

    @JsonCreator
    public CreateCommand(@JsonProperty(value="snapshotType") SnapshotType snapshotType, @JsonProperty(value="tableNames") @Nullable Collection<String> tableNames, @JsonProperty(value="structureNames") @Nullable Collection<String> structureNames, @JsonProperty(value="timestampEpochMilli") @Nullable Long timestampEpochMilli, @JsonProperty(value="destination") @Nullable String destination, @JsonProperty(value="encryptionProvider") @Nullable String encryptionProvider) {
        this.snapshotType = snapshotType;
        if (this.snapshotType == null) {
            throw new IllegalArgumentException("Snapshot type must be provided");
        }
        Set<Object> set = this.tableNames = tableNames == null ? Collections.emptySet() : Set.copyOf(tableNames);
        if (this.tableNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Table names must not contain blank strings: " + tableNames);
        }
        Set<Object> set2 = this.structureNames = structureNames == null ? Collections.emptySet() : Set.copyOf(structureNames);
        if (this.structureNames.stream().anyMatch(StringUtils::nullOrBlank)) {
            throw new IllegalArgumentException("Structure names must not contain blank strings: " + structureNames);
        }
        this.timestampEpochMilli = timestampEpochMilli;
        this.destination = destination;
        this.encryptionProvider = encryptionProvider;
    }

    @JsonGetter(value="snapshotType")
    public SnapshotType snapshotType() {
        return this.snapshotType;
    }

    @JsonGetter(value="tableNames")
    public Set<String> tableNames() {
        return this.tableNames;
    }

    @JsonGetter(value="structureNames")
    public Set<String> structureNames() {
        return this.structureNames;
    }

    @JsonGetter(value="timestampEpochMilli")
    public Long timestampEpochMilli() {
        return this.timestampEpochMilli;
    }

    @JsonGetter(value="destination")
    public String destination() {
        return this.destination;
    }

    @JsonGetter(value="encryptionProvider")
    public String encryptionProvider() {
        return this.encryptionProvider;
    }

    public String toString() {
        return S.toString(this);
    }

    public static CreateCommandBuilder builder() {
        return new CreateCommandBuilder();
    }

    public static class CreateCommandBuilder {
        private SnapshotType snapshotType;
        @Nullable
        private Set<String> tableNames;
        @Nullable
        private Set<String> structureNames;
        @Nullable
        private Long timestampEpochMilli;
        @Nullable
        private String destination;
        @Nullable
        private String encryptionProvider;

        public CreateCommandBuilder snapshotType(SnapshotType snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public CreateCommandBuilder tableNames(@Nullable Set<String> tableNames) {
            this.tableNames = tableNames;
            return this;
        }

        public CreateCommandBuilder structureNames(@Nullable Set<String> structureNames) {
            this.structureNames = structureNames;
            return this;
        }

        public CreateCommandBuilder timestampEpochMilli(@Nullable Instant timestamp) {
            this.timestampEpochMilli = timestamp == null ? null : Long.valueOf(timestamp.toEpochMilli());
            return this;
        }

        public CreateCommandBuilder timestampEpochMilli(@Nullable Long timestampEpochMilli) {
            this.timestampEpochMilli = timestampEpochMilli;
            return this;
        }

        public CreateCommandBuilder destination(@Nullable String destination) {
            this.destination = destination;
            return this;
        }

        public CreateCommandBuilder encryptionProvider(@Nullable String encryptionProvider) {
            this.encryptionProvider = encryptionProvider;
            return this;
        }

        public CreateCommand build() {
            return new CreateCommand(this.snapshotType, this.tableNames, this.structureNames, this.timestampEpochMilli, this.destination, this.encryptionProvider);
        }
    }
}

