/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.partition.replicator.ZonePartitionReplicaListener;
import org.apache.ignite3.internal.partition.replicator.raft.ZonePartitionRaftListener;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionTxStateAccessImpl;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.ZonePartitionKey;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.storage.state.ThreadAssertingTxStateStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbStorage;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteBusyLock;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;
import org.apache.ignite3.internal.util.SafeTimeValuesTracker;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ZoneResourcesManager
implements ManuallyCloseable {
    private final TxStateRocksDbSharedStorage sharedTxStateStorage;
    private final TxManager txManager;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final TopologyService topologyService;
    private final CatalogService catalogService;
    private final FailureProcessor failureProcessor;
    private final Executor partitionOperationsExecutor;
    private final Map<Integer, ZoneResources> resourcesByZoneId = new ConcurrentHashMap<Integer, ZoneResources>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

    ZoneResourcesManager(TxStateRocksDbSharedStorage sharedTxStateStorage, TxManager txManager, OutgoingSnapshotsManager outgoingSnapshotsManager, TopologyService topologyService, CatalogService catalogService, FailureProcessor failureProcessor, Executor partitionOperationsExecutor) {
        this.sharedTxStateStorage = sharedTxStateStorage;
        this.txManager = txManager;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.topologyService = topologyService;
        this.catalogService = catalogService;
        this.failureProcessor = failureProcessor;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
    }

    ZonePartitionResources allocateZonePartitionResources(ZonePartitionId zonePartitionId, int partitionCount, PendingComparableValuesTracker<Long, Void> storageIndexTracker) {
        ZoneResources zoneResources = this.resourcesByZoneId.computeIfAbsent(zonePartitionId.zoneId(), zoneId -> new ZoneResources(this.createTxStateStorage((int)zoneId, partitionCount)));
        TxStatePartitionStorage txStatePartitionStorage = zoneResources.txStateStorage.getOrCreatePartitionStorage(zonePartitionId.partitionId());
        SafeTimeValuesTracker safeTimeTracker = new SafeTimeValuesTracker(HybridTimestamp.MIN_VALUE);
        ZonePartitionRaftListener raftGroupListener = new ZonePartitionRaftListener(zonePartitionId, txStatePartitionStorage, this.txManager, safeTimeTracker, storageIndexTracker, this.outgoingSnapshotsManager, this.partitionOperationsExecutor);
        PartitionSnapshotStorage snapshotStorage = new PartitionSnapshotStorage(new ZonePartitionKey(zonePartitionId.zoneId(), zonePartitionId.partitionId()), this.topologyService, this.outgoingSnapshotsManager, new PartitionTxStateAccessImpl(txStatePartitionStorage), this.catalogService, this.failureProcessor, this.partitionOperationsExecutor);
        ZonePartitionResources zonePartitionResources = new ZonePartitionResources(txStatePartitionStorage, raftGroupListener, snapshotStorage, storageIndexTracker);
        zoneResources.resourcesByPartitionId.put(zonePartitionId.partitionId(), zonePartitionResources);
        return zonePartitionResources;
    }

    @Nullable
    ZonePartitionResources getZonePartitionResources(ZonePartitionId zonePartitionId) {
        ZoneResources zoneResources = this.resourcesByZoneId.get(zonePartitionId.zoneId());
        if (zoneResources == null) {
            return null;
        }
        return zoneResources.resourcesByPartitionId.get(zonePartitionId.partitionId());
    }

    protected TxStateStorage createTxStateStorage(int zoneId, int partitionCount) {
        TxStateStorage txStateStorage = new TxStateRocksDbStorage(zoneId, partitionCount, this.sharedTxStateStorage);
        if (ThreadAssertions.enabled()) {
            txStateStorage = new ThreadAssertingTxStateStorage(txStateStorage);
        }
        txStateStorage.start();
        return txStateStorage;
    }

    @Override
    public void close() {
        this.busyLock.block();
        for (ZoneResources zoneResources : this.resourcesByZoneId.values()) {
            zoneResources.txStateStorage.close();
            zoneResources.resourcesByPartitionId.clear();
        }
        this.resourcesByZoneId.clear();
    }

    void destroyZonePartitionResources(ZonePartitionId zonePartitionId) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            ZoneResources resources = this.resourcesByZoneId.get(zonePartitionId.zoneId());
            if (resources != null) {
                resources.resourcesByPartitionId.remove(zonePartitionId.partitionId());
                resources.txStateStorage.destroyPartitionStorage(zonePartitionId.partitionId());
            }
        });
    }

    CompletableFuture<Void> removeTableResources(ZonePartitionId zonePartitionId, int tableId) {
        ZonePartitionResources resources = this.getZonePartitionResources(zonePartitionId);
        if (resources == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return resources.replicaListenerFuture.thenCompose(zoneReplicaListener -> {
            zoneReplicaListener.removeTableReplicaProcessor(tableId);
            resources.raftListener().removeTableProcessor(tableId);
            return resources.snapshotStorage().removeMvPartition(tableId);
        });
    }

    @TestOnly
    @Nullable
    TxStatePartitionStorage txStatePartitionStorage(int zoneId, int partitionId) {
        ZoneResources resources = this.resourcesByZoneId.get(zoneId);
        if (resources == null) {
            return null;
        }
        return resources.txStateStorage.getPartitionStorage(partitionId);
    }

    private static class ZoneResources {
        final TxStateStorage txStateStorage;
        final Map<Integer, ZonePartitionResources> resourcesByPartitionId = new ConcurrentHashMap<Integer, ZonePartitionResources>();

        ZoneResources(TxStateStorage txStateStorage) {
            this.txStateStorage = txStateStorage;
        }
    }

    public static class ZonePartitionResources {
        private final TxStatePartitionStorage txStatePartitionStorage;
        private final ZonePartitionRaftListener raftListener;
        private final PartitionSnapshotStorage snapshotStorage;
        private final PendingComparableValuesTracker<Long, Void> storageIndexTracker;
        private final CompletableFuture<ZonePartitionReplicaListener> replicaListenerFuture = new CompletableFuture();

        ZonePartitionResources(TxStatePartitionStorage txStatePartitionStorage, ZonePartitionRaftListener raftListener, PartitionSnapshotStorage snapshotStorage, PendingComparableValuesTracker<Long, Void> storageIndexTracker) {
            this.txStatePartitionStorage = txStatePartitionStorage;
            this.raftListener = raftListener;
            this.snapshotStorage = snapshotStorage;
            this.storageIndexTracker = storageIndexTracker;
        }

        public TxStatePartitionStorage txStatePartitionStorage() {
            return this.txStatePartitionStorage;
        }

        public ZonePartitionRaftListener raftListener() {
            return this.raftListener;
        }

        public PartitionSnapshotStorage snapshotStorage() {
            return this.snapshotStorage;
        }

        public PendingComparableValuesTracker<Long, Void> storageIndexTracker() {
            return this.storageIndexTracker;
        }

        public CompletableFuture<ZonePartitionReplicaListener> replicaListenerFuture() {
            return this.replicaListenerFuture;
        }
    }
}

