/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.annotations.Transferable;

@Transferable(value=6)
public interface StatementResult
extends NetworkMessage,
Serializable {
    public ByteBuffer result();

    default public boolean getAsBoolean() {
        if (this.result().capacity() != 1) {
            throw new IllegalStateException("Result is too big and can't be interpreted as boolean");
        }
        byte value = this.result().rewind().get();
        if ((value | 1) != 1) {
            throw new IllegalStateException("Result is ambiguous and can't be interpreted as boolean");
        }
        return value != 0;
    }

    default public int getAsInt() {
        if (this.result().capacity() != 4) {
            throw new IllegalStateException("Result can't be interpreted as int");
        }
        return this.result().rewind().getInt();
    }
}

