/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.ignite3.internal.index.FinalTransactionStateResolver;
import org.apache.ignite3.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.table.distributed.replicator.TransactionStateResolver;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.util.CompletableFutures;

public class RetryingFinalTransactionStateResolver
implements FinalTransactionStateResolver {
    private final TransactionStateResolver stateResolver;
    private final Executor delayedExecutor;

    public RetryingFinalTransactionStateResolver(TransactionStateResolver stateResolver, Executor executor) {
        this.stateResolver = stateResolver;
        this.delayedExecutor = CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS, executor);
    }

    @Override
    public CompletableFuture<TxState> resolveFinalTxState(UUID transactionId, ReplicationGroupId commitGroupId) {
        return ((CompletableFuture)((CompletableFuture)this.stateResolver.resolveTxState(transactionId, commitGroupId, null, Long.MAX_VALUE, TimeUnit.SECONDS).thenCompose(txMeta -> {
            if (txMeta != null && TxState.isFinalState(txMeta.txState())) {
                return CompletableFuture.completedFuture(txMeta.txState());
            }
            return this.retryResolve(transactionId, commitGroupId);
        })).handle((res, ex) -> {
            if (ex instanceof PrimaryReplicaAwaitTimeoutException) {
                return this.retryResolve(transactionId, commitGroupId);
            }
            return CompletableFutures.completedOrFailedFuture(res, ex);
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<TxState> retryResolve(UUID transactionId, ReplicationGroupId commitGroupId) {
        return CompletableFuture.supplyAsync(() -> this.resolveFinalTxState(transactionId, commitGroupId), this.delayedExecutor).thenCompose(Function.identity());
    }
}

