/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.index.FinalTransactionStateResolver;
import org.apache.ignite3.internal.index.IndexBuildCompletionListener;
import org.apache.ignite3.internal.index.IndexBuildTask;
import org.apache.ignite3.internal.index.IndexBuildTaskId;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;

class IndexBuilder
implements ManuallyCloseable {
    static final int BATCH_SIZE = 100;
    private final Executor executor;
    private final ReplicaService replicaService;
    private final FailureProcessor failureProcessor;
    private final NodeProperties nodeProperties;
    private final FinalTransactionStateResolver finalTransactionStateResolver;
    private final IndexMetaStorage indexMetaStorage;
    private final Map<IndexBuildTaskId, IndexBuildTask> indexBuildTaskById = new ConcurrentHashMap<IndexBuildTaskId, IndexBuildTask>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private final List<IndexBuildCompletionListener> listeners = new CopyOnWriteArrayList<IndexBuildCompletionListener>();

    IndexBuilder(Executor executor, ReplicaService replicaService, FailureProcessor failureProcessor, NodeProperties nodeProperties, FinalTransactionStateResolver finalTransactionStateResolver, IndexMetaStorage indexMetaStorage) {
        this.executor = executor;
        this.replicaService = replicaService;
        this.failureProcessor = failureProcessor;
        this.nodeProperties = nodeProperties;
        this.finalTransactionStateResolver = finalTransactionStateResolver;
        this.indexMetaStorage = indexMetaStorage;
    }

    public void scheduleBuildIndex(int zoneId, int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, InternalClusterNode node, long enlistmentConsistencyToken, HybridTimestamp initialOperationTimestamp) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                for (IndexBuildCompletionListener listener : this.listeners) {
                    listener.onBuildCompletion(indexId, tableId, partitionId);
                }
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(zoneId, tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, this.indexCreationActivationTs(indexId), indexStorage, partitionStorage, this.replicaService, this.failureProcessor, this.nodeProperties, this.finalTransactionStateResolver, this.executor, this.busyLock, 100, node, this.listeners, enlistmentConsistencyToken, false, initialOperationTimestamp);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    public void scheduleBuildIndexAfterDisasterRecovery(int zoneId, int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, InternalClusterNode node, long enlistmentConsistencyToken, HybridTimestamp initialOperationTimestamp) {
        IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(zoneId, tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, this.indexCreationActivationTs(indexId), indexStorage, partitionStorage, this.replicaService, this.failureProcessor, this.nodeProperties, this.finalTransactionStateResolver, this.executor, this.busyLock, 100, node, this.listeners, enlistmentConsistencyToken, true, initialOperationTimestamp);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    private HybridTimestamp indexCreationActivationTs(int indexId) {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexId);
        assert (indexMeta != null) : "Index meta must be present for indexId=" + indexId;
        long tsLong = indexMeta.statusChange(MetaIndexStatus.REGISTERED).activationTimestamp();
        return HybridTimestamp.hybridTimestamp(tsLong);
    }

    public void stopBuildingTableIndexes(int tableId, int partitionId) {
        this.stopBuildingIndexes(taskId -> tableId == taskId.getTableId() && partitionId == taskId.getPartitionId());
    }

    public void stopBuildingZoneIndexes(int zoneId, int partitionId) {
        this.stopBuildingIndexes(taskId -> zoneId == taskId.getZoneId() && partitionId == taskId.getPartitionId());
    }

    public void stopBuildingIndexes(int indexId) {
        this.stopBuildingIndexes(taskId -> indexId == taskId.getIndexId());
    }

    private void stopBuildingIndexes(Predicate<IndexBuildTaskId> stopBuildIndexPredicate) {
        Iterator<Map.Entry<IndexBuildTaskId, IndexBuildTask>> it = this.indexBuildTaskById.entrySet().iterator();
        while (it.hasNext()) {
            IgniteUtils.inBusyLockSafe(this.busyLock, () -> {
                Map.Entry entry = (Map.Entry)it.next();
                if (stopBuildIndexPredicate.test((IndexBuildTaskId)entry.getKey())) {
                    it.remove();
                    ((IndexBuildTask)entry.getValue()).stop();
                }
            });
        }
    }

    @Override
    public void close() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
    }

    public void listen(IndexBuildCompletionListener listener) {
        this.listeners.add(listener);
    }

    public void stopListen(IndexBuildCompletionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndStartTaskIfAbsent(IndexBuildTaskId taskId, IndexBuildTask task) {
        IndexBuildTask previousTask = this.indexBuildTaskById.putIfAbsent(taskId, task);
        if (previousTask != null) {
            return;
        }
        try {
            task.start();
        }
        finally {
            task.getTaskFuture().whenComplete((unused, throwable) -> this.indexBuildTaskById.remove(taskId));
        }
    }
}

