/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.failure;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.failure.FailureType;
import org.apache.ignite3.internal.failure.NodeStopper;
import org.apache.ignite3.internal.failure.StackTraceCapturingException;
import org.apache.ignite3.internal.failure.configuration.FailureProcessorConfiguration;
import org.apache.ignite3.internal.failure.configuration.FailureProcessorView;
import org.apache.ignite3.internal.failure.handlers.AbstractFailureHandler;
import org.apache.ignite3.internal.failure.handlers.FailureHandler;
import org.apache.ignite3.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite3.internal.failure.handlers.StopNodeFailureHandler;
import org.apache.ignite3.internal.failure.handlers.StopNodeOrHaltFailureHandler;
import org.apache.ignite3.internal.failure.handlers.configuration.FailureHandlerView;
import org.apache.ignite3.internal.failure.handlers.configuration.StopNodeOrHaltFailureHandlerView;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.thread.ThreadUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FailureManager
implements FailureProcessor,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(FailureManager.class);
    private static final String FAILURE_LOG_MSG = "Critical system error detected. Will be handled accordingly to configured handler [hnd={}, failureCtx={}, failureCtxId={}]";
    private static final String IGNORED_FAILURE_LOG_MSG = "Possible failure suppressed according to a configured handler [hnd={}, failureCtx={}, failureCtxId={}]";
    private final FailureProcessorConfiguration configuration;
    private volatile FailureHandler handler;
    private final NodeStopper nodeStopper;
    @Nullable
    private FailureHandler interceptor;
    private volatile FailureContext failureCtx;
    private volatile byte @Nullable [] reserveBuf;
    private volatile boolean dumpThreadsOnFailure;
    private volatile long dumpThreadsThrottlingTimeout;
    @Nullable
    private volatile Map<FailureType, Long> threadDumpPerFailureTypeTs;
    private final FailureHandlerConfigurationListener configurationListener = new FailureHandlerConfigurationListener();

    public FailureManager(FailureHandler handler) {
        this.nodeStopper = () -> {};
        this.handler = handler;
        this.configuration = null;
    }

    public FailureManager(NodeStopper nodeStopper, FailureProcessorConfiguration configuration) {
        this.nodeStopper = nodeStopper;
        this.configuration = configuration;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.initFailureHandler();
        if (this.configuration != null) {
            this.configuration.listen(this.configurationListener);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (this.configuration != null) {
            this.configuration.stopListen(this.configurationListener);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public FailureContext failureContext() {
        return this.failureCtx;
    }

    public boolean dumpThreadsOnFailure() {
        return this.dumpThreadsOnFailure;
    }

    public long dumpThreadsThrottlingTimeout() {
        return this.dumpThreadsThrottlingTimeout;
    }

    @Override
    public boolean process(FailureContext failureCtx) {
        return this.process(failureCtx, this.handler);
    }

    private synchronized boolean process(FailureContext failureCtx, FailureHandler handler) {
        boolean invalidated;
        assert (failureCtx != null) : "Failure context is not initialized.";
        assert (handler != null) : "Failure handler is not initialized.";
        if (this.interceptor != null) {
            this.interceptor.onFailure(failureCtx);
        }
        if (this.failureCtx != null) {
            return false;
        }
        StackTraceCapturingException exceptionForLogging = new StackTraceCapturingException(failureCtx.message(), failureCtx.error());
        if (handler.ignoredFailureTypes().contains((Object)failureCtx.type())) {
            LOG.warn(IGNORED_FAILURE_LOG_MSG, exceptionForLogging, new Object[]{handler, failureCtx.type(), failureCtx.id()});
        } else {
            LOG.error(FAILURE_LOG_MSG, exceptionForLogging, new Object[]{handler, failureCtx.type(), failureCtx.id()});
        }
        if (this.reserveBuf != null && failureCtx.error() != null && ExceptionUtils.hasCauseOrSuppressed(failureCtx.error(), OutOfMemoryError.class)) {
            this.reserveBuf = null;
        }
        if (this.dumpThreadsOnFailure && !this.throttleThreadDump(failureCtx)) {
            String ctxIdMsg = IgniteStringFormatter.format(" [failureCtxId={}]", failureCtx.id());
            ThreadUtils.dumpThreads(LOG, ctxIdMsg, !handler.ignoredFailureTypes().contains((Object)failureCtx.type()));
        }
        if (invalidated = handler.onFailure(failureCtx)) {
            this.failureCtx = failureCtx;
            LOG.error("Ignite node is in invalid state due to a critical failure.", new Object[0]);
        }
        return invalidated;
    }

    private void initFailureHandler() {
        if (this.configuration == null) {
            assert (this.handler != null) : "Failure handler is not initialized.";
            return;
        }
        this.reconfigure((FailureProcessorView)this.configuration.value());
    }

    private synchronized void reconfigure(FailureProcessorView newConfiguration) {
        AbstractFailureHandler hnd;
        this.dumpThreadsOnFailure = newConfiguration.dumpThreadsOnFailure();
        this.dumpThreadsThrottlingTimeout = newConfiguration.dumpThreadsThrottlingTimeoutMillis();
        this.threadDumpPerFailureTypeTs = null;
        if (this.dumpThreadsOnFailure && this.dumpThreadsThrottlingTimeout > 0L) {
            EnumMap<FailureType, Long> dumpPerFailureTypeTs = new EnumMap<FailureType, Long>(FailureType.class);
            for (FailureType type : FailureType.values()) {
                dumpPerFailureTypeTs.put(type, 0L);
            }
            this.threadDumpPerFailureTypeTs = dumpPerFailureTypeTs;
        }
        if (this.reserveBuf == null || this.reserveBuf.length != newConfiguration.oomBufferSizeBytes()) {
            this.reserveBuf = new byte[newConfiguration.oomBufferSizeBytes()];
        }
        FailureHandlerView handlerView = newConfiguration.handler();
        switch (handlerView.type()) {
            case "noop": {
                hnd = new NoOpFailureHandler();
                break;
            }
            case "stop": {
                hnd = new StopNodeFailureHandler(this.nodeStopper);
                break;
            }
            case "stopOrHalt": {
                hnd = new StopNodeOrHaltFailureHandler(this.nodeStopper, (StopNodeOrHaltFailureHandlerView)handlerView);
                break;
            }
            default: {
                throw new IgniteException(ErrorGroups.Common.COMPONENT_NOT_STARTED_ERR, "Unknown failure handler type: " + handlerView.type());
            }
        }
        String[] ignoredFailureTypes = handlerView.ignoredFailureTypes();
        EnumSet<FailureType> ignoredFailureTypesSet = EnumSet.noneOf(FailureType.class);
        for (String ignoredFailureType : ignoredFailureTypes) {
            for (FailureType type : FailureType.values()) {
                if (!type.typeName().equals(ignoredFailureType)) continue;
                ignoredFailureTypesSet.add(type);
            }
        }
        hnd.ignoredFailureTypes(ignoredFailureTypesSet);
        this.handler = hnd;
        LOG.info("Configured failure handler: [hnd={}]", this.handler);
    }

    @TestOnly
    public synchronized void setInterceptor(@Nullable FailureHandler interceptor) {
        this.interceptor = interceptor;
    }

    FailureHandler handler() {
        return this.handler;
    }

    private boolean throttleThreadDump(FailureContext failureContext) {
        boolean throttle;
        FailureType type = failureContext.type();
        Map<FailureType, Long> dumpPerFailureTypeTs = this.threadDumpPerFailureTypeTs;
        long dumpThrottlingTimeout = this.dumpThreadsThrottlingTimeout;
        if (dumpThrottlingTimeout == 0L || dumpPerFailureTypeTs == null) {
            return false;
        }
        long curr = System.currentTimeMillis();
        Long last = dumpPerFailureTypeTs.get((Object)type);
        assert (last != null) : "Unknown failure type " + type;
        boolean bl = throttle = curr - last < dumpThrottlingTimeout;
        if (!throttle) {
            dumpPerFailureTypeTs.put(type, curr);
        } else {
            LOG.info("Thread dump is hidden due to throttling settings. Set 'dumpThreadsThrottlingTimeoutMillis' property to 0 to see all thread dumps [failureCtxId={}].", failureContext.id());
        }
        return throttle;
    }

    private class FailureHandlerConfigurationListener
    implements ConfigurationListener<FailureProcessorView> {
        private FailureHandlerConfigurationListener() {
        }

        @Override
        public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<FailureProcessorView> ctx) {
            FailureManager.this.reconfigure(ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        }
    }
}

