/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.SortedMap;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.ConfigurationChangeException;
import org.apache.ignite3.configuration.KeyIgnorer;
import org.apache.ignite3.configuration.RootKey;
import org.apache.ignite3.configuration.validation.ConfigurationValidationException;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.internal.configuration.ComponentNotStartedException;
import org.apache.ignite3.internal.configuration.ConfigurationMigrator;
import org.apache.ignite3.internal.configuration.DeletedKeysFilter;
import org.apache.ignite3.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite3.internal.configuration.RootInnerNode;
import org.apache.ignite3.internal.configuration.SuperRoot;
import org.apache.ignite3.internal.configuration.SuperRootChangeImpl;
import org.apache.ignite3.internal.configuration.direct.KeyPathNode;
import org.apache.ignite3.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite3.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite3.internal.configuration.storage.Data;
import org.apache.ignite3.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite3.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite3.internal.configuration.tree.InnerNode;
import org.apache.ignite3.internal.configuration.tree.NamedListNode;
import org.apache.ignite3.internal.configuration.util.ConfigurationFlattener;
import org.apache.ignite3.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite3.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationChanger
implements DynamicConfigurationChanger {
    private final ForkJoinPool pool = new ForkJoinPool(2);
    private final ConfigurationUpdateListener configurationUpdateListener;
    private final Map<String, RootKey<?, ?, ?>> rootKeys;
    private final Lazy<Map<String, Serializable>> defaultsMap = new Lazy<Map>(this::createDefaultsMap);
    private final ConfigurationStorage storage;
    private final ConfigurationValidator configurationValidator;
    private final ConfigurationMigrator migrator;
    private final KeyIgnorer keyIgnorer;
    private volatile StorageRoots storageRoots;
    private volatile ConfigurationSource initialConfiguration = ConfigurationUtil.EMPTY_CFG_SRC;
    private final CompletableFuture<Void> defaultsPersisted = new CompletableFuture();
    private final AtomicBoolean persistDefaultsTriggered = new AtomicBoolean(false);
    private final AtomicLong notificationListenerCnt = new AtomicLong();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final CompletableFuture<Void> startFuture = new CompletableFuture();
    private Collection<String> ignoredKeys;
    private volatile boolean updatesBlocked = false;

    private static void makeImmutable(InnerNode node) {
        if (node == null || !node.makeImmutable()) {
            return;
        }
        node.traverseChildren(new ConfigurationVisitor<Object>(){

            @Override
            @Nullable
            public Object visitInnerNode(Field field, String key, InnerNode node) {
                ConfigurationChanger.makeImmutable(node);
                return null;
            }

            @Override
            @Nullable
            public Object visitNamedListNode(Field field, String key, NamedListNode<?> node) {
                if (node.makeImmutable()) {
                    for (String namedListKey : node.namedListKeys()) {
                        ConfigurationChanger.makeImmutable(node.getInnerNode(namedListKey));
                    }
                }
                return null;
            }
        }, true);
    }

    public ConfigurationChanger(ConfigurationUpdateListener configurationUpdateListener, Collection<RootKey<?, ?, ?>> rootKeys, ConfigurationStorage storage, ConfigurationValidator configurationValidator, ConfigurationMigrator migrator, KeyIgnorer keyIgnorer) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        this.configurationUpdateListener = configurationUpdateListener;
        this.storage = storage;
        this.configurationValidator = configurationValidator;
        this.rootKeys = rootKeys.stream().collect(Collectors.toMap(RootKey::key, Function.identity()));
        this.migrator = migrator;
        this.keyIgnorer = keyIgnorer;
    }

    public abstract InnerNode createRootNode(RootKey<?, ?, ?> var1);

    private Function<String, RootInnerNode> rootCreator() {
        return key -> {
            RootKey<?, ?, ?> rootKey = this.rootKeys.get(key);
            return rootKey == null ? null : new RootInnerNode(rootKey, this.createRootNode(rootKey));
        };
    }

    public void start() {
        Data data;
        try {
            data = this.storage.readDataOnRecovery().get();
        }
        catch (ExecutionException e2) {
            throw new ConfigurationChangeException("Failed to initialize configuration: " + e2.getCause().getMessage(), e2.getCause());
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ConfigurationChangeException("Failed to initialize configuration: " + e3.getMessage(), e3);
        }
        HashMap<String, ? extends Serializable> storageValues = new HashMap<String, Serializable>(data.values());
        this.ignoredKeys = DeletedKeysFilter.ignoreDeleted(storageValues, this.keyIgnorer);
        long revision = data.changeId();
        SuperRoot superRoot = new SuperRoot(this.rootCreator());
        Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(storageValues);
        for (RootKey<?, ?, ?> rootKey : this.rootKeys.values()) {
            Map rootPrefixMap = (Map)dataValuesPrefixMap.get(rootKey.key());
            InnerNode rootNode = this.createRootNode(rootKey);
            if (rootPrefixMap != null) {
                ConfigurationUtil.fillFromPrefixMap(rootNode, rootPrefixMap);
            }
            superRoot.addRoot(rootKey, rootNode);
        }
        SuperRoot superRootNoDefaults = superRoot.copy();
        ConfigurationUtil.addDefaults(superRoot);
        if (revision == 0L) {
            this.initialConfiguration.descend(superRoot);
        }
        this.validateConfiguration(superRoot);
        this.storageRoots = new StorageRoots(superRootNoDefaults, superRoot, data.changeId(), new TreeMap<String, Serializable>(data.values()));
        this.storage.registerConfigurationListener(this.configurationStorageListener());
        if (!this.updatesBlocked) {
            this.persistModifiedConfiguration();
            this.defaultsPersisted.whenComplete((v, e) -> {
                if (e != null) {
                    this.startFuture.completeExceptionally((Throwable)e);
                } else {
                    this.startFuture.complete(null);
                }
            });
        } else {
            this.startFuture.complete(null);
        }
    }

    private void persistModifiedConfiguration() {
        if (!this.persistDefaultsTriggered.compareAndSet(false, true)) {
            return;
        }
        ConfigurationSource cfgSrc = this.storageRoots.changeId == 0L ? this.initialConfiguration : ConfigurationUtil.EMPTY_CFG_SRC;
        this.changeInternally(cfgSrc, true).whenComplete((v, e) -> {
            if (e == null) {
                this.defaultsPersisted.complete(null);
            } else {
                this.defaultsPersisted.completeExceptionally((Throwable)e);
            }
        });
    }

    public void initializeConfigurationWith(ConfigurationSource configurationSource) {
        assert (!this.startFuture.isDone()) : "ConfigurationChanger#initializeConfigurationWith must be called before the start.";
        this.initialConfiguration = configurationSource;
    }

    @Override
    public CompletableFuture<Void> change(ConfigurationSource source) {
        if (this.storageRoots == null) {
            throw new ComponentNotStartedException();
        }
        if (this.updatesBlocked) {
            throw new ConfigurationChangeException("Cannot change configuration while rolling upgrade is in progress.");
        }
        return this.defaultsPersisted.thenCompose(v -> this.changeInternally(source, false));
    }

    void unblockUpdates() {
        this.updatesBlocked = false;
        this.persistModifiedConfiguration();
    }

    void blockUpdates() {
        this.updatesBlocked = true;
    }

    public CompletableFuture<Void> onDefaultsPersisted() {
        return this.defaultsPersisted;
    }

    public CompletableFuture<Void> startFuture() {
        return this.startFuture;
    }

    @Override
    public <T> T getLatest(List<KeyPathNode> path) {
        Map<String, ? extends Serializable> storageData;
        assert (!path.isEmpty());
        assert (path instanceof RandomAccess) : path.getClass();
        assert (!path.get((int)0).unresolvedName) : path;
        HashMap<CallSite, Map<CallSite, Integer>> extras = new HashMap<CallSite, Map<CallSite, Integer>>();
        StringJoiner prefixJoiner = new StringJoiner(".");
        int pathSize = path.size();
        KeyPathNode lastPathNode = path.get(pathSize - 1);
        for (int idx = 0; idx < pathSize; ++idx) {
            KeyPathNode keyPathNode = path.get(idx);
            if (!keyPathNode.unresolvedName) {
                if (keyPathNode.namedListEntry) {
                    prefixJoiner.add(keyPathNode.key);
                    String prefix = prefixJoiner + ".";
                    extras.put((CallSite)((Object)prefix), Map.of(prefix + "<name>", "<name_placeholder>", prefix + "<order>", 0));
                    continue;
                }
                prefixJoiner.add(keyPathNode.key);
                continue;
            }
            assert (keyPathNode.namedListEntry) : path;
            String unresolvedNameKey = prefixJoiner + ".<ids>." + ConfigurationUtil.escape(keyPathNode.key);
            Serializable resolvedName = ConfigurationChanger.get(this.storage.readLatest(unresolvedNameKey));
            if (resolvedName == null) {
                throw new NoSuchElementException(prefixJoiner + "." + ConfigurationUtil.escape(keyPathNode.key));
            }
            assert (resolvedName instanceof UUID) : resolvedName;
            UUID uUID = (UUID)resolvedName;
            if (idx == pathSize - 2 && "<internal_id>".equals(lastPathNode.key)) {
                assert (!lastPathNode.unresolvedName) : path;
                return (T)uUID;
            }
            prefixJoiner.add(uUID.toString());
            String prefix = prefixJoiner + ".";
            extras.put((CallSite)((Object)prefix), Map.of(prefix + "<name>", keyPathNode.key, prefix + "<order>", 0));
        }
        if (lastPathNode.key.equals("<internal_id>") && !lastPathNode.unresolvedName && path.get((int)(pathSize - 2)).namedListEntry) {
            assert (!path.get((int)(pathSize - 2)).unresolvedName) : path;
            String nameStorageKey = prefixJoiner.toString().replaceAll(Pattern.quote("<internal_id>") + "$", "<name>");
            Serializable name = ConfigurationChanger.get(this.storage.readLatest(nameStorageKey));
            if (name != null) {
                return (T)UUID.fromString(path.get((int)(pathSize - 2)).key);
            }
            throw new NoSuchElementException(prefixJoiner.toString());
        }
        String prefix = prefixJoiner.toString();
        if (lastPathNode.key.equals("<internal_ids>") && !lastPathNode.unresolvedName && path.get((int)(pathSize - 1)).namedListEntry) {
            prefix = prefix.replaceAll(Pattern.quote("<internal_ids>") + "$", "<ids>.");
            storageData = ConfigurationChanger.get(this.storage.readAllLatest(prefix));
            return (T)List.copyOf(storageData.values());
        }
        if (lastPathNode.key.equals("<internal_id>") && !path.get((int)(pathSize - 2)).namedListEntry) {
            prefix = prefix.replaceAll(Pattern.quote(".<internal_id>") + "$", "");
        } else if (lastPathNode.key.contains("<injected_name>")) {
            prefix = prefix.replaceAll(Pattern.quote(".<injected_name>"), "");
        }
        storageData = ConfigurationChanger.get(this.storage.readAllLatest(prefix));
        HashMap<Object, ? extends Serializable> mergedData = new HashMap<Object, Serializable>();
        if (!storageData.isEmpty()) {
            mergedData.putAll(storageData);
            block1: for (Map.Entry entry : extras.entrySet()) {
                for (String storageKey : storageData.keySet()) {
                    String extrasPrefix;
                    if (!storageKey.startsWith(extrasPrefix = (String)entry.getKey())) continue;
                    for (Map.Entry extrasEntryMap : ((Map)entry.getValue()).entrySet()) {
                        mergedData.putIfAbsent((String)extrasEntryMap.getKey(), (Serializable)extrasEntryMap.getValue());
                    }
                    continue block1;
                }
            }
            if (lastPathNode.namedListEntry) {
                mergedData.put(prefix + ".<order>", Integer.valueOf(0));
            }
        }
        SuperRoot rootNode = new SuperRoot(this.rootCreator());
        ConfigurationUtil.fillFromPrefixMap(rootNode, ConfigurationUtil.toPrefixMap(mergedData));
        if (storageData.isEmpty()) {
            ((InnerNode)rootNode).construct(path.get((int)0).key, ConfigurationUtil.EMPTY_CFG_SRC, true);
        }
        ConfigurationUtil.addDefaults(rootNode);
        return ConfigurationUtil.findEx(path, rootNode);
    }

    public void stop() {
        IgniteUtils.shutdownAndAwaitTermination(this.pool, 10L, TimeUnit.SECONDS);
        this.defaultsPersisted.completeExceptionally(new NodeStoppingException());
        StorageRoots roots = this.storageRoots;
        if (roots != null) {
            roots.changeFuture.completeExceptionally(new NodeStoppingException());
        }
        this.storage.close();
    }

    @Override
    public InnerNode getRootNode(RootKey<?, ?, ?> rootKey) {
        return this.storageRoots.roots.getRoot(rootKey);
    }

    public SuperRoot superRoot() {
        StorageRoots localRoots = this.storageRoots;
        if (localRoots == null) {
            throw new ComponentNotStartedException();
        }
        return localRoots.roots;
    }

    private CompletableFuture<Void> changeInternally(ConfigurationSource src, boolean onStartup) {
        return ((CompletableFuture)this.storage.lastRevision().thenComposeAsync(storageRevision -> {
            assert (storageRevision != null);
            return this.changeInternally0(src, (long)storageRevision, onStartup);
        }, (Executor)this.pool)).exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (cause instanceof ConfigurationChangeException) {
                throw (ConfigurationChangeException)cause;
            }
            throw new ConfigurationChangeException("Failed to change configuration", cause);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> changeInternally0(ConfigurationSource src, long storageRevision, boolean onStartup) {
        this.rwLock.readLock().lock();
        try {
            Object object;
            StorageRoots localRoots = this.storageRoots;
            if (localRoots.changeId < storageRevision) {
                CompletionStage completionStage = localRoots.changeFuture.thenCompose(v -> this.changeInternally(src, onStartup));
                return completionStage;
            }
            SuperRoot curRoots = localRoots.roots;
            SuperRoot changes = curRoots.copy();
            src.reset();
            src.descend(changes);
            ConfigurationUtil.addDefaults(changes);
            this.migrator.migrate(new SuperRootChangeImpl(changes));
            Map<String, Serializable> allChanges = ConfigurationFlattener.createFlattenedUpdatesMap(localRoots.rootsWithoutDefaults, changes, localRoots.storageData);
            if (onStartup) {
                for (String ignoredValue : this.ignoredKeys) {
                    allChanges.put(ignoredValue, null);
                }
            }
            ConfigurationChanger.dropUnnecessarilyDeletedKeys(allChanges, localRoots);
            if (allChanges.isEmpty() && onStartup) {
                object = CompletableFutures.nullCompletedFuture();
                return object;
            }
            ConfigurationUtil.dropNulls(changes);
            this.validateConfiguration(curRoots, changes);
            if (!this.storage.supportDefaults()) {
                this.removeDefaultValues(allChanges);
            }
            object = this.storage.write(allChanges, localRoots.changeId).thenCompose(casWroteSuccessfully -> {
                if (casWroteSuccessfully.booleanValue()) {
                    return localRoots.changeFuture;
                }
                return localRoots.changeFuture.thenCompose(v -> this.changeInternally(src, onStartup));
            });
            return object;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void validateConfiguration(SuperRoot configuration) {
        List<ValidationIssue> validationIssues = this.configurationValidator.validate(configuration);
        if (!validationIssues.isEmpty()) {
            throw new ConfigurationValidationException(validationIssues);
        }
    }

    private void validateConfiguration(SuperRoot curRoots, SuperRoot changes) {
        List<ValidationIssue> validationIssues = this.configurationValidator.validate(curRoots, changes);
        if (!validationIssues.isEmpty()) {
            throw new ConfigurationValidationException(validationIssues);
        }
    }

    private ConfigurationStorageListener configurationStorageListener() {
        return changedEntries -> {
            StorageRoots oldStorageRoots = this.storageRoots;
            try {
                HashMap<String, ? extends Serializable> changedValues = new HashMap<String, Serializable>(changedEntries.values());
                SuperRoot oldSuperRoot = oldStorageRoots.roots;
                SuperRoot oldSuperRootNoDefaults = oldStorageRoots.rootsWithoutDefaults;
                SuperRoot newSuperRoot = oldSuperRoot.copy();
                SuperRoot newSuperNoDefaults = oldSuperRootNoDefaults.copy();
                DeletedKeysFilter.ignoreDeleted(changedValues, this.keyIgnorer);
                Map<String, ?> dataValuesPrefixMap = ConfigurationUtil.toPrefixMap(changedValues);
                ConfigurationUtil.ignoreLegacyKeys(oldStorageRoots.roots, dataValuesPrefixMap);
                ConfigurationUtil.compressDeletedEntries(dataValuesPrefixMap);
                ConfigurationUtil.fillFromPrefixMap(newSuperRoot, dataValuesPrefixMap);
                ConfigurationUtil.fillFromPrefixMap(newSuperNoDefaults, dataValuesPrefixMap);
                long newChangeId = changedEntries.changeId();
                NavigableMap<String, ? extends Serializable> newData = ConfigurationChanger.mergeData(oldStorageRoots.storageData, changedEntries.values());
                StorageRoots newStorageRoots = new StorageRoots(newSuperNoDefaults, newSuperRoot, newChangeId, newData);
                this.rwLock.writeLock().lock();
                try {
                    this.storageRoots = newStorageRoots;
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                long notificationNumber = this.notificationListenerCnt.incrementAndGet();
                CompletableFuture<Void> notificationFuture = this.configurationUpdateListener.onConfigurationUpdated(oldSuperRoot, newSuperRoot, newChangeId, notificationNumber);
                return notificationFuture.whenComplete((v, t) -> {
                    if (t == null) {
                        oldStorageRoots.changeFuture.complete(null);
                    } else {
                        oldStorageRoots.changeFuture.completeExceptionally((Throwable)t);
                    }
                });
            }
            catch (Throwable e) {
                oldStorageRoots.changeFuture.completeExceptionally(e);
                return CompletableFuture.failedFuture(e);
            }
        };
    }

    private static NavigableMap<String, ? extends Serializable> mergeData(NavigableMap<String, ? extends Serializable> currentData, Map<String, ? extends Serializable> delta) {
        TreeMap<String, ? extends Serializable> newState = new TreeMap<String, Serializable>((SortedMap<String, ? extends Serializable>)currentData);
        for (Map.Entry<String, ? extends Serializable> entry : delta.entrySet()) {
            if (entry.getValue() == null) {
                newState.remove(entry.getKey());
                continue;
            }
            newState.put(entry.getKey(), entry.getValue());
        }
        return newState;
    }

    private static void dropUnnecessarilyDeletedKeys(Map<String, Serializable> allChanges, StorageRoots localRoots) {
        allChanges.entrySet().removeIf(entry -> entry.getValue() == null && !localRoots.storageData.containsKey(entry.getKey()));
    }

    private void removeDefaultValues(Map<String, Serializable> allChanges) {
        this.defaultsMap.get().forEach((key, defaultValue) -> {
            Serializable change = (Serializable)allChanges.get(key);
            if (Objects.deepEquals(change, defaultValue)) {
                allChanges.put((String)key, (Serializable)null);
            }
        });
    }

    private Map<String, Serializable> createDefaultsMap() {
        SuperRoot superRoot = new SuperRoot(this.rootCreator());
        for (RootKey<?, ?, ?> rootKey : this.rootKeys.values()) {
            superRoot.addRoot(rootKey, this.createRootNode(rootKey));
        }
        SuperRoot defaults = superRoot.copy();
        ConfigurationUtil.addDefaults(defaults);
        return ConfigurationFlattener.createFlattenedUpdatesMap(superRoot, defaults, Collections.emptyNavigableMap());
    }

    @Override
    public long notificationCount() {
        return this.notificationListenerCnt.get();
    }

    private static <T> T get(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw new IgniteInternalException("Failed to read storage data", e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException("Failed to read storage data", (Throwable)e);
        }
    }

    public static interface ConfigurationUpdateListener {
        public CompletableFuture<Void> onConfigurationUpdated(@Nullable SuperRoot var1, SuperRoot var2, long var3, long var5);
    }

    private static class StorageRoots {
        private final SuperRoot rootsWithoutDefaults;
        private final SuperRoot roots;
        private final long changeId;
        private final NavigableMap<String, ? extends Serializable> storageData;
        private final CompletableFuture<Void> changeFuture = new CompletableFuture();

        private StorageRoots(SuperRoot rootsWithoutDefaults, SuperRoot roots, long changeId, NavigableMap<String, ? extends Serializable> storageData) {
            this.rootsWithoutDefaults = rootsWithoutDefaults;
            this.roots = roots;
            this.changeId = changeId;
            this.storageData = storageData;
            ConfigurationChanger.makeImmutable(roots);
            ConfigurationChanger.makeImmutable(rootsWithoutDefaults);
        }
    }
}

