/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.executor;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite3.internal.compute.executor.AbstractSecuredTableView;
import org.apache.ignite3.internal.table.criteria.CursorAdapter;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.AsyncCursor;
import org.apache.ignite3.lang.Cursor;
import org.apache.ignite3.table.ContinuousQueryOptions;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.criteria.Criteria;
import org.apache.ignite3.table.criteria.CriteriaQueryOptions;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredRecordView<R>
extends AbstractSecuredTableView
implements RecordView<R>,
Wrapper {
    private final RecordView<R> delegate;

    SecuredRecordView(RecordView<R> delegate, Authorizer authorizer, SecurityContext context, QualifiedName name) {
        super(authorizer, context, name);
        this.delegate = delegate;
    }

    @Override
    public R get(@Nullable Transaction tx, R keyRec) {
        return this.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAsync(tx, keyRec));
    }

    @Override
    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAllAsync(tx, keyRecs));
    }

    @Override
    public boolean contains(@Nullable Transaction tx, R keyRec) {
        return this.sync(this.containsAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAsync(tx, keyRec));
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return this.sync(this.delegate.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAllAsync(tx, keys));
    }

    @Override
    public void upsert(@Nullable Transaction tx, R rec) {
        this.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.upsertAsync(tx, rec));
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        this.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.upsertAllAsync(tx, recs));
    }

    @Override
    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return this.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getAndUpsertAsync(tx, rec));
    }

    @Override
    public boolean insert(@Nullable Transaction tx, R rec) {
        return this.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.insertAsync(tx, rec));
    }

    @Override
    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return this.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.insertAllAsync(tx, recs));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R rec) {
        return this.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return this.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return this.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getAndReplaceAsync(tx, rec));
    }

    @Override
    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return this.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAsync(tx, keyRec));
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return this.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteExactAsync(tx, rec));
    }

    @Override
    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return this.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        return this.authorizer.authorizeThenCompose(this.context, this.getAndDeletePrivilege(), () -> this.delegate.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public void deleteAll(@Nullable Transaction tx) {
        this.sync(this.deleteAllAsync(tx));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllAsync(tx));
    }

    @Override
    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return this.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, options));
    }

    @Override
    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.authorizer.authorizeAsync(this.context, this.selectPrivilege()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                subscriber.onError((Throwable)throwable);
            } else {
                this.delegate.queryContinuously(subscriber, options);
            }
        });
    }

    @Override
    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return new CursorAdapter<R>(this.sync(this.queryAsync(tx, criteria, indexName, opts)));
    }

    @Override
    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.queryAsync(tx, criteria, indexName, opts));
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.delegate, classToUnwrap);
    }
}

