/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.treesitter.parser;

import org.apache.ignite3.internal.logger.Loggers;
import org.treesitter.TSLanguage;
import org.treesitter.TSParser;
import org.treesitter.TSTree;
import org.treesitter.TreeSitterHocon;
import org.treesitter.TreeSitterJson;
import org.treesitter.TreeSitterSql;
import org.treesitter.utils.NativeUtils;

public final class Parser {
    public static TSTree parseSql(String text) {
        return Parser.parseLanguage(text, (TSLanguage)new TreeSitterSql());
    }

    public static TSTree parseJson(String text) {
        return Parser.parseLanguage(text, (TSLanguage)new TreeSitterJson());
    }

    public static TSTree parseHocon(String text) {
        return Parser.parseLanguage(text, (TSLanguage)new TreeSitterHocon());
    }

    private static TSTree parseLanguage(String text, TSLanguage language) {
        TSParser parser = new TSParser();
        parser.setLanguage(language);
        return parser.parseString(null, text);
    }

    public static boolean isTreeSitterParserAvailable() {
        try {
            NativeUtils.loadLib((String)"lib/tree-sitter");
            return true;
        }
        catch (Exception e) {
            Loggers.forClass(Parser.class).info("TreeSitter library was not loaded", (Throwable)e);
            return false;
        }
    }
}

