/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.causality;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.causality.BaseVersionedValue;
import org.apache.ignite3.internal.causality.CompletionListener;
import org.apache.ignite3.internal.causality.DeletionListener;
import org.apache.ignite3.internal.causality.VersionedValue;
import org.jetbrains.annotations.Nullable;

public class CompletableVersionedValue<T>
implements VersionedValue<T> {
    private final BaseVersionedValue<T> versionedValue;

    public CompletableVersionedValue(String name) {
        this.versionedValue = new BaseVersionedValue(name, null);
    }

    public CompletableVersionedValue(String name, int maxHistorySize) {
        this.versionedValue = new BaseVersionedValue(name, maxHistorySize, null);
    }

    public CompletableVersionedValue(String name, Supplier<T> defaultValueSupplier) {
        this.versionedValue = new BaseVersionedValue<T>(name, defaultValueSupplier);
    }

    @Override
    public String name() {
        return this.versionedValue.name();
    }

    @Override
    public CompletableFuture<T> get(long causalityToken) {
        return this.versionedValue.get(causalityToken);
    }

    @Override
    @Nullable
    public T latest() {
        return this.versionedValue.latest();
    }

    @Override
    public long latestCausalityToken() {
        return this.versionedValue.latestCausalityToken();
    }

    @Override
    public void whenComplete(CompletionListener<T> action) {
        this.versionedValue.whenComplete(action);
    }

    @Override
    public void removeWhenComplete(CompletionListener<T> action) {
        this.versionedValue.removeWhenComplete(action);
    }

    @Override
    public void whenDelete(DeletionListener<T> action) {
        this.versionedValue.whenDelete(action);
    }

    @Override
    public void removeWhenDelete(DeletionListener<T> action) {
        this.versionedValue.removeWhenDelete(action);
    }

    public CompletableFuture<Void> complete(long causalityToken) {
        return this.versionedValue.complete(causalityToken);
    }

    public CompletableFuture<Void> complete(long causalityToken, T value) {
        return this.versionedValue.complete(causalityToken, CompletableFuture.completedFuture(value));
    }

    public CompletableFuture<Void> completeExceptionally(long causalityToken, Throwable throwable) {
        return this.versionedValue.complete(causalityToken, CompletableFuture.failedFuture(throwable));
    }
}

