/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.storage.RenameTableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;

public class RenameTableEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class RenameTableEntrySerializerV2
    implements CatalogObjectSerializer<RenameTableEntry> {
        RenameTableEntrySerializerV2() {
        }

        @Override
        public RenameTableEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            String newTableName = input.readUTF();
            return new RenameTableEntry(tableId, newTableName);
        }

        @Override
        public void writeTo(RenameTableEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(entry.tableId());
            output.writeUTF(entry.newTableName());
        }
    }
}

