/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.cache.CacheWriteMode;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogColumnContainer;
import org.apache.ignite3.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableProperties;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogTableDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry,
CatalogColumnContainer {
    public static final int INITIAL_TABLE_VERSION = 1;
    private final int zoneId;
    @Nullable
    private final Integer secondaryZoneId;
    private final int schemaId;
    private final int pkIndexId;
    @IgniteToStringExclude
    private final CatalogTableSchemaVersions schemaVersions;
    @IgniteToStringInclude
    private final IntList primaryKeyColumns;
    @IgniteToStringInclude
    private final IntList colocationColumns;
    @IgniteToStringExclude
    private final Map<String, Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnsByName;
    @IgniteToStringExclude
    private final Int2ObjectMap<Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnsById;
    private final String storageProfile;
    @Nullable
    private final String secondaryStorageProfile;
    private final boolean cache;
    @Nullable
    private final Integer expireColumnId;
    @Nullable
    private final Integer expireColumnIndexId;
    @Nullable
    private final Integer archiveColumnId;
    @Nullable
    private final Integer archiveColumnIndexId;
    private final boolean isLockedForAccess;
    private final CacheWriteMode cacheWriteMode;
    private final CatalogSecondaryStorageState secondaryStorageState;
    private final boolean securityEnabled;
    private final CatalogTableProperties properties;

    private CatalogTableDescriptor(int id, int schemaId, int pkIndexId, String name, int zoneId, @Nullable Integer secondaryZoneId, IntList pkCols, @Nullable IntList colocationCols, CatalogTableSchemaVersions schemaVersions, String storageProfile, @Nullable String secondaryStorageProfile, HybridTimestamp timestamp, boolean cache, @Nullable Integer expireColumnId, @Nullable Integer expireColumnIndexId, boolean isLockedForAccess, CacheWriteMode cacheWriteMode, @Nullable Integer archiveColumnId, @Nullable Integer archiveColumnIndexId, CatalogSecondaryStorageState secondaryStorageState, boolean securityEnabled, CatalogTableProperties properties) {
        super(id, CatalogObjectDescriptor.Type.TABLE, name, timestamp);
        CatalogTableColumnDescriptor column;
        int i;
        this.schemaId = schemaId;
        this.pkIndexId = pkIndexId;
        this.zoneId = zoneId;
        this.secondaryZoneId = secondaryZoneId;
        this.primaryKeyColumns = pkCols;
        List<CatalogTableColumnDescriptor> columns = schemaVersions.latestVersionColumns();
        HashMap<String, Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnByName = IgniteUtils.newHashMap(columns.size());
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            columnByName.put(column.name(), (Int2ObjectMap.Entry<CatalogTableColumnDescriptor>)new AbstractInt2ObjectMap.BasicEntry(i, (Object)column));
        }
        this.columnsByName = columnByName;
        Int2ObjectOpenHashMap columnById = new Int2ObjectOpenHashMap();
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            columnById.put(column.id(), (Object)new AbstractInt2ObjectMap.BasicEntry(i, (Object)column));
        }
        this.columnsById = columnById;
        this.colocationColumns = Objects.requireNonNullElse(colocationCols, pkCols);
        this.schemaVersions = Objects.requireNonNull(schemaVersions, "No catalog schema versions.");
        this.storageProfile = Objects.requireNonNull(storageProfile, "No storage profile.");
        this.secondaryStorageProfile = secondaryStorageProfile;
        this.cache = cache;
        this.expireColumnId = expireColumnId;
        this.expireColumnIndexId = expireColumnIndexId;
        this.isLockedForAccess = isLockedForAccess;
        this.cacheWriteMode = cacheWriteMode;
        this.archiveColumnId = archiveColumnId;
        this.archiveColumnIndexId = archiveColumnIndexId;
        this.secondaryStorageState = secondaryStorageState;
        this.securityEnabled = securityEnabled;
        this.properties = properties;
    }

    public Builder copyBuilder() {
        return new Builder().id(this.id()).name(this.name()).timestamp(this.updateTimestamp()).zoneId(this.zoneId()).schemaId(this.schemaId()).primaryKeyIndexId(this.primaryKeyIndexId()).schemaVersions(this.schemaVersions).primaryKeyColumns(this.primaryKeyColumns).colocationColumns(this.colocationColumns).storageProfile(this.storageProfile()).secondaryZoneId(this.secondaryZoneId()).secondaryStorageProfile(this.secondaryStorageProfile()).cache(this.cache()).expireColumn(this.expireColumnId).expireColumnIndexId(this.expireColumnIndexId()).lockedForAccess(this.isLockedForAccess()).cacheWriteMode(this.cacheWriteMode).archiveColumn(this.archiveColumnId).archiveColumnIndexId(this.archiveColumnIndexId()).secondaryStorageState(this.secondaryStorageState()).rowLevelSecurityEnabled(this.securityEnabled()).staleRowsFraction(this.properties.staleRowsFraction()).minStaleRowsCount(this.properties.minStaleRowsCount());
    }

    public static Builder builder() {
        return new Builder();
    }

    public int schemaId() {
        return this.schemaId;
    }

    public CatalogTableSchemaVersions schemaVersions() {
        return this.schemaVersions;
    }

    public int zoneId() {
        return this.zoneId;
    }

    @Nullable
    public Integer secondaryZoneId() {
        return this.secondaryZoneId;
    }

    public int primaryKeyIndexId() {
        return this.pkIndexId;
    }

    public int latestSchemaVersion() {
        return this.schemaVersions.latestVersion();
    }

    public List<String> primaryKeyColumnNames() {
        return CatalogUtils.resolveColumnNames(this, this.primaryKeyColumns);
    }

    public IntList primaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<String> colocationColumnNames() {
        return CatalogUtils.resolveColumnNames(this, this.colocationColumns);
    }

    @Override
    public List<CatalogTableColumnDescriptor> columns() {
        return this.schemaVersions.latestVersionColumns();
    }

    public CacheWriteMode writeMode() {
        return this.cacheWriteMode;
    }

    @Nullable
    public CatalogTableColumnDescriptor column(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsByName.get(name);
        if (column != null) {
            return (CatalogTableColumnDescriptor)column.getValue();
        }
        return null;
    }

    @Nullable
    public CatalogTableColumnDescriptor columnById(int columnId) {
        Int2ObjectMap.Entry column = (Int2ObjectMap.Entry)this.columnsById.get(columnId);
        if (column != null) {
            return (CatalogTableColumnDescriptor)column.getValue();
        }
        return null;
    }

    public int columnIndex(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsByName.get(name);
        if (column != null) {
            return column.getIntKey();
        }
        return -1;
    }

    public int columnIndexById(int columnId) {
        Int2ObjectMap.Entry column = (Int2ObjectMap.Entry)this.columnsById.get(columnId);
        if (column != null) {
            return column.getIntKey();
        }
        return -1;
    }

    public boolean isPrimaryKeyColumn(String name) {
        CatalogTableColumnDescriptor column = this.column(name);
        return column != null && this.primaryKeyColumns.contains(column.id());
    }

    public boolean isColocationColumn(String name) {
        CatalogTableColumnDescriptor column = this.column(name);
        return column != null && this.colocationColumns.contains(column.id());
    }

    @Nullable
    public String expireColumn() {
        return this.expireColumnId == null ? null : this.columnById(this.expireColumnId).name();
    }

    @Nullable
    public Integer expireColumnIndexId() {
        return this.expireColumnIndexId;
    }

    @Nullable
    public ColumnType expireColumnType() {
        return this.expireColumnId == null ? null : this.columnById(this.expireColumnId).type();
    }

    @Nullable
    public String archiveColumn() {
        return this.archiveColumnId == null ? null : this.columnById(this.archiveColumnId).name();
    }

    @Nullable
    public Integer archiveColumnIndexId() {
        return this.archiveColumnIndexId;
    }

    @Nullable
    public ColumnType archiveColumnType() {
        return this.archiveColumnId == null ? null : this.columnById(this.archiveColumnId).type();
    }

    public boolean isLockedForAccess() {
        return this.isLockedForAccess;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogTableDescriptor.class, this, super.toString());
    }

    public String storageProfile() {
        return this.storageProfile;
    }

    @Nullable
    public String secondaryStorageProfile() {
        return this.secondaryStorageProfile;
    }

    public boolean cache() {
        return this.cache;
    }

    public CatalogSecondaryStorageState secondaryStorageState() {
        return this.secondaryStorageState;
    }

    public boolean securityEnabled() {
        return this.securityEnabled;
    }

    public CatalogTableProperties properties() {
        return this.properties;
    }

    public static final class Builder {
        private int id;
        private String name;
        private int zoneId;
        private int schemaId;
        private int pkIndexId;
        private CatalogTableSchemaVersions schemaVersions;
        @Nullable
        private List<CatalogTableColumnDescriptor> columns;
        private IntList primaryKeyColumns;
        @Nullable
        private IntList colocationColumns;
        private String storageProfile;
        private HybridTimestamp timestamp = CatalogManager.INITIAL_TIMESTAMP;
        private double staleRowsFraction;
        private long minStaleRowsCount;
        @Nullable
        private Integer secondaryZoneId;
        @Nullable
        private String secondaryStorageProfile;
        private boolean cache;
        @Nullable
        private Integer expireColumnId;
        @Nullable
        private Integer expireColumnIndexId;
        @Nullable
        private Integer archiveColumnId;
        @Nullable
        private Integer archiveColumnIndexId;
        private boolean isLockedForAccess;
        private CacheWriteMode cacheWriteMode = CacheWriteMode.SYNC;
        private CatalogSecondaryStorageState secondaryStorageState = CatalogSecondaryStorageState.NOT_AVAILABLE;
        private boolean rowLevelSecurityEnabled;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder zoneId(int zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public Builder primaryKeyIndexId(int primaryKeyIndexId) {
            this.pkIndexId = primaryKeyIndexId;
            return this;
        }

        public Builder schemaVersions(CatalogTableSchemaVersions schemaVersions) {
            this.schemaVersions = schemaVersions;
            return this;
        }

        public Builder newColumns(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
            return this;
        }

        public Builder primaryKeyColumns(IntList primaryKeyColumns) {
            this.primaryKeyColumns = primaryKeyColumns;
            return this;
        }

        public Builder colocationColumns(@Nullable IntList colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        public Builder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        public Builder secondaryZoneId(@Nullable Integer secondaryZoneId) {
            this.secondaryZoneId = secondaryZoneId;
            return this;
        }

        public Builder secondaryStorageProfile(@Nullable String secondaryStorageProfile) {
            this.secondaryStorageProfile = secondaryStorageProfile;
            return this;
        }

        public Builder cache(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder expireColumn(@Nullable Integer expireColumnId) {
            this.expireColumnId = expireColumnId;
            return this;
        }

        public Builder expireColumnIndexId(@Nullable Integer expireColumnIndexId) {
            this.expireColumnIndexId = expireColumnIndexId;
            return this;
        }

        public Builder archiveColumn(@Nullable Integer archiveColumnId) {
            this.archiveColumnId = archiveColumnId;
            return this;
        }

        public Builder archiveColumnIndexId(@Nullable Integer archiveColumnIndexId) {
            this.archiveColumnIndexId = archiveColumnIndexId;
            return this;
        }

        public Builder lockedForAccess(boolean lockedForAccess) {
            this.isLockedForAccess = lockedForAccess;
            return this;
        }

        public Builder cacheWriteMode(CacheWriteMode cacheWriteMode) {
            this.cacheWriteMode = cacheWriteMode;
            return this;
        }

        public Builder secondaryStorageState(CatalogSecondaryStorageState secondaryStorageState) {
            this.secondaryStorageState = secondaryStorageState;
            return this;
        }

        public Builder rowLevelSecurityEnabled(boolean securityEnabled) {
            this.rowLevelSecurityEnabled = securityEnabled;
            return this;
        }

        public Builder minStaleRowsCount(long minStaleRowsCount) {
            this.minStaleRowsCount = minStaleRowsCount;
            return this;
        }

        public Builder staleRowsFraction(double staleRowsFraction) {
            this.staleRowsFraction = staleRowsFraction;
            return this;
        }

        public CatalogTableDescriptor build() {
            if (this.schemaVersions == null && CollectionUtils.nullOrEmpty(this.columns)) {
                throw new IllegalArgumentException("Neither columns nor schemaVersions are defined.");
            }
            Objects.requireNonNull(this.primaryKeyColumns, "No primary key columns.");
            if (this.primaryKeyColumns.isEmpty()) {
                throw new IllegalArgumentException("No primary key columns.");
            }
            CatalogTableSchemaVersions newSchemaVersions = this.schemaVersions;
            if (!CollectionUtils.nullOrEmpty(this.columns)) {
                CatalogTableSchemaVersions.TableVersion version = new CatalogTableSchemaVersions.TableVersion(this.columns);
                newSchemaVersions = this.schemaVersions == null ? new CatalogTableSchemaVersions(version) : this.schemaVersions.append(version);
            }
            return new CatalogTableDescriptor(this.id, this.schemaId, this.pkIndexId, this.name, this.zoneId, this.secondaryZoneId, this.primaryKeyColumns, this.colocationColumns, newSchemaVersions, this.storageProfile, this.secondaryStorageProfile, this.timestamp, this.cache, this.expireColumnId, this.expireColumnIndexId, this.isLockedForAccess, this.cacheWriteMode, this.archiveColumnId, this.archiveColumnIndexId, this.secondaryStorageState, this.rowLevelSecurityEnabled, new CatalogTableProperties(this.staleRowsFraction, this.minStaleRowsCount));
        }
    }
}

