/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.client.handler.ClientResource;
import org.apache.ignite3.client.handler.ClientResourceRegistry;
import org.apache.ignite3.client.handler.NotificationSender;
import org.apache.ignite3.client.handler.ResponseWriter;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite3.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite3.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite3.internal.client.proto.ClientMessagePacker;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.QueryProcessor;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.lang.CancelHandle;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.internal.security.context.SecurityContextHolder;
import org.jetbrains.annotations.Nullable;

public class ClientSqlExecuteRequest {
    public static CompletableFuture<ResponseWriter> process(Executor operationExecutor, ClientMessageUnpacker in, long requestId, Map<Long, CancelHandle> cancelHandles, QueryProcessor sql, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, HybridTimestampTracker timestampTracker, boolean sqlPartitionAwarenessSupported, boolean sqlDirectTxMappingSupported, TxManager txManager, ClockService clockService, NotificationSender notificationSender, @Nullable String username) {
        CancelHandle cancelHandle = CancelHandle.create();
        cancelHandles.put(requestId, cancelHandle);
        SecurityContext context = SecurityContextHolder.getOrThrow();
        if (sqlDirectTxMappingSupported && !in.unpackBoolean()) {
            notificationSender = null;
        }
        long[] resIdHolder = new long[]{0L};
        InternalTransaction tx = ClientTableCommon.readTx(in, timestampTracker, resources, txManager, notificationSender, resIdHolder);
        ClientSqlProperties props = new ClientSqlProperties(in);
        String statement = in.unpackString();
        Object[] arguments = ClientSqlExecuteRequest.readArgsNotNull(in);
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp(in.unpackLong());
        timestampTracker.update(clientTs);
        boolean includePartitionAwarenessMeta = sqlPartitionAwarenessSupported && in.unpackBoolean();
        Function<Object, CompletableFuture> responseWriterFunction = none -> ClientSqlExecuteRequest.executeAsync(tx, sql, timestampTracker, statement, cancelHandle.token(), props.pageSize(), props.toSqlProps().userName(username), () -> cancelHandles.remove(requestId), arguments).thenCompose(asyncResultSet -> ClientSqlExecuteRequest.writeResultSetAsync(resources, asyncResultSet, metrics, includePartitionAwarenessMeta, sqlDirectTxMappingSupported).thenApply(rsWriter -> out -> {
            if (tx != null) {
                ClientTableCommon.writeTxMeta(out, timestampTracker, clockService, tx, resIdHolder[0]);
            }
            rsWriter.write(out);
        }));
        return CompletableFutures.nullCompletedFuture().thenComposeAsync(GridGainSecurity.with(context, responseWriterFunction), operationExecutor);
    }

    static Object[] readArgsNotNull(ClientMessageUnpacker in) {
        Object[] arguments = in.unpackObjectArrayFromBinaryTuple();
        return arguments == null ? ArrayUtils.OBJECT_EMPTY_ARRAY : arguments;
    }

    private static CompletableFuture<ResponseWriter> writeResultSetAsync(ClientResourceRegistry resources, AsyncResultSetImpl asyncResultSet, ClientHandlerMetricSource metrics, boolean includePartitionAwarenessMeta, boolean sqlDirectTxMappingSupported) {
        if (asyncResultSet.hasRowSet() && asyncResultSet.hasMorePages()) {
            try {
                metrics.cursorsActiveIncrement();
                ClientSqlResultSet clientResultSet = new ClientSqlResultSet(asyncResultSet, metrics);
                ClientResource resource = new ClientResource(clientResultSet, clientResultSet::closeAsync);
                long resourceId = resources.put(resource);
                return CompletableFuture.completedFuture(out -> ClientSqlExecuteRequest.writeResultSet(out, asyncResultSet, resourceId, includePartitionAwarenessMeta, sqlDirectTxMappingSupported));
            }
            catch (IgniteInternalCheckedException e) {
                return asyncResultSet.closeAsync().thenRun(() -> {
                    throw new IgniteInternalException(e.getMessage(), (Throwable)e);
                });
            }
        }
        return asyncResultSet.closeAsync().thenApply(v -> out -> ClientSqlExecuteRequest.writeResultSet(out, asyncResultSet, null, includePartitionAwarenessMeta, sqlDirectTxMappingSupported));
    }

    private static void writeResultSet(ClientMessagePacker out, AsyncResultSetImpl res, @Nullable Long resourceId, boolean includePartitionAwarenessMeta, boolean sqlDirectTxMappingSupported) {
        out.packLongNullable(resourceId);
        out.packBoolean(res.hasRowSet());
        out.packBoolean(res.hasMorePages());
        out.packBoolean(res.wasApplied());
        out.packLong(res.affectedRows());
        ClientSqlExecuteRequest.packMeta(out, res.metadata());
        if (includePartitionAwarenessMeta) {
            ClientSqlExecuteRequest.packPartitionAwarenessMeta(out, res.partitionAwarenessMetadata(), sqlDirectTxMappingSupported);
        }
        if (res.hasRowSet()) {
            ClientSqlCommon.packCurrentPage(out, res);
        }
    }

    private static void packMeta(ClientMessagePacker out, @Nullable ResultSetMetadata meta) {
        if (meta == null || meta.columns() == null) {
            out.packInt(0);
            return;
        }
        ClientSqlCommon.packColumns(out, meta.columns());
    }

    private static void packPartitionAwarenessMeta(ClientMessagePacker out, @Nullable PartitionAwarenessMetadata meta, boolean sqlDirectTxMappingSupported) {
        if (meta == null) {
            out.packNil();
            return;
        }
        out.packInt(meta.tableId());
        out.packIntArray(meta.indexes());
        out.packIntArray(meta.hash());
        if (sqlDirectTxMappingSupported) {
            out.packByte(meta.directTxMode().id);
        }
    }

    private static CompletableFuture<AsyncResultSetImpl<SqlRow>> executeAsync(@Nullable Transaction transaction, QueryProcessor qryProc, HybridTimestampTracker timestampTracker, String query, CancellationToken token, int pageSize, SqlProperties props, Runnable onComplete, Object ... arguments) {
        try {
            SqlProperties properties = new SqlProperties(props).allowedQueryTypes(SqlQueryType.SINGLE_STMT_TYPES).allowMultiStatement(false);
            CompletionStage fut = qryProc.queryAsync(properties, timestampTracker, (InternalTransaction)transaction, token, query, SecurityContextHolder.getOrThrow(), arguments).thenCompose(cur -> {
                cur.onClose().whenComplete((none, ignore) -> onComplete.run());
                return cur.requestNextAsync(pageSize).thenApply(batchRes -> new AsyncResultSetImpl((AsyncSqlCursor<InternalSqlRow>)cur, (AsyncCursor.BatchedResult<InternalSqlRow>)batchRes, pageSize));
            });
            return ((CompletableFuture)fut).exceptionally(th -> {
                onComplete.run();
                Throwable cause = ExceptionUtils.unwrapCause(th);
                throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(cause));
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(SqlExceptionMapperUtil.mapToPublicSqlException(e));
        }
    }
}

