/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.client.handler.ClientResource;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;

public class ClientResourceRegistry {
    private final Map<Long, ClientResource> res = new ConcurrentHashMap<Long, ClientResource>();
    private final AtomicLong idGen = new AtomicLong();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(ClientResource obj) throws IgniteInternalCheckedException {
        this.enter();
        try {
            long id = this.idGen.incrementAndGet();
            this.res.put(id, obj);
            long l = id;
            return l;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource get(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.get(id);
            if (res == null) {
                throw new IgniteException(ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR, "Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResource remove(long id) throws IgniteInternalCheckedException {
        this.enter();
        try {
            ClientResource res = this.res.remove(id);
            if (res == null) {
                throw new IgniteException(ErrorGroups.Client.RESOURCE_NOT_FOUND_ERR, "Failed to find resource with id: " + id);
            }
            ClientResource clientResource = res;
            return clientResource;
        }
        finally {
            this.leave();
        }
    }

    public void close() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        Throwable ex = null;
        for (ClientResource r : this.res.values()) {
            try {
                r.release();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new IgniteInternalException(e);
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        this.res.clear();
        if (ex != null) {
            throw ex;
        }
    }

    private void enter() throws IgniteInternalCheckedException {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalCheckedException("Resource registry is closed.");
        }
    }

    private void leave() {
        this.busyLock.leaveBusy();
    }
}

