/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet;

import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_DEFAULT_SCHEMA = "parquet.default.schema";
    private MessageType schema;
    private GroupWriter groupWriter;
    private Map<String, String> extraMetaData;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_DEFAULT_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)Objects.requireNonNull(configuration.get(PARQUET_DEFAULT_SCHEMA), PARQUET_DEFAULT_SCHEMA));
    }

    GroupWriteSupport(MessageType schema, Map<String, String> extraMetaData) {
        this.schema = schema;
        this.extraMetaData = extraMetaData;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.schema == null) {
            this.schema = GroupWriteSupport.getSchema(configuration);
        }
        return new WriteSupport.WriteContext(this.schema, this.extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, (GroupType)this.schema);
    }

    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

