/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.meta;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.gridgain.internal.snapshots.meta.HashIndexDescriptorView;
import org.gridgain.internal.snapshots.meta.IndexColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.IndexDescriptorView;
import org.gridgain.internal.snapshots.meta.MapDescriptorView;
import org.gridgain.internal.snapshots.meta.SequenceDescriptorView;
import org.gridgain.internal.snapshots.meta.SortedIndexDescriptorView;
import org.gridgain.internal.snapshots.meta.StorageProfilesDescriptorView;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.meta.TableColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSchemaView;
import org.gridgain.internal.snapshots.meta.TableVersionView;
import org.gridgain.internal.snapshots.meta.ZoneDescriptorView;
import org.jetbrains.annotations.Nullable;

public class DescriptorViewFactory {
    private final Catalog catalog;
    private final Map<Integer, ZoneDescriptorView> zoneViews = new HashMap<Integer, ZoneDescriptorView>();

    public DescriptorViewFactory(Catalog catalog) {
        this.catalog = catalog;
    }

    public Collection<ZoneDescriptorView> zoneViews() {
        return this.zoneViews.values();
    }

    public TableSchemaView createTableSchemaView(CatalogTableDescriptor tableDescriptor, @Nullable Integer parentSnapshotCatalogTableVersion) {
        ZoneDescriptorView zoneView = this.zoneViews.computeIfAbsent(tableDescriptor.zoneId(), this::createZoneDescriptorView);
        Integer secondaryZoneId = tableDescriptor.secondaryZoneId();
        ZoneDescriptorView secondaryZoneView = secondaryZoneId != null ? this.zoneViews.computeIfAbsent(secondaryZoneId, this::createZoneDescriptorView) : null;
        TableVersionView[] tableSchemaVersions = DescriptorViewFactory.createTableVersionViews(tableDescriptor.schemaVersions(), parentSnapshotCatalogTableVersion);
        CatalogSchemaDescriptor schemaDescriptor = DescriptorViewFactory.resolveSchema(this.catalog, tableDescriptor.schemaId());
        TableDescriptorView tableView = this.createTableDescriptorView(tableDescriptor, zoneView, secondaryZoneView, schemaDescriptor, tableSchemaVersions);
        int pkIndexId = tableDescriptor.primaryKeyIndexId();
        Integer archiveColumnIndexId = tableDescriptor.archiveColumnIndexId();
        Integer expireColumnIndexId = tableDescriptor.expireColumnIndexId();
        IntArrayList ignoredIndexIds = new IntArrayList(3);
        ignoredIndexIds.add(pkIndexId);
        if (archiveColumnIndexId != null) {
            ignoredIndexIds.add(archiveColumnIndexId.intValue());
        }
        if (expireColumnIndexId != null) {
            ignoredIndexIds.add(expireColumnIndexId.intValue());
        }
        IndexDescriptorView pkIndexView = DescriptorViewFactory.createIndexDescriptorView(tableDescriptor, DescriptorViewFactory.resolveIndex(this.catalog, pkIndexId));
        List<IndexDescriptorView> secondaryIndexViews = this.catalog.indexes(tableDescriptor.id()).stream().filter(arg_0 -> DescriptorViewFactory.lambda$createTableSchemaView$0((IntList)ignoredIndexIds, arg_0)).map(index -> DescriptorViewFactory.createIndexDescriptorView(tableDescriptor, index)).collect(Collectors.toList());
        return new TableSchemaView(tableView, pkIndexView, secondaryIndexViews);
    }

    public ZoneDescriptorView createZoneDescriptorView(int zoneId) {
        CatalogZoneDescriptor descriptor = DescriptorViewFactory.resolveZone(this.catalog, zoneId);
        return new ZoneDescriptorView(descriptor.name(), descriptor.partitions(), descriptor.replicas(), descriptor.dataNodesAutoAdjustScaleUp(), descriptor.dataNodesAutoAdjustScaleDown(), descriptor.filter(), new StorageProfilesDescriptorView(descriptor.storageProfiles()));
    }

    private TableDescriptorView createTableDescriptorView(CatalogTableDescriptor descriptor, ZoneDescriptorView zoneDescriptor, @Nullable ZoneDescriptorView secondaryZoneDescriptor, CatalogSchemaDescriptor schemaDescriptor, TableVersionView[] tableSchemaVersions) {
        return new TableDescriptorView(descriptor.id(), descriptor.latestSchemaVersion(), descriptor.name(), zoneDescriptor.name(), secondaryZoneDescriptor != null ? secondaryZoneDescriptor.name() : null, schemaDescriptor.name(), descriptor.columns().stream().map(TableColumnDescriptorView::new).collect(Collectors.toList()), tableSchemaVersions, descriptor.colocationColumnNames(), descriptor.storageProfile(), descriptor.secondaryStorageProfile(), descriptor.expireColumn(), descriptor.archiveColumn());
    }

    Collection<StructureView> createStructureDescriptorViews(Collection<CatalogSequenceDescriptor> sequences, Collection<CatalogMapDescriptor> maps) {
        Stream<SequenceDescriptorView> sequencesStream = sequences.stream().map(seq -> new SequenceDescriptorView(seq.name(), this.catalog.schema(seq.schemaId()).name(), seq.increment(), seq.minvalue(), seq.maxvalue(), seq.start(), seq.cachevalue(), this.catalog.table(seq.tableId()).name()));
        Stream<MapDescriptorView> mapsStream = maps.stream().map(map -> new MapDescriptorView(map.name(), this.catalog.schema(map.schemaId()).name(), this.catalog.table(map.tableId()).name()));
        return Stream.concat(sequencesStream, mapsStream).collect(Collectors.toList());
    }

    private static TableVersionView[] createTableVersionViews(CatalogTableSchemaVersions schemaVersions, @Nullable Integer parentSnapshotCatalogTableVersion) {
        int latestVersion = schemaVersions.latestVersion();
        if (parentSnapshotCatalogTableVersion != null && parentSnapshotCatalogTableVersion == latestVersion) {
            return new TableVersionView[0];
        }
        int firstToSave = parentSnapshotCatalogTableVersion == null ? latestVersion : parentSnapshotCatalogTableVersion + 1;
        TableVersionView[] versions = new TableVersionView[latestVersion - firstToSave + 1];
        for (int i = 0; i < versions.length; ++i) {
            List<TableColumnDescriptorView> columns = schemaVersions.get(firstToSave + i).columns().stream().map(TableColumnDescriptorView::new).collect(Collectors.toList());
            versions[i] = new TableVersionView(columns);
        }
        return versions;
    }

    private static IndexDescriptorView createIndexDescriptorView(CatalogTableDescriptor table, CatalogIndexDescriptor index) {
        if (index instanceof CatalogHashIndexDescriptor) {
            return DescriptorViewFactory.createHashIndexDescriptorView(table, (CatalogHashIndexDescriptor)index);
        }
        if (index instanceof CatalogSortedIndexDescriptor) {
            return DescriptorViewFactory.createSortedIndexDescriptorView(table, (CatalogSortedIndexDescriptor)index);
        }
        throw new IllegalArgumentException("Unknown index descriptor type: " + index.getClass());
    }

    private static HashIndexDescriptorView createHashIndexDescriptorView(CatalogTableDescriptor table, CatalogHashIndexDescriptor index) {
        return new HashIndexDescriptorView(index.name(), index.unique(), CatalogUtils.resolveColumnNames(table, index.columnIds()));
    }

    private static SortedIndexDescriptorView createSortedIndexDescriptorView(CatalogTableDescriptor table, CatalogSortedIndexDescriptor index) {
        return new SortedIndexDescriptorView(index.name(), index.unique(), index.columns().stream().map(column -> new IndexColumnDescriptorView(table.columnById(column.columnId()).name(), column.collation())).collect(Collectors.toList()));
    }

    private static CatalogSchemaDescriptor resolveSchema(Catalog catalog, int schemaId) {
        CatalogSchemaDescriptor descriptor = catalog.schema(schemaId);
        assert (descriptor != null) : String.format("Schema not found: id=%d, catalogVersion=%d", schemaId, catalog.version());
        return descriptor;
    }

    private static CatalogZoneDescriptor resolveZone(Catalog catalog, int zoneId) {
        CatalogZoneDescriptor descriptor = catalog.zone(zoneId);
        assert (descriptor != null) : String.format("Zone not found: id=%d, catalogVersion=%d", zoneId, catalog.version());
        return descriptor;
    }

    private static CatalogIndexDescriptor resolveIndex(Catalog catalog, int indexId) {
        CatalogIndexDescriptor descriptor = catalog.index(indexId);
        assert (descriptor != null) : String.format("Index not found: id=%d, catalogVersion=%d", indexId, catalog.version());
        return descriptor;
    }

    private static /* synthetic */ boolean lambda$createTableSchemaView$0(IntList ignoredIndexIds, CatalogIndexDescriptor indexDescriptor) {
        return !ignoredIndexIds.contains(indexDescriptor.id());
    }
}

