/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.lang.ByteArray;
import org.apache.ignite3.internal.metastorage.dsl.Condition;
import org.apache.ignite3.internal.metastorage.dsl.Conditions;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.util.ByteUtils;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;

public class PartitionResponsibilityTrigger {
    private final SnapshotManagerContext context;
    private final UUID nodeId;
    private final UUID snapshotId;

    PartitionResponsibilityTrigger(SnapshotManagerContext context, UUID nodeId, UUID snapshotId) {
        this.context = context;
        this.nodeId = nodeId;
        this.snapshotId = snapshotId;
    }

    CompletableFuture<Boolean> tryBecomeResponsible(TablePartitionId partition) {
        ByteArray partitionKey = MetaStorageKeys.partitionKey(this.snapshotId, partition);
        return this.context.metaStorageManager().invoke((Condition)Conditions.notExists(partitionKey), List.of(Operations.put(partitionKey, ByteUtils.uuidToBytes(this.nodeId))), List.of());
    }
}

