/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.snapshots.SnapshotManagerContext;

abstract class AbstractGlobalStateWatch
implements WatchListener {
    private static final IgniteLogger LOG = Loggers.forClass(AbstractGlobalStateWatch.class);
    protected final SnapshotManagerContext context;

    AbstractGlobalStateWatch(SnapshotManagerContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> onUpdate(WatchEvent event) {
        if (!this.context.busyLock().enterBusy()) {
            LOG.debug("Skipping Global Snapshot state update because the node is stopping", new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            for (EntryEvent entryEvent : event.entryEvents()) {
                Entry entry = entryEvent.newEntry();
                if (entry.value() == null) continue;
                this.processNewStateEntry(entry);
            }
            CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
            return completableFuture;
        }
        finally {
            this.context.busyLock().leaveBusy();
        }
    }

    abstract void processNewStateEntry(Entry var1);
}

