/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.assignments;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gridgain.internal.rbac.AssignmentOperationResult;
import org.gridgain.internal.rbac.assignments.RoleAssignment;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagement;
import org.gridgain.internal.rbac.assignments.exception.RoleAssignmentNotFoundException;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.roles.RoleView;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.rbac.store.LowerCaseString;
import org.gridgain.internal.rbac.store.OperationResultContainer;
import org.gridgain.internal.rbac.users.User;
import org.gridgain.internal.rbac.users.UserStore;
import org.gridgain.internal.rbac.users.exception.UserNotFoundException;

public class RoleAssignmentManagementImpl
implements RoleAssignmentManagement {
    private final RoleAssignment roleAssignment;
    private final UserStore userStore;
    private final RoleStore roleStore;
    private final Authorizer authorizer;

    public RoleAssignmentManagementImpl(RoleAssignment roleAssignment, UserStore userStore, RoleStore roleStore, Authorizer authorizer) {
        this.roleAssignment = roleAssignment;
        this.authorizer = authorizer;
        this.userStore = userStore;
        this.roleStore = roleStore;
    }

    @Override
    public CompletableFuture<Void> assignAsync(Set<String> roles, Set<String> toUsers) {
        return this.authorizer.authorizeThenCompose(Action.GRANT_ROLE, () -> this.roleAssignment.assign(roles, toUsers).thenAccept(RoleAssignmentManagementImpl::processOperationResult));
    }

    @Override
    public CompletableFuture<Void> revokeAsync(Set<String> roles, Set<String> fromUsers) {
        return this.authorizer.authorizeThenCompose(Action.REVOKE_ROLE, () -> this.roleAssignment.revoke(roles, fromUsers).thenAccept(RoleAssignmentManagementImpl::processOperationResult));
    }

    private static void processOperationResult(OperationResultContainer<AssignmentOperationResult> or) {
        switch (or.result()) {
            case SUCCESS: {
                return;
            }
            case ROLE_NOT_FOUND: {
                String message = or.value().formatError();
                throw RoleNotFoundException.fromMessage(message);
            }
            case USER_NOT_FOUND: {
                String message = or.value().formatError();
                throw UserNotFoundException.fromMessage(message);
            }
            case RA_NOT_FOUND: {
                String message = or.value().formatError();
                throw RoleAssignmentNotFoundException.fromMessage(message);
            }
        }
        throw new IllegalStateException("Unexpected operation result type: " + or);
    }

    @Override
    public CompletableFuture<Set<User>> usersByRoleAsync(String roleName) {
        return this.authorizer.authorizeAsync(RoleAssignmentManagementImpl.roleReadUserReadPrivileges()).thenApply(unused -> {
            Role role = (Role)this.roleStore.get(roleName);
            if (role == null) {
                throw new RoleNotFoundException(roleName);
            }
            return this.userStore.getAll().stream().filter(user -> user.roles().contains(roleName)).collect(Collectors.toSet());
        });
    }

    @Override
    public CompletableFuture<Set<String>> usernamesByRoleAsync(String roleName) {
        return this.authorizer.authorizeAsync(Action.READ_ROLE).thenApply(unused -> {
            Role role = (Role)this.roleStore.get(roleName);
            if (role == null) {
                throw new RoleNotFoundException(roleName);
            }
            return this.userStore.getAll().stream().filter(user -> user.roles().contains(roleName)).map(User::username).collect(Collectors.toSet());
        });
    }

    @Override
    public CompletableFuture<Map<User, Set<Role>>> usersViewsAsync() {
        return this.authorizer.authorizeAsync(RoleAssignmentManagementImpl.roleReadUserReadPrivileges()).thenApply(unused -> {
            Map roles = this.roleStore.getAllWithKeys();
            return this.userStore.getAll().stream().collect(Collectors.toMap(Function.identity(), user -> user.roles().stream().map(role -> (Role)roles.get(LowerCaseString.from(role))).collect(Collectors.toSet())));
        });
    }

    @Override
    public CompletableFuture<Set<RoleView>> rolesViewsAsync() {
        return this.authorizer.authorizeAsync(RoleAssignmentManagementImpl.roleReadUserReadPrivileges()).thenApply(unused -> {
            Collection roles = this.roleStore.getAll();
            Collection users = this.userStore.getAll();
            return roles.stream().map(role -> {
                Set<User> assignedUsers = users.stream().filter(user -> user.roles().contains(role.name())).collect(Collectors.toSet());
                return RoleView.builder().role((Role)role).assignedUsers(assignedUsers).build();
            }).collect(Collectors.toSet());
        });
    }

    @Override
    public CompletableFuture<Set<Role>> rolesByUserAsync(String username) {
        Privilege readUserPrivilege = Privilege.builder().action(Action.READ_USER).selector(Selector.user(username)).build();
        return this.authorizer.authorizeAsync(readUserPrivilege).thenApply(unused -> {
            User user = (User)this.userStore.get(username);
            if (user == null) {
                throw new UserNotFoundException(username);
            }
            List roles = this.roleStore.get((String[])user.roles().toArray(String[]::new));
            return roles.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        });
    }

    private static Set<Privilege> roleReadUserReadPrivileges() {
        return Set.of(Privilege.fromAction(Action.READ_USER), Privilege.fromAction(Action.READ_ROLE));
    }
}

