/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.notifications.ConfigurationListener;
import org.apache.ignite3.internal.event.AbstractEventProducer;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.KeyProviderNotFoundException;
import org.gridgain.internal.encryption.configuration.EncryptionConfiguration;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.gridgain.internal.encryption.event.EncryptionEvent;
import org.gridgain.internal.encryption.event.EncryptionEventParameters;
import org.gridgain.internal.encryption.event.KeyEncryptionKeyEventFactory;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.provider.DataEncryptionKeyWithProvider;
import org.gridgain.internal.encryption.provider.KeyProvider;
import org.gridgain.internal.encryption.provider.KeyProviderFactory;
import org.gridgain.internal.encryption.provider.configuration.KeyProviderView;
import org.gridgain.internal.encryption.utils.KeyProviderValidationUtils;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EncryptionManagerImpl
extends AbstractEventProducer<EncryptionEvent, EncryptionEventParameters>
implements EncryptionManager {
    private static final IgniteLogger LOG = Loggers.forClass(EncryptionManagerImpl.class);
    private static final InternalState INITIAL_STATE = new InternalState(false, Collections.emptyMap(), null);
    private final EncryptionConfiguration encryptionConfiguration;
    private final LicenseFeatureChecker featureChecker;
    private final ConfigurationListener<EncryptionView> encryptionConfigurationListener;
    private final KeyEncryptionKeyEventFactory keyEncryptionKeyEventFactory;
    private volatile InternalState state = INITIAL_STATE;

    public EncryptionManagerImpl(EncryptionConfiguration encryptionConfiguration, LicenseFeatureChecker featureChecker) {
        this.encryptionConfiguration = encryptionConfiguration;
        this.featureChecker = featureChecker;
        this.encryptionConfigurationListener = ctx -> {
            this.refreshConfiguration((EncryptionView)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        };
        this.keyEncryptionKeyEventFactory = new KeyEncryptionKeyEventFactory(this::fireEvent);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (this.state.encryptionEnabled) {
            this.featureChecker.checkFeature(LicenseFeature.TRANSPARENT_DATA_ENCRYPTION);
        }
        this.encryptionConfiguration.listen(this.encryptionConfigurationListener);
        this.encryptionConfiguration.listen(this.keyEncryptionKeyEventFactory);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.encryptionConfiguration.stopListen(this.keyEncryptionKeyEventFactory);
        this.encryptionConfiguration.stopListen(this.encryptionConfigurationListener);
        return CompletableFutures.nullCompletedFuture();
    }

    public void init(EncryptionView view) {
        this.state = EncryptionManagerImpl.fillEncryptionState(view);
    }

    public void initOnRecovery(EncryptionView view) {
        this.refreshConfiguration(view);
    }

    private void refreshConfiguration(@Nullable EncryptionView view) {
        try {
            this.state = EncryptionManagerImpl.fillEncryptionState(view);
            LOG.info("Master key successfully changed", new Object[0]);
        }
        catch (Exception exception) {
            LOG.error("Couldn't refresh key providers. Leaving the old settings", (Throwable)exception);
        }
    }

    private static InternalState fillEncryptionState(@Nullable EncryptionView view) {
        if (view == null) {
            return INITIAL_STATE;
        }
        Map<String, KeyProvider> providers = EncryptionManagerImpl.providersFromView(view);
        KeyProvider activeProvider = providers.get(KeyProviderValidationUtils.normalizeProviderName(view.activeProvider()));
        return new InternalState(view.enabled(), providers, activeProvider);
    }

    private static Map<String, KeyProvider> providersFromView(EncryptionView view) {
        NamedListView<? extends KeyProviderView> providers = view.providers();
        return providers.stream().collect(Collectors.toMap(providerView -> KeyProviderValidationUtils.normalizeProviderName(providerView.name()), KeyProviderFactory::createFromConfiguration));
    }

    @Override
    public boolean hasProvider(String providerName) {
        return this.state.providers.containsKey(KeyProviderValidationUtils.normalizeProviderName(providerName));
    }

    @Override
    public boolean encryptionEnabled() {
        return this.state.encryptionEnabled;
    }

    @Override
    public byte[] encryptDataKey(DataEncryptionKey key) {
        KeyProvider activeProvider = this.state.activeProvider;
        if (activeProvider == null) {
            throw new KeyProviderNotFoundException("activeProvider is null");
        }
        return EncryptionManagerImpl.doEncrypt(key, activeProvider);
    }

    @Override
    public byte[] encryptDataKeyByProvider(DataEncryptionKey key, String providerName) {
        KeyProvider keyProvider = this.state.getProvider(providerName);
        if (keyProvider == null) {
            throw new KeyProviderNotFoundException(providerName);
        }
        return EncryptionManagerImpl.doEncrypt(key, keyProvider);
    }

    private static byte[] doEncrypt(DataEncryptionKey key, KeyProvider keyProvider) {
        byte[] encDataKey = keyProvider.encryptKey(key);
        byte[] encProviderName = keyProvider.getProviderIdentifier().getBytes(StandardCharsets.UTF_8);
        byte[] encKeyIdentifier = keyProvider.getActiveKeyIdentifier().getBytes(StandardCharsets.UTF_8);
        ByteBuffer res = ByteBuffer.allocate(4 + encDataKey.length + 4 + encProviderName.length + encKeyIdentifier.length).order(ByteOrder.BIG_ENDIAN);
        res.putInt(encDataKey.length);
        res.put(encDataKey);
        res.putInt(encProviderName.length);
        res.put(encProviderName);
        res.put(encKeyIdentifier);
        return res.array();
    }

    @Override
    public DataEncryptionKey decryptDataKey(byte[] data) {
        return this.decryptDataKeyWithProvider(data).dataEncryptionKey();
    }

    @Override
    public DataEncryptionKeyWithProvider decryptDataKeyWithProvider(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        int dataKeyLen = buf.getInt();
        byte[] encDataKey = new byte[dataKeyLen];
        buf.get(encDataKey);
        int providerNameLen = buf.getInt();
        byte[] encProviderName = new byte[providerNameLen];
        buf.get(encProviderName);
        byte[] encKeyIdentifier = new byte[buf.remaining()];
        buf.get(encKeyIdentifier);
        String providerName = new String(encProviderName, StandardCharsets.UTF_8);
        KeyProvider provider = this.state.getProvider(providerName);
        if (provider == null) {
            throw new KeyProviderNotFoundException(providerName);
        }
        return new DataEncryptionKeyWithProvider(provider.decryptKey(encDataKey, new String(encKeyIdentifier, StandardCharsets.UTF_8)), providerName);
    }

    @TestOnly
    Map<String, KeyProvider> providers() {
        return Collections.unmodifiableMap(this.state.providers);
    }

    private CompletableFuture<Void> fireEvent(EncryptionEventParameters parameters) {
        return this.fireEvent(parameters.type(), parameters);
    }

    private static class InternalState {
        private final boolean encryptionEnabled;
        private final Map<String, KeyProvider> providers;
        @Nullable
        private final KeyProvider activeProvider;

        private InternalState(boolean encryptionEnabled, Map<String, KeyProvider> providers, @Nullable KeyProvider activeProvider) {
            this.encryptionEnabled = encryptionEnabled;
            this.providers = providers;
            this.activeProvider = activeProvider;
        }

        @Nullable
        private KeyProvider getProvider(String providerName) {
            return this.providers.get(KeyProviderValidationUtils.normalizeProviderName(providerName));
        }
    }
}

