/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.metastorage;

import java.util.Objects;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayBuilder;
import org.gridgain.internal.dcr.metastorage.MetaStoreByteArrayReader;

public class AuthConfigEntry {
    private final String username;
    private final String password;

    private AuthConfigEntry(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AuthConfigEntry.builder().username(this.username).password(this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfigEntry that = (AuthConfigEntry)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    byte[] toByteArray() {
        MetaStoreByteArrayBuilder byteArrayBuilder = new MetaStoreByteArrayBuilder();
        return byteArrayBuilder.appendString(this.username).appendString(this.password).build();
    }

    static AuthConfigEntry fromByteArray(byte[] arr) {
        MetaStoreByteArrayReader reader = new MetaStoreByteArrayReader(arr);
        AuthConfigEntry authConfigEntry = AuthConfigEntry.builder().username(reader.readString()).password(reader.readString()).build();
        assert (!reader.hasNext());
        return authConfigEntry;
    }

    public String toString() {
        return "AuthConfigEntry{username='" + this.username + "', password='********'}";
    }

    public static final class Builder {
        private String username;
        private String password;

        private Builder() {
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public AuthConfigEntry build() {
            Objects.requireNonNull(this.username, "Username must not be null.");
            Objects.requireNonNull(this.password, "Password must not be null.");
            return new AuthConfigEntry(this.username, this.password);
        }
    }
}

