/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.role.GetRoleCall;
import org.gridgain.internal.cli.call.rbac.role.ShowRoleCallInput;
import org.gridgain.internal.cli.decorators.RoleDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show role information"})
public class RoleShowReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Role name"})
    private String roleName;
    @CommandLine.Option(names={"--with-users"}, description={"Show role with assigned users"})
    private boolean users;
    @CommandLine.Option(names={"--with-privileges"}, description={"Show role with granted privileges"})
    private boolean privileges;
    @Inject
    private GetRoleCall getRoleCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.getRoleCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot show role")).print(new RoleDecorator()));
    }

    private ShowRoleCallInput input(String clusterUrl) {
        return ShowRoleCallInput.builder().clusterUrl(clusterUrl).roleName(this.roleName).showUsers(this.users).showPrivileges(this.privileges).build();
    }
}

