/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.license;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.rest.client.model.License;
import picocli.CommandLine;

public class LicenseUpdateOptions {
    @CommandLine.Parameters(description={"License file."})
    private Path licenseFile;

    public String license() {
        try {
            String license = Files.readString(this.licenseFile);
            LicenseUpdateOptions.validate(license, this.licenseFile.toString());
            return license;
        }
        catch (IOException e) {
            throw new IgniteCliException("Couldn't read license file " + this.licenseFile, e);
        }
    }

    private static void validate(String license, String path) {
        try {
            new Gson().fromJson(license, License.class);
        }
        catch (JsonSyntaxException e) {
            throw new IgniteCliException("The provided file is not a valid GridGain license file " + path, e);
        }
    }
}

