/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import jakarta.inject.Singleton;
import java.util.UUID;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.SnapshotManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.RestoreCommand;
import org.gridgain.internal.cli.call.snapshot.SnapshotRestoreCallInput;

@Singleton
public class SnapshotRestoreCall
implements Call<SnapshotRestoreCallInput, String> {
    private final ApiClientFactory clientFactory;

    public SnapshotRestoreCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(SnapshotRestoreCallInput input) {
        SnapshotManagementApi client = new SnapshotManagementApi(this.clientFactory.getClient(input.clusterUrl()).setReadTimeout(15000));
        try {
            RestoreCommand restoreCommand = new RestoreCommand().snapshotId(input.snapshotId()).tableNames(input.tableNames()).decryptionProvider(input.decryptionProvider()).source(input.source());
            UUID operationId = client.restore(restoreCommand);
            return DefaultCallOutput.success("Snapshot restoration has been started, operation ID " + operationId);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }
}

