/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.role;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RoleManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.rbac.role.DeleteRoleCallInput;

@Singleton
public class DeleteRoleCall
implements Call<DeleteRoleCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public DeleteRoleCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(DeleteRoleCallInput input) {
        try {
            this.deleteRoleRest(input);
            return DefaultCallOutput.success("Role " + input.roleName() + " deleted");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.url()));
        }
    }

    private void deleteRoleRest(DeleteRoleCallInput input) throws ApiException {
        new RoleManagementApi(this.apiClientFactory.getClient(input.url())).deleteRole(input.roleName(), input.withRevoke());
    }
}

