/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.raft.ReadCommand;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.ReadActionRequest;
import org.apache.ignite3.raft.jraft.rpc.ReadActionRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.ReadActionRequestSerializer;

public class ReadActionRequestImpl
implements ReadActionRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 4000;
    @IgniteToStringInclude
    private final ReadCommand command;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final boolean readOnlySafe;

    private ReadActionRequestImpl(ReadCommand command, String groupId, boolean readOnlySafe) {
        this.command = command;
        this.groupId = groupId;
        this.readOnlySafe = readOnlySafe;
    }

    @Override
    public ReadCommand command() {
        return this.command;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public boolean readOnlySafe() {
        return this.readOnlySafe;
    }

    public MessageSerializer serializer() {
        return ReadActionRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(ReadActionRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4000;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadActionRequestImpl otherMessage = (ReadActionRequestImpl)other;
        return Objects.equals(this.command, otherMessage.command) && Objects.equals(this.groupId, otherMessage.groupId) && this.readOnlySafe == otherMessage.readOnlySafe;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.readOnlySafe, this.command, this.groupId);
        return result;
    }

    @Override
    public ReadActionRequestImpl clone() {
        try {
            return (ReadActionRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadActionRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.command != null) {
            this.command.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.command != null) {
            this.command.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadActionRequestBuilder {
        private ReadCommand command;
        private String groupId;
        private boolean readOnlySafe;

        private Builder() {
        }

        @Override
        public ReadActionRequestBuilder command(ReadCommand command) {
            Objects.requireNonNull(command, "command is not marked @Nullable");
            this.command = command;
            return this;
        }

        @Override
        public ReadActionRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadActionRequestBuilder readOnlySafe(boolean readOnlySafe) {
            this.readOnlySafe = readOnlySafe;
            return this;
        }

        @Override
        public ReadCommand command() {
            return this.command;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public boolean readOnlySafe() {
            return this.readOnlySafe;
        }

        @Override
        public ReadActionRequest build() {
            return new ReadActionRequestImpl(Objects.requireNonNull(this.command, "command is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.readOnlySafe);
        }

        @Override
        public ReadActionRequest buildDeserialized() {
            return new ReadActionRequestImpl(this.command, this.groupId, this.readOnlySafe);
        }
    }
}

