/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.GetPeersResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.GetPeersResponseSerializer;

public class GetPeersResponseImpl
implements CliRequests.GetPeersResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1012;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final Collection<String> peersList;

    private GetPeersResponseImpl(Collection<String> learnersList, Collection<String> peersList) {
        this.learnersList = learnersList;
        this.peersList = peersList;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public Collection<String> peersList() {
        return this.peersList;
    }

    public MessageSerializer serializer() {
        return GetPeersResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetPeersResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 1012;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetPeersResponseImpl otherMessage = (GetPeersResponseImpl)other;
        return Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.peersList, otherMessage.peersList);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.learnersList, this.peersList);
        return result;
    }

    @Override
    public GetPeersResponseImpl clone() {
        try {
            return (GetPeersResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetPeersResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetPeersResponseBuilder {
        private Collection<String> learnersList;
        private Collection<String> peersList;

        private Builder() {
        }

        @Override
        public GetPeersResponseBuilder learnersList(Collection<String> learnersList) {
            Objects.requireNonNull(learnersList, "learnersList is not marked @Nullable");
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public GetPeersResponseBuilder peersList(Collection<String> peersList) {
            Objects.requireNonNull(peersList, "peersList is not marked @Nullable");
            this.peersList = peersList;
            return this;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public Collection<String> peersList() {
            return this.peersList;
        }

        @Override
        public CliRequests.GetPeersResponse build() {
            return new GetPeersResponseImpl(Objects.requireNonNull(this.learnersList, "learnersList is not marked @Nullable"), Objects.requireNonNull(this.peersList, "peersList is not marked @Nullable"));
        }

        @Override
        public CliRequests.GetPeersResponse buildDeserialized() {
            return new GetPeersResponseImpl(this.learnersList, this.peersList);
        }
    }
}

