/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.entity.LocalStorageOutter;
import org.apache.ignite3.raft.jraft.entity.StablePBMetaBuilder;
import org.apache.ignite3.raft.jraft.entity.StablePBMetaSerializer;

public class StablePBMetaImpl
implements LocalStorageOutter.StablePBMeta,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2003;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final String votedFor;

    private StablePBMetaImpl(long term, String votedFor) {
        this.term = term;
        this.votedFor = votedFor;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public String votedFor() {
        return this.votedFor;
    }

    public MessageSerializer serializer() {
        return StablePBMetaSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(StablePBMetaImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2003;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StablePBMetaImpl otherMessage = (StablePBMetaImpl)other;
        return Objects.equals(this.votedFor, otherMessage.votedFor) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.votedFor);
        return result;
    }

    @Override
    public StablePBMetaImpl clone() {
        try {
            return (StablePBMetaImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static StablePBMetaBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements StablePBMetaBuilder {
        private long term;
        private String votedFor;

        private Builder() {
        }

        @Override
        public StablePBMetaBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public StablePBMetaBuilder votedFor(String votedFor) {
            Objects.requireNonNull(votedFor, "votedFor is not marked @Nullable");
            this.votedFor = votedFor;
            return this;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public String votedFor() {
            return this.votedFor;
        }

        @Override
        public LocalStorageOutter.StablePBMeta build() {
            return new StablePBMetaImpl(this.term, Objects.requireNonNull(this.votedFor, "votedFor is not marked @Nullable"));
        }

        @Override
        public LocalStorageOutter.StablePBMeta buildDeserialized() {
            return new StablePBMetaImpl(this.term, this.votedFor);
        }
    }
}

