/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxMetaSerializer;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageClosedException;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageDestroyedException;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageException;
import org.apache.ignite3.internal.tx.storage.state.TxStateStorageRebalanceException;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateMetaRocksDbPartitionStorage;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbSharedStorage;
import org.apache.ignite3.internal.tx.storage.state.rocksdb.TxStateRocksDbStorage;
import org.apache.ignite3.internal.util.ByteUtils;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;

public class TxStateRocksDbPartitionStorage
implements TxStatePartitionStorage {
    public static final int PREFIX_SIZE_BYTES = 6;
    private static final int FULL_KEY_SIZE_BYES = 22;
    private final int partitionId;
    private final TxStateMetaRocksDbPartitionStorage metaStorage;
    private final Set<RocksIterator> iterators = ConcurrentHashMap.newKeySet();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final TxStateRocksDbSharedStorage sharedStorage;
    private final int tableOrZoneId;
    private final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    private final ColumnFamily dataColumnFamily;

    TxStateRocksDbPartitionStorage(int partitionId, TxStateRocksDbStorage parentStorage) {
        this.partitionId = partitionId;
        this.sharedStorage = parentStorage.sharedStorage;
        this.tableOrZoneId = parentStorage.id;
        this.dataColumnFamily = parentStorage.sharedStorage.txStateColumnFamily();
        this.metaStorage = new TxStateMetaRocksDbPartitionStorage(parentStorage.sharedStorage.txStateMetaColumnFamily(), this.tableOrZoneId, partitionId);
    }

    private static short shortPartitionId(int intValue) {
        return (short)intValue;
    }

    public void start() {
        this.busy(() -> {
            try {
                byte[] indexAndTermBytes = this.readLastAppliedIndexAndTerm();
                if (indexAndTermBytes == null) {
                    this.metaStorage.start();
                } else {
                    long lastAppliedIndex = ByteUtils.bytesToLong(indexAndTermBytes);
                    long lastAppliedTerm = ByteUtils.bytesToLong(indexAndTermBytes, 8);
                    this.metaStorage.startInCompatibilityMode(lastAppliedIndex, lastAppliedTerm);
                }
            }
            catch (RocksDBException e) {
                throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to start storage: [{}]", this.createStorageInfo()), e, new Object[0]);
            }
            return null;
        });
    }

    @Override
    @Nullable
    public TxMeta get(UUID txId) {
        return this.busy(() -> {
            try {
                this.throwExceptionIfStorageInProgressOfRebalance();
                byte[] txMetaBytes = this.dataColumnFamily.get(this.txIdToKey(txId));
                return txMetaBytes == null ? null : TxStateRocksDbPartitionStorage.deserializeTxMeta(txMetaBytes);
            }
            catch (RocksDBException e) {
                throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to get a value from storage: [{}]", this.createStorageInfo()), e, new Object[0]);
            }
        });
    }

    private static TxMeta deserializeTxMeta(byte[] txMetaBytes) {
        return VersionedSerialization.fromBytes(txMetaBytes, TxMetaSerializer.INSTANCE);
    }

    @Override
    public void putForRebalance(UUID txId, TxMeta txMeta) {
        this.busy(() -> {
            try {
                this.dataColumnFamily.put(this.txIdToKey(txId), TxStateRocksDbPartitionStorage.serializeTxMeta(txMeta));
                return null;
            }
            catch (RocksDBException e) {
                throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to put a value into storage: [{}]", this.createStorageInfo()), e, new Object[0]);
            }
        });
    }

    private static byte[] serializeTxMeta(TxMeta txMeta) {
        return VersionedSerialization.toBytes(txMeta, TxMetaSerializer.INSTANCE);
    }

    @Override
    public boolean compareAndSet(UUID txId, @Nullable TxState txStateExpected, TxMeta txMeta, long commandIndex, long commandTerm) {
        return (Boolean)this.updateData(writeBatch -> {
            boolean result;
            byte[] txIdBytes = this.txIdToKey(txId);
            byte[] txMetaExistingBytes = this.dataColumnFamily.get(this.txIdToKey(txId));
            if (txMetaExistingBytes == null && txStateExpected == null) {
                writeBatch.put(txIdBytes, TxStateRocksDbPartitionStorage.serializeTxMeta(txMeta));
                result = true;
            } else if (txMetaExistingBytes != null) {
                TxMeta txMetaExisting = TxStateRocksDbPartitionStorage.deserializeTxMeta(txMetaExistingBytes);
                if (txMetaExisting.txState() == txStateExpected) {
                    writeBatch.put(txIdBytes, TxStateRocksDbPartitionStorage.serializeTxMeta(txMeta));
                    result = true;
                } else {
                    result = txMetaExisting.txState() == txMeta.txState() && Objects.equals(txMetaExisting.commitTimestamp(), txMeta.commitTimestamp());
                }
            } else {
                result = false;
            }
            return result;
        }, commandIndex, commandTerm);
    }

    @Override
    public void remove(UUID txId, long commandIndex, long commandTerm) {
        this.updateData(writeBatch -> {
            writeBatch.delete(this.txIdToKey(txId));
            return null;
        }, commandIndex, commandTerm);
    }

    @Override
    public void removeAll(Collection<UUID> txIds, long commandIndex, long commandTerm) {
        Objects.requireNonNull(txIds, "Collection of the transaction IDs intended for removal cannot be null.");
        this.updateData(writeBatch -> {
            for (UUID txId : txIds) {
                writeBatch.delete(this.txIdToKey(txId));
            }
            return null;
        }, commandIndex, commandTerm);
    }

    private <T> T updateData(WriteClosure<?> writeClosure, long commandIndex, long commandTerm) {
        return (T)this.busy(() -> {
            Object t;
            this.throwExceptionIfStorageInProgressOfRebalance();
            WriteBatch writeBatch = new WriteBatch();
            try {
                Object result = writeClosure.apply(writeBatch);
                if (this.state.get() != StorageState.REBALANCE) {
                    this.metaStorage.updateLastApplied(writeBatch, commandIndex, commandTerm);
                }
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                t = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to update data in the storage: [{}]", this.createStorageInfo()), e, new Object[0]);
                }
            }
            writeBatch.close();
            return t;
        });
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> scan() {
        return this.busy(() -> {
            this.throwExceptionIfStorageInProgressOfRebalance();
            byte[] lowerBound = ByteBuffer.allocate(7).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putInt(this.tableOrZoneId).putShort(TxStateRocksDbPartitionStorage.shortPartitionId(this.partitionId)).put((byte)0).array();
            byte[] upperBound = this.partitionEndPrefix();
            final ReadOptions readOptions = new ReadOptions().setIterateUpperBound(new Slice(upperBound));
            final RocksIterator rocksIterator = this.dataColumnFamily.newIterator(readOptions);
            this.iterators.add(rocksIterator);
            try {
                rocksIterator.seek(lowerBound);
            }
            catch (Exception e) {
                this.iterators.remove(rocksIterator);
                rocksIterator.close();
                throw e;
            }
            return new RocksIteratorAdapter<IgniteBiTuple<UUID, TxMeta>>(rocksIterator){

                @Override
                protected IgniteBiTuple<UUID, TxMeta> decodeEntry(byte[] keyBytes, byte[] valueBytes) {
                    UUID key = TxStateRocksDbPartitionStorage.keyToTxId(keyBytes);
                    TxMeta txMeta = TxStateRocksDbPartitionStorage.deserializeTxMeta(valueBytes);
                    return new IgniteBiTuple<UUID, TxMeta>(key, txMeta);
                }

                @Override
                public boolean hasNext() {
                    return TxStateRocksDbPartitionStorage.this.busy(() -> {
                        TxStateRocksDbPartitionStorage.this.throwExceptionIfStorageInProgressOfRebalance();
                        return super.hasNext();
                    });
                }

                @Override
                public IgniteBiTuple<UUID, TxMeta> next() {
                    return TxStateRocksDbPartitionStorage.this.busy(() -> {
                        TxStateRocksDbPartitionStorage.this.throwExceptionIfStorageInProgressOfRebalance();
                        return (IgniteBiTuple)super.next();
                    });
                }

                @Override
                public void close() {
                    TxStateRocksDbPartitionStorage.this.iterators.remove(rocksIterator);
                    readOptions.close();
                    super.close();
                }
            };
        });
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.busy(() -> this.sharedStorage.awaitFlush(true));
    }

    @Override
    public long lastAppliedIndex() {
        return this.metaStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.metaStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        this.updateData(writeBatch -> null, lastAppliedIndex, lastAppliedTerm);
    }

    private byte @Nullable [] readLastAppliedIndexAndTerm() throws RocksDBException {
        byte[] lastAppliedIndexAndTermKey = ByteBuffer.allocate(6).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putInt(this.tableOrZoneId).putShort(TxStateRocksDbPartitionStorage.shortPartitionId(this.partitionId)).array();
        return this.dataColumnFamily.get(lastAppliedIndexAndTermKey);
    }

    @Override
    public void destroy() {
        StorageUtils.transitionToDestroyedState(this.state);
        this.closeStorageAndResources();
        try (WriteBatch writeBatch = new WriteBatch();){
            this.clearStorageData(writeBatch);
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
        }
        catch (Exception e) {
            throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to destroy storage: [{}]", this.createStorageInfo()), e, new Object[0]);
        }
    }

    private byte[] partitionStartPrefix() {
        return ByteBuffer.allocate(6).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putInt(this.tableOrZoneId).putShort(TxStateRocksDbPartitionStorage.shortPartitionId(this.partitionId)).array();
    }

    private byte[] partitionEndPrefix() {
        return ByteBuffer.allocate(6).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putInt(this.tableOrZoneId).putShort(TxStateRocksDbPartitionStorage.shortPartitionId(this.partitionId + 1)).array();
    }

    private byte[] txIdToKey(UUID txId) {
        return ByteBuffer.allocate(22).order(TxStateRocksDbSharedStorage.BYTE_ORDER).putInt(this.tableOrZoneId).putShort(TxStateRocksDbPartitionStorage.shortPartitionId(this.partitionId)).putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).array();
    }

    private static UUID keyToTxId(byte[] bytes) {
        long msb = ByteUtils.bytesToLong(bytes, 6);
        long lsb = ByteUtils.bytesToLong(bytes, 14);
        return new UUID(msb, lsb);
    }

    @Override
    public void close() {
        StorageState prevState = this.state.compareAndExchange(StorageState.RUNNABLE, StorageState.CLOSED);
        if (prevState.isTerminal()) {
            return;
        }
        if (prevState != StorageState.RUNNABLE) {
            this.throwExceptionDependingOnStorageState(prevState);
        }
        this.closeStorageAndResources();
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        this.transitionFromRunningStateTo(StorageState.REBALANCE);
        this.busyLock.block();
        try {
            CompletableFuture<Void> completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                this.clearStorageData(writeBatch);
                this.metaStorage.updateLastApplied(writeBatch, -1L, -1L);
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new TxStateStorageRebalanceException(IgniteStringFormatter.format("Failed to start rebalance: [{}]", this.createStorageInfo()), (Throwable)e);
                }
            }
            writeBatch.close();
            return completableFuture;
        }
        finally {
            this.busyLock.unblock();
        }
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        if (this.state.get() != StorageState.REBALANCE) {
            return CompletableFutures.nullCompletedFuture();
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.clearStorageData(writeBatch);
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
            this.state.set(StorageState.RUNNABLE);
        }
        catch (Exception e) {
            throw new TxStateStorageRebalanceException(IgniteStringFormatter.format("Failed to abort rebalance: [{}]", this.createStorageInfo()), (Throwable)e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        if (this.state.get() != StorageState.REBALANCE) {
            throw new TxStateStorageRebalanceException(IgniteStringFormatter.format("Rebalancing has not started: [{}]", this.createStorageInfo()));
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            this.metaStorage.updateLastApplied(writeBatch, partitionMeta.lastAppliedIndex(), partitionMeta.lastAppliedTerm());
            this.metaStorage.updateConfiguration(writeBatch, partitionMeta.groupConfig());
            LeaseInfo leaseInfo = partitionMeta.leaseInfo();
            if (leaseInfo != null) {
                this.metaStorage.updateLease(writeBatch, leaseInfo);
            }
            this.metaStorage.updateSnapshotInfo(writeBatch, partitionMeta.snapshotInfo());
            this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
            this.state.set(StorageState.RUNNABLE);
        }
        catch (Exception e) {
            throw new TxStateStorageRebalanceException(IgniteStringFormatter.format("Failed to finish rebalance: [{}]", this.createStorageInfo()), (Throwable)e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.transitionFromRunningStateTo(StorageState.CLEANUP);
        this.busyLock.block();
        try {
            CompletableFuture<Void> completableFuture;
            WriteBatch writeBatch = new WriteBatch();
            try {
                this.clearStorageData(writeBatch);
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
                completableFuture = CompletableFutures.nullCompletedFuture();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to cleanup storage: [{}]", this.createStorageInfo()), e, new Object[0]);
                }
            }
            writeBatch.close();
            return completableFuture;
        }
        finally {
            this.state.set(StorageState.RUNNABLE);
            this.busyLock.unblock();
        }
    }

    private void transitionFromRunningStateTo(StorageState targetState) {
        StorageState prevState = this.state.compareAndExchange(StorageState.RUNNABLE, targetState);
        if (prevState != StorageState.RUNNABLE) {
            this.throwExceptionDependingOnStorageState(prevState);
        }
    }

    @Override
    public void committedGroupConfiguration(byte[] config, long index, long term) {
        this.updateData(writeBatch -> {
            this.metaStorage.updateConfiguration(writeBatch, config);
            return null;
        }, index, term);
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.metaStorage.configuration();
    }

    @Override
    public void leaseInfo(LeaseInfo leaseInfo, long index, long term) {
        this.updateData(writeBatch -> {
            this.metaStorage.updateLease(writeBatch, leaseInfo);
            return null;
        }, index, term);
    }

    @Override
    public LeaseInfo leaseInfo() {
        return this.metaStorage.leaseInfo();
    }

    @Override
    public void snapshotInfo(byte[] snapshotInfo) {
        this.busy(() -> {
            this.throwExceptionIfStorageInProgressOfRebalance();
            try (WriteBatch writeBatch = new WriteBatch();){
                this.metaStorage.updateSnapshotInfo(writeBatch, snapshotInfo);
                this.sharedStorage.db().write(this.sharedStorage.writeOptions, writeBatch);
            }
            catch (RocksDBException e) {
                throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Failed to update data in the storage: [{}]", this.createStorageInfo()), e, new Object[0]);
            }
            return null;
        });
    }

    @Override
    public byte @Nullable [] snapshotInfo() {
        try {
            return this.metaStorage.snapshotInfo();
        }
        catch (RocksDBException e) {
            throw new TxStateStorageRebalanceException(IgniteStringFormatter.format("Failed to get snapshot info: [{}]", this.createStorageInfo()), (Throwable)e);
        }
    }

    private void clearStorageData(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.deleteRange(this.partitionStartPrefix(), this.partitionEndPrefix());
        this.metaStorage.clear(writeBatch);
    }

    private void closeStorageAndResources() {
        this.busyLock.block();
        RocksUtils.closeAll(this.iterators);
        this.iterators.clear();
    }

    private void throwExceptionIfStorageInProgressOfRebalance() {
        if (this.state.get() == StorageState.REBALANCE) {
            throw this.createStorageInProgressOfRebalanceException();
        }
    }

    private TxStateStorageException createStorageInProgressOfRebalanceException() {
        return new TxStateStorageRebalanceException(IgniteStringFormatter.format("Storage is in the process of rebalance: [{}]", this.createStorageInfo()));
    }

    private void throwExceptionDependingOnStorageState(StorageState state) {
        switch (state) {
            case CLOSED: {
                throw new TxStateStorageClosedException(IgniteStringFormatter.format("Transaction state storage is stopped: [{}]", this.createStorageInfo()));
            }
            case REBALANCE: {
                throw this.createStorageInProgressOfRebalanceException();
            }
            case CLEANUP: {
                throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Storage is in the process of cleanup: [{}]", this.createStorageInfo()), new Object[0]);
            }
            case DESTROYED: {
                throw new TxStateStorageDestroyedException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Storage has been destroyed: [{}]", this.createStorageInfo()));
            }
        }
        throw new TxStateStorageException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, IgniteStringFormatter.format("Unexpected state: [{}, state={}]", new Object[]{this.createStorageInfo(), state}), new Object[0]);
    }

    private String createStorageInfo() {
        return "tableOrZone=" + this.tableOrZoneId + ", partitionId=" + this.partitionId;
    }

    private <V> V busy(Supplier<V> supplier) {
        if (!this.busyLock.enterBusy()) {
            this.throwExceptionDependingOnStorageState(this.state.get());
        }
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @FunctionalInterface
    private static interface WriteClosure<T> {
        public T apply(WriteBatch var1) throws RocksDBException;
    }
}

