/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.VacuumTxStatesCommand;
import org.apache.ignite3.internal.tx.message.VacuumTxStatesCommandBuilder;

class VacuumTxStatesCommandDeserializer
implements MessageDeserializer<VacuumTxStatesCommand> {
    private final VacuumTxStatesCommandBuilder msg;

    VacuumTxStatesCommandDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.vacuumTxStatesCommand();
    }

    @Override
    public Class<VacuumTxStatesCommand> klass() {
        return VacuumTxStatesCommand.class;
    }

    @Override
    public VacuumTxStatesCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.vacuumTxStatesCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readSet("txIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txIds((Set<UUID>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(VacuumTxStatesCommand.class);
    }
}

